/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.sparkserver.library.swagger;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.models.Swagger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tecgraf.javautils.sparkserver.library.standard.JuServer;
import tecgraf.javautils.sparkserver.library.swagger.JuSwaggerReader;

public class JuSwaggerParser {
    private static final Logger logger = LoggerFactory.getLogger(JuSwaggerParser.class);

    public static Swagger getSwagger(JuServer server) throws JsonProcessingException {
        JuSwaggerReader reader = new JuSwaggerReader(server);
        Swagger swagger = reader.read();
        return swagger;
    }

    public static String getSwaggerJsonString(Swagger swagger) throws JsonProcessingException {
        String json = JuSwaggerParser.swaggerToJson(swagger);
        return json;
    }

    public static String swaggerToJson(Swagger swagger) throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        String json = objectMapper.writeValueAsString((Object)swagger);
        return json;
    }
}

