/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.sparkserver.library.swagger;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.models.ArrayModel;
import io.swagger.models.Contact;
import io.swagger.models.Info;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Response;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tecgraf.javautils.sparkserver.library.core.JuIController;
import tecgraf.javautils.sparkserver.library.core.JuIEndpoint;
import tecgraf.javautils.sparkserver.library.core.JuIPathParameter;
import tecgraf.javautils.sparkserver.library.core.JuIQueryParameter;
import tecgraf.javautils.sparkserver.library.core.JuIResponse;
import tecgraf.javautils.sparkserver.library.standard.JuServer;
import tecgraf.javautils.sparkserver.library.utils.JuStringUtilities;

public class JuSwaggerReader {
    private final int MAX_LEVEL = 10;
    private final JuServer server;
    private final Swagger swagger;

    public JuSwaggerReader(JuServer server) {
        this.server = server;
        this.swagger = new Swagger();
    }

    public Swagger read() {
        Info info = this.findInfo();
        this.swagger.setInfo(info);
        this.swagger.setHost(this.server.getHostAddress() + ":" + this.server.getHostPort());
        this.swagger.setSchemes(Collections.singletonList(Scheme.HTTP));
        this.server.getControllers().forEach(ctrl -> this.readController((JuIController)ctrl));
        return this.swagger;
    }

    private void readController(JuIController controller) {
        controller.getEndpoints().forEach(ep -> {
            Tag tag = new Tag();
            tag.name(controller.getName());
            tag.description(controller.getDescription());
            this.swagger.tag(tag);
            this.readEndpoint(controller, (JuIEndpoint)ep);
        });
    }

    private void readEndpoint(JuIController controller, JuIEndpoint endpoint) {
        Path path = new Path();
        Operation op = new Operation();
        op.description(endpoint.getDescription());
        op.setTags(Collections.singletonList(controller.getName()));
        List<String> consumes = this.findResponseConsume(endpoint);
        op.consumes(consumes);
        List<String> produces = this.findResponseProduce(endpoint);
        op.produces(produces);
        this.insertParameters(endpoint, op);
        this.insertResponses(endpoint, op);
        op.setSchemes(Collections.singletonList(Scheme.HTTP));
        path.set(this.findOperationName(endpoint), op);
        String fullPath = this.findFullPath(controller, endpoint);
        this.swagger.path(fullPath, path);
    }

    private void insertResponses(JuIEndpoint endpoint, Operation op) {
        Collection<JuIResponse> rps = endpoint.getResponses();
        rps.forEach(rp -> {
            Response response = new Response();
            response.setDescription(rp.getDescription());
            HashMap examples = new HashMap();
            HashMap<String, Object> exs = rp.getExamplesAsString();
            exs.forEach((name, value) -> examples.put(name, value));
            response.setExamples(examples);
            int statusCode = rp.getStatusCode();
            Class responseClass = endpoint.getRoute().getResponseClass();
            Class<?> containeredClass = endpoint.getRoute().getContainedClass();
            if (statusCode == 200 && !this.isClassPrimitive(responseClass)) {
                Model model = this.createModel(responseClass, containeredClass);
                response.setResponseSchema(model);
            }
            op.addResponse("" + statusCode, response);
        });
    }

    private void insertParameters(JuIEndpoint endpoint, Operation op) {
        Set<JuIPathParameter> pps = endpoint.getPathParameters();
        pps.forEach(pp -> {
            PathParameter parameter = new PathParameter();
            parameter.setName(pp.getName());
            parameter.setDescription(pp.getDescription());
            parameter.setExample(pp.getExampleAsString());
            parameter.setType(pp.getClassValue().getSimpleName().toLowerCase());
            op.addParameter((Parameter)parameter);
        });
        Set<JuIQueryParameter> qps = endpoint.getQueryParameters();
        qps.forEach(qp -> {
            QueryParameter parameter = new QueryParameter();
            parameter.setName(qp.getName());
            parameter.setDescription(qp.getDescription());
            parameter.setExample(qp.getExampleAsString());
            parameter.setType(qp.getClassValue().getSimpleName().toLowerCase());
            op.addParameter((Parameter)parameter);
        });
    }

    private List<String> findResponseProduce(JuIEndpoint endpoint) {
        Class responseClass = endpoint.getRoute().getResponseClass();
        List<String> consumes = this.isClassPrimitive(responseClass) ? Collections.singletonList("text/plain") : Collections.singletonList("application/json");
        return consumes;
    }

    private List<String> findResponseConsume(JuIEndpoint endpoint) {
        Class responseClass = endpoint.getRoute().getResponseClass();
        List<String> consumes = this.isClassPrimitive(responseClass) ? Collections.singletonList("text/plain") : Collections.singletonList("application/json");
        return consumes;
    }

    private Info findInfo() {
        Contact contact = new Contact();
        contact.setName(this.server.getContactName());
        Info info = new Info();
        info.contact(contact);
        info.description(this.server.getDescription());
        info.setTitle(this.server.getName());
        info.setVersion(this.server.getVersion());
        return info;
    }

    private String findFullPath(JuIController controller, JuIEndpoint endpoint) {
        Object pth = "/" + JuStringUtilities.getRealPath(controller, endpoint.getPath());
        pth = ((String)pth).replaceAll(":(\\w+)", "{$1}");
        return pth;
    }

    private String findOperationName(JuIEndpoint endpoint) {
        return endpoint.getVerb().name().toLowerCase();
    }

    private boolean isClassPrimitive(Class<?> clazz) {
        Class[] list = new Class[]{String.class, Integer.class, Long.class, Boolean.class, Short.class, Double.class, Float.class, Integer.TYPE, Double.TYPE, Float.TYPE, Character.TYPE, Long.TYPE, Short.TYPE, Boolean.TYPE};
        return !Arrays.stream(list).filter(c -> c.equals(clazz)).findFirst().isEmpty();
    }

    private Model createModel(Class clazz, Class containedClass) {
        if (clazz.isEnum()) {
            return this.createEnumModel(clazz);
        }
        if (List.class.isAssignableFrom(clazz) || clazz.isArray()) {
            return this.createArrayModel(containedClass);
        }
        return this.createClassModel(clazz);
    }

    private ArrayModel createArrayModel(Class containedClass) {
        ArrayModel model = new ArrayModel();
        if (containedClass != null) {
            String name = "elem";
            Property property = this.createClassProperty(1, "elem", containedClass);
            model.setItems(property);
        }
        return model;
    }

    private ModelImpl createClassModel(Class clazz) {
        ModelImpl model = new ModelImpl();
        model.setType("object");
        List<Field> fields = this.getAnnotatedFields(clazz);
        for (Field field : fields) {
            model.addProperty(this.getFieldName(field), this.createFieldProperty(1, field));
        }
        return model;
    }

    private Property createClassProperty(int level, String name, Class clazz) {
        if (level >= 10) {
            ObjectProperty property = new ObjectProperty();
            property.setName(name);
            return property;
        }
        if (this.isClassPrimitive(clazz)) {
            Property property = this.createBaseTypeProperty(clazz);
            property.setName(name);
            return property;
        }
        if (clazz.isEnum()) {
            Property property = this.createEnumProperty(clazz);
            property.setName(name);
            return property;
        }
        if (clazz.isArray()) {
            ArrayProperty property = new ArrayProperty();
            property.setName(name);
            return property;
        }
        if (clazz.getName().equalsIgnoreCase("java.lang.Object")) {
            ObjectProperty property = new ObjectProperty();
            property.setName(name);
            return property;
        }
        if (clazz.isAssignableFrom(List.class)) {
            ArrayProperty property = new ArrayProperty();
            property.setName(name);
            return property;
        }
        List<Field> fields = this.getAnnotatedFields(clazz);
        ObjectProperty property = new ObjectProperty();
        property.setName(name);
        HashMap<String, Property> hash = new HashMap<String, Property>();
        for (Field f : fields) {
            hash.put(this.getFieldName(f), this.createFieldProperty(level + 1, f));
        }
        property.setProperties(hash);
        return property;
    }

    private Property createEnumProperty(Class clazz) {
        StringProperty property = new StringProperty();
        T[] enumConstants = clazz.getEnumConstants();
        property.setEnum(Stream.of(enumConstants).map(Object::toString).collect(Collectors.toList()));
        return property;
    }

    private Property createFieldProperty(int level, Field field) {
        String fieldName = this.getFieldName(field);
        if (level >= 10) {
            ObjectProperty property = new ObjectProperty();
            property.setName(fieldName);
            return property;
        }
        Class<List> clazz = field.getType();
        if (this.isClassPrimitive(clazz)) {
            Property property = this.createBaseTypeProperty(clazz);
            property.setName(fieldName);
            return property;
        }
        if (clazz.isArray()) {
            ArrayProperty property = new ArrayProperty();
            property.setName(fieldName);
            return property;
        }
        if (clazz.isEnum()) {
            StringProperty property = new StringProperty();
            property.setName(fieldName);
            ?[] enumConstants = clazz.getEnumConstants();
            property.setEnum(Stream.of(enumConstants).map(Object::toString).collect(Collectors.toList()));
            return property;
        }
        if (clazz.getName().equalsIgnoreCase("java.lang.Object")) {
            ObjectProperty property = new ObjectProperty();
            property.setName(fieldName);
            return property;
        }
        if (clazz.isAssignableFrom(List.class)) {
            if (field.getGenericType() instanceof ParameterizedType) {
                Class listClass = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                Property property = this.createArrayProperty(level + 1, listClass);
                property.setName(fieldName);
                return property;
            }
            ObjectProperty property = new ObjectProperty();
            property.setName(fieldName);
            return property;
        }
        List<Field> fields = this.getAnnotatedFields(clazz);
        ObjectProperty property = new ObjectProperty();
        property.setName(fieldName);
        HashMap<String, Property> hash = new HashMap<String, Property>();
        for (Field f : fields) {
            hash.put(this.getFieldName(f), this.createFieldProperty(level + 1, f));
        }
        property.setProperties(hash);
        return property;
    }

    protected Property createBaseTypeProperty(Class<?> clazz) {
        if (Byte.TYPE.equals(clazz) || Short.TYPE.equals(clazz) || Integer.TYPE.equals(clazz) || Byte.class.equals(clazz) || Short.class.equals(clazz) || Integer.class.equals(clazz)) {
            return new IntegerProperty();
        }
        if (Long.TYPE.equals(clazz) || Long.class.equals(clazz)) {
            return new LongProperty();
        }
        if (Float.TYPE.equals(clazz) || Float.class.equals(clazz)) {
            return new FloatProperty();
        }
        if (Double.TYPE.equals(clazz) || Double.class.equals(clazz)) {
            return new DoubleProperty();
        }
        if (Character.TYPE.equals(clazz) || String.class.equals(clazz)) {
            return new StringProperty();
        }
        if (Boolean.TYPE.equals(clazz) || Boolean.class.equals(clazz)) {
            return new BooleanProperty();
        }
        return null;
    }

    protected <T> ModelImpl createEnumModel(Class clazz) {
        T[] enumConstants = clazz.getEnumConstants();
        ModelImpl model = new ModelImpl();
        model.setType("string");
        model.setEnum(Stream.of(enumConstants).map(Object::toString).collect(Collectors.toList()));
        return model;
    }

    protected Property createArrayProperty(int level, Class<?> clazz) {
        ArrayProperty arrayProperty = new ArrayProperty();
        if (clazz == null) {
            arrayProperty.setItems((Property)new ObjectProperty());
            return arrayProperty;
        }
        Property baseProperty = this.createClassProperty(level + 1, "elem", clazz);
        arrayProperty.setItems(baseProperty);
        return arrayProperty;
    }

    private List<Field> getAnnotatedFields(Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        return Arrays.stream(fields).filter(f -> f.isAnnotationPresent(JsonProperty.class)).collect(Collectors.toList());
    }

    private String getFieldName(Field field) {
        if (field.isAnnotationPresent(JsonProperty.class)) {
            JsonProperty annotation = field.getDeclaredAnnotation(JsonProperty.class);
            String value = annotation.value();
            return value == null ? field.getName() : value;
        }
        return field.getName();
    }
}

