/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.sparkserver.library.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tecgraf.javautils.sparkserver.library.core.JuIController;

public class JuStringUtilities {
    public static Long longOrNull(String txt) {
        if (txt == null) {
            throw new IllegalArgumentException("Invalid null to convertion!");
        }
        try {
            Long l = Long.parseLong(txt.trim());
            return l;
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public static Double doubleOrNull(String txt) {
        if (txt == null) {
            throw new IllegalArgumentException("Invalid null to conversion!");
        }
        try {
            double d = Double.parseDouble(txt.trim());
            return d;
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public static String getRealPath(JuIController controller, String path) {
        boolean noPrefix;
        String prefix = controller.getPathPrefix();
        boolean noPath = path == null || path.trim().isBlank();
        boolean bl = noPrefix = prefix == null || prefix.trim().isBlank();
        if (noPath && noPrefix) {
            return "/";
        }
        if (noPath) {
            return prefix;
        }
        if (noPrefix) {
            return path;
        }
        return prefix + "/" + path;
    }

    public static List<String> getAllMatches(String text, String regex) {
        ArrayList<String> matches = new ArrayList<String>();
        Matcher m = Pattern.compile("(?=(" + regex + "))").matcher(text);
        while (m.find()) {
            matches.add(m.group(1));
        }
        return matches;
    }
}

