/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.xml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xml.sax.InputSource;
import tecgraf.javautils.xml.XMLBasicElementFactory;
import tecgraf.javautils.xml.XMLBasicHandler;
import tecgraf.javautils.xml.XMLNullDataElement;
import tecgraf.javautils.xml.XMLReader;
import tecgraf.javautils.xml.XMLUtils;
import tecgraf.javautils.xml.exception.XMLException;

public class XMLValidator {
    private XMLReader xmlReader;
    private MyHandler handler;
    private ArrayList<String> errors = new ArrayList();

    public XMLValidator(Reader reader, String dtdPrefix, boolean validateDTD) {
        this.handler = new MyHandler(dtdPrefix, this.errors);
        this.xmlReader = new XMLReader(reader, this.handler, validateDTD);
    }

    public XMLValidator(InputStream inputStream, String dtdPrefix, boolean validateDTD) {
        this(new InputStreamReader(inputStream), dtdPrefix, validateDTD);
    }

    public XMLValidator(File file, String dtdPrefix, boolean validateDTD) throws FileNotFoundException {
        this(new FileReader(file), dtdPrefix, validateDTD);
    }

    public XMLValidator(String path, String dtdPrefix, boolean validateDTD) throws FileNotFoundException {
        this(new File(path), dtdPrefix, validateDTD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate() {
        try {
            this.xmlReader.read();
            boolean bl = this.errors.isEmpty();
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            XMLUtils.close(this.xmlReader);
        }
    }

    public int getErrorCount() {
        return this.errors.size();
    }

    public List<String> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    public static void main(String[] args) throws FileNotFoundException {
        XMLValidator validator = new XMLValidator(args[0], args[1], true);
        boolean valid = validator.validate();
        if (valid) {
            System.out.println("XML ok");
        } else {
            for (String msg : validator.getErrors()) {
                System.err.println(msg);
            }
            System.err.println(validator.getErrorCount() + " erros");
        }
    }

    private static class MyHandler
    extends XMLBasicHandler {
        private final String dtdPrefix;
        private final List<String> errors;

        MyHandler(String dtdPrefix, List<String> errors) {
            super(new XMLBasicElementFactory(XMLNullDataElement.class));
            this.dtdPrefix = dtdPrefix;
            this.errors = errors;
        }

        @Override
        public void warning(XMLException e) throws XMLException {
            this.logError("AVISO", e);
        }

        private void logError(String prefix, XMLException e) {
            String tag = e.getTag();
            String msg = tag != null ? String.format("[%s] tag %s: %s", prefix, tag, e.getMessage()) : String.format("[%s] %s", prefix, e.getMessage());
            this.errors.add(msg);
        }

        @Override
        public void fatalError(XMLException e) throws XMLException {
            this.logError("ERRO FATAL", e);
        }

        @Override
        public void error(XMLException e) throws XMLException {
            this.logError("ERRO", e);
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws XMLException {
            if (this.dtdPrefix == null) {
                return new InputSource(systemId);
            }
            String fixedSystemId = systemId.replaceFirst("(file:/|http:)//.*/(.*)$", this.dtdPrefix + "$2");
            return new InputSource(fixedSystemId);
        }
    }
}

