/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.xml.conversion;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import tecgraf.javautils.xml.conversion.ConversionDocument;
import tecgraf.javautils.xml.conversion.XMLConversionInterface;
import tecgraf.javautils.xml.conversion.exception.XMLConversionException;

public abstract class AbstractXMLConversion
implements XMLConversionInterface {
    private final XPath xpathInstance;
    private final String fromDTD;
    private final String toDTD;
    protected ConversionDocument document;
    private final Charset toCharset;

    protected AbstractXMLConversion(String fromDTD, String toDTD) throws XMLConversionException {
        this(fromDTD, toDTD, Charset.defaultCharset());
    }

    protected AbstractXMLConversion(String fromDTD, String toDTD, Charset charset) throws XMLConversionException {
        this.fromDTD = fromDTD;
        this.toDTD = toDTD;
        String charsetName = charset.name();
        if (!Charset.isSupported(charsetName)) {
            throw new XMLConversionException(XMLConversionException.XMLConversionExceptionType.UNSUPPORTED_CHARSET);
        }
        this.toCharset = charset;
        this.xpathInstance = XPathFactory.newInstance().newXPath();
    }

    protected List<Node> remove(Node startNode, String xpathQuery) throws XMLConversionException {
        NodeList nodeList;
        try {
            nodeList = (NodeList)this.xpathInstance.evaluate(xpathQuery, startNode, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new XMLConversionException(XMLConversionException.XMLConversionExceptionType.QUERY, (Throwable)e);
        }
        int numNodes = nodeList.getLength();
        ArrayList<Node> removedNodes = new ArrayList<Node>();
        for (int i = 0; i < numNodes; ++i) {
            Node nodeToBeRemoved = nodeList.item(i);
            Node parentNode = nodeToBeRemoved.getParentNode();
            removedNodes.add(parentNode.removeChild(nodeToBeRemoved));
        }
        return removedNodes;
    }

    protected List<Node> remove(String xpathQuery) throws XMLConversionException {
        return this.remove(this.document.getDocumentElement(), xpathQuery);
    }

    protected List<Node> renameAll(String xpathQuery, String newName) throws XMLConversionException {
        NodeList nodeList;
        try {
            nodeList = (NodeList)this.xpathInstance.evaluate(xpathQuery, this.document.getDocumentElement(), XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new XMLConversionException(XMLConversionException.XMLConversionExceptionType.QUERY, (Throwable)e);
        }
        int numNodes = nodeList.getLength();
        ArrayList<Node> renamedNodes = new ArrayList<Node>();
        for (int i = 0; i < numNodes; ++i) {
            Node nodeToBeRenamed = nodeList.item(i);
            renamedNodes.add(this.document.renameNode(nodeToBeRenamed, null, newName));
        }
        return renamedNodes;
    }

    protected Node rename(String xpathQuery, String newName) throws XMLConversionException {
        Node node = this.findFirstNode(xpathQuery);
        return this.document.renameNode(node, null, newName);
    }

    protected Node rename(Node node, String newName) {
        return this.document.renameNode(node, null, newName);
    }

    protected Node findFirstNode(Node startNode, String xpathQuery) throws XMLConversionException {
        try {
            return (Node)this.xpathInstance.evaluate(xpathQuery, startNode, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            throw new XMLConversionException(XMLConversionException.XMLConversionExceptionType.QUERY, (Throwable)e);
        }
    }

    protected Node findFirstNode(String xpathQuery) throws XMLConversionException {
        if (xpathQuery.charAt(0) != '/') {
            throw new XMLConversionException(XMLConversionException.XMLConversionExceptionType.QUERY, "path deve come\u00e7ar com '/'");
        }
        return this.findFirstNode(this.document.getDocumentElement(), xpathQuery);
    }

    protected NodeList findAllNodes(Node startNode, String xpathQuery) throws XMLConversionException {
        try {
            return (NodeList)this.xpathInstance.evaluate(xpathQuery, startNode, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new XMLConversionException(XMLConversionException.XMLConversionExceptionType.QUERY, (Throwable)e);
        }
    }

    protected NodeList findAllNodes(String xpathQuery) throws XMLConversionException {
        return this.findAllNodes(this.document.getDocumentElement(), xpathQuery);
    }

    protected NodeList findAllNodesByTag(String tag) {
        return this.document.getElementsByTagName(tag);
    }

    protected Node createNode(String name) {
        return this.document.createElement(name);
    }

    protected Node createNode(String name, String value) {
        Node newNode = this.createNode(name);
        newNode.setTextContent(value);
        return newNode;
    }

    protected Node createNode(String name, double value) {
        return this.createNode(name, String.valueOf(value));
    }

    protected boolean setNodeValue(String xpathQuery, String value) throws XMLConversionException {
        return this.setNodeValue(this.findFirstNode(xpathQuery), value);
    }

    protected boolean setNodeValue(Node node, String value) {
        Node textChild = this.getFirstChildByType(node, (short)3);
        if (textChild == null) {
            return false;
        }
        textChild.setNodeValue(value);
        return true;
    }

    protected boolean setNodeValue(Node node, double value) {
        return this.setNodeValue(node, String.valueOf(value));
    }

    protected void copyNodeValue(Node from, Node to) {
        to.setNodeValue(from.getNodeValue());
    }

    private Node getFirstChildByType(Node node, short type) {
        node.normalize();
        NodeList children = node.getChildNodes();
        int numChildren = children.getLength();
        for (int i = 0; i < numChildren; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != type) continue;
            return child;
        }
        return null;
    }

    private NamedNodeMap getAttributeMap(Node node) {
        Node targetNode = null;
        switch (node.getNodeType()) {
            case 1: {
                targetNode = node;
                break;
            }
            case 11: {
                targetNode = this.getFirstChildByType(node, (short)1);
                break;
            }
        }
        if (targetNode == null) {
            return null;
        }
        return targetNode.getAttributes();
    }

    protected String getAttribute(Node node, String attrName) {
        NamedNodeMap attrMap = this.getAttributeMap(node);
        if (attrMap == null) {
            return null;
        }
        Attr attr = (Attr)attrMap.getNamedItem(attrName);
        if (attr == null) {
            return null;
        }
        return attr.getNodeValue();
    }

    protected boolean setAttribute(Node node, String attrName, String attrValue) {
        NamedNodeMap attrs = this.getAttributeMap(node);
        if (attrs == null) {
            return false;
        }
        Attr newAttr = this.document.createAttribute(attrName);
        newAttr.setNodeValue(attrValue);
        attrs.setNamedItem(newAttr);
        return true;
    }

    protected boolean setAttribute(Node node, String attrName, boolean attrValue) {
        return this.setAttribute(node, attrName, attrValue ? "TRUE" : "FALSE");
    }

    protected boolean setAttribute(Node node, String attrName, int attrValue) {
        return this.setAttribute(node, attrName, String.valueOf(attrValue));
    }

    protected boolean setAttribute(Node node, String attrName, double attrValue) {
        return this.setAttribute(node, attrName, String.valueOf(attrValue));
    }

    protected Node removeAttribute(Node node, String attrName) {
        NamedNodeMap attrs = node.getAttributes();
        if (attrs == null) {
            return null;
        }
        return attrs.removeNamedItem(attrName);
    }

    protected boolean insertBefore(String xpathQuery, Node newNode) throws XMLConversionException {
        return this.insertBefore(this.findFirstNode(xpathQuery), newNode);
    }

    protected boolean insertBefore(Node refNode, Node newNode) {
        if (refNode == null) {
            return false;
        }
        Node parentNode = refNode.getParentNode();
        if (parentNode == null) {
            return false;
        }
        parentNode.insertBefore(newNode, refNode);
        return true;
    }

    protected boolean insertBefore(Node refNode, String xpathQuery, Node newNode) throws XMLConversionException {
        return this.insertBefore(this.findFirstNode(refNode, xpathQuery), newNode);
    }

    protected boolean insertAfter(String xpathQuery, Node newNode) throws XMLConversionException {
        return this.insertAfter(this.findFirstNode(xpathQuery), newNode);
    }

    protected boolean insertAfter(Node refNode, Node newNode) {
        if (refNode == null) {
            return false;
        }
        Node nextSibling = refNode.getNextSibling();
        if (nextSibling != null) {
            return this.insertBefore(nextSibling, newNode);
        }
        Node parentNode = refNode.getParentNode();
        if (parentNode == null) {
            return false;
        }
        try {
            parentNode.appendChild(newNode);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    protected boolean insertAfter(Node refNode, String xpathQuery, Node newNode) throws XMLConversionException {
        return this.insertAfter(this.findFirstNode(refNode, xpathQuery), newNode);
    }

    protected boolean appendChild(String xpathQuery, Node newNode) throws XMLConversionException {
        Node refNode = this.findFirstNode(xpathQuery);
        if (refNode == null) {
            return false;
        }
        refNode.appendChild(newNode);
        return true;
    }

    protected int insertChild(String xpathQuery, Node newNode, int pos) throws XMLConversionException {
        Node parentNode = this.findFirstNode(xpathQuery);
        if (parentNode == null) {
            return -1;
        }
        NodeList childNodes = parentNode.getChildNodes();
        int nodeCount = childNodes.getLength();
        if (pos > nodeCount) {
            parentNode.appendChild(newNode);
            return nodeCount;
        }
        Node refNode = childNodes.item(pos);
        this.insertBefore(refNode, newNode);
        return pos;
    }

    private void writeXML(Result result) throws XMLConversionException {
        if (this.document == null) {
            throw new XMLConversionException(XMLConversionException.XMLConversionExceptionType.NO_INPUT);
        }
        this.document.normalizeDocument();
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("doctype-system", this.toDTD);
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{ http://xml.apache.org/xslt }indent-amount", "2");
            String charsetName = this.toCharset.name();
            transformer.setOutputProperty("encoding", charsetName);
            DOMSource source = new DOMSource(this.document);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            throw new XMLConversionException(XMLConversionException.XMLConversionExceptionType.WRITE, (Throwable)e);
        }
    }

    @Override
    public void writeXML(Writer writer) throws XMLConversionException {
        this.writeXML(new StreamResult(writer));
    }

    @Override
    public void writeXML(String fileName) throws XMLConversionException {
        try {
            this.writeXML(new FileOutputStream(fileName));
        }
        catch (FileNotFoundException e) {
            throw new XMLConversionException(XMLConversionException.XMLConversionExceptionType.FILE_NOT_FOUND, (Throwable)e);
        }
    }

    @Override
    public void writeXML(File file) throws XMLConversionException {
        try {
            this.writeXML(new FileOutputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new XMLConversionException(XMLConversionException.XMLConversionExceptionType.FILE_NOT_FOUND, (Throwable)e);
        }
    }

    @Override
    public void writeXML(OutputStream os) throws XMLConversionException {
        OutputStreamWriter writer = new OutputStreamWriter(os, this.toCharset);
        BufferedWriter buffWriter = new BufferedWriter(writer);
        this.writeXML(new StreamResult(buffWriter));
    }

    @Override
    public final boolean canConvertFrom(String dtd) {
        boolean flag = this.compareDTDs(dtd, this.fromDTD);
        return flag;
    }

    @Override
    public final boolean convertsTo(String dtd) {
        return this.compareDTDs(dtd, this.toDTD);
    }

    private boolean compareDTDs(String dtd1, String dtd2) {
        if (dtd1 == null) {
            return dtd2 == null;
        }
        if (dtd2 == null) {
            return false;
        }
        return dtd1.equalsIgnoreCase(dtd2);
    }

    @Override
    public final boolean canConvertFrom(XMLConversionInterface conversion) {
        return this.canConvertFrom(conversion.getTargetDTD());
    }

    @Override
    public String getTargetDTD() {
        return this.toDTD;
    }

    @Override
    public ConversionDocument convert(XMLConversionInterface previousConversion) throws XMLConversionException {
        if (!this.canConvertFrom(previousConversion.getTargetDTD())) {
            throw new XMLConversionException(XMLConversionException.XMLConversionExceptionType.CANT_CONVERT);
        }
        return this.convert(previousConversion.getDocument());
    }

    @Override
    public ConversionDocument convert(ConversionDocument doc) throws XMLConversionException {
        if (!this.canConvertFrom(doc.getDTD())) {
            throw new XMLConversionException(XMLConversionException.XMLConversionExceptionType.CANT_CONVERT);
        }
        this.setDocument(doc);
        ConversionDocument convertedDoc = this.convert();
        convertedDoc.setDTD(this.getTargetDTD());
        return convertedDoc;
    }

    @Override
    public ConversionDocument convert(File file, boolean validate) throws XMLConversionException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setValidating(validate);
        try {
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            this.convert(new ConversionDocument(docBuilder.parse(file)));
        }
        catch (Exception e) {
            throw new XMLConversionException(XMLConversionException.XMLConversionExceptionType.PARSER, (Throwable)e);
        }
        return this.document;
    }

    @Override
    public ConversionDocument getDocument() {
        return this.document;
    }

    @Override
    public void setDocument(ConversionDocument doc) {
        this.document = doc;
    }

    protected String getNodeValue(Node startNode, String xpathQuery) throws XMLConversionException {
        return this.getNodeValue(this.findFirstNode(startNode, xpathQuery));
    }

    protected String getNodeValue(String xpathQuery) throws XMLConversionException {
        return this.getNodeValue(this.findFirstNode(xpathQuery));
    }

    protected String getNodeValue(Node node) {
        if (node == null) {
            return null;
        }
        if (node.getNodeType() == 3) {
            return node.getNodeValue();
        }
        Node textNode = this.getFirstChildByType(node, (short)3);
        return textNode == null ? null : textNode.getNodeValue();
    }

    protected double getDoubleNodeValue(String xpathQuery) throws XMLConversionException {
        return this.getDoubleNodeValue(this.findFirstNode(xpathQuery));
    }

    protected double getDoubleNodeValue(Node startNode, String xpathQuery) throws XMLConversionException {
        return this.getDoubleNodeValue(this.findFirstNode(startNode, xpathQuery));
    }

    protected double getDoubleNodeValue(Node node) throws XMLConversionException {
        String strVal = this.getNodeValue(node);
        if (strVal == null) {
            throw new XMLConversionException(XMLConversionException.XMLConversionExceptionType.NO_VALUE);
        }
        try {
            return Double.valueOf(strVal);
        }
        catch (NumberFormatException e) {
            throw new XMLConversionException(XMLConversionException.XMLConversionExceptionType.NOT_NUMBER, (Throwable)e);
        }
    }
}

