/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.xml.conversion;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.InputSource;
import tecgraf.javautils.xml.conversion.ConversionDocument;
import tecgraf.javautils.xml.conversion.ConversionDocumentBuilder;
import tecgraf.javautils.xml.conversion.XMLConversionInterface;
import tecgraf.javautils.xml.conversion.exception.XMLConversionException;

public class XMLConverter {
    private List<XMLConversionInterface> conversions;
    private ConversionDocument document;
    private XMLConversionInterface lastConversion;
    private XMLConversionStatus conversionStatus;
    private ConversionDocumentBuilder docBuilder;
    private String dtdPrefix;
    private boolean fromJar;
    private boolean validate;
    private InputSource inputSource;
    private Charset charset;

    public XMLConverter() {
        this((String)null);
    }

    public XMLConverter(String dtdPrefix) {
        this(dtdPrefix, false);
    }

    public XMLConverter(String dtdPrefix, boolean fromJar) {
        this(dtdPrefix, fromJar, null);
    }

    public XMLConverter(String dtdPrefix, boolean fromJar, String encoding) {
        this(dtdPrefix, fromJar, encoding, new XMLConversionInterface[0]);
    }

    public XMLConverter(String dtdPrefix, boolean fromJar, String encoding, XMLConversionInterface ... conversions) {
        this.setEncoding(encoding);
        this.setDTDprefix(dtdPrefix, fromJar);
        this.conversions = new ArrayList<XMLConversionInterface>();
        Collections.addAll(this.conversions, conversions);
    }

    public XMLConverter(XMLConversionInterface ... conversions) {
        this(null, false, null, conversions);
    }

    public XMLConverter setDTDprefix(String dtdPrefix) {
        return this.setDTDprefix(dtdPrefix, false);
    }

    public XMLConverter setDTDprefix(String dtdPrefix, boolean fromJar) {
        this.dtdPrefix = dtdPrefix;
        this.fromJar = fromJar;
        this.conversionStatus = XMLConversionStatus.NOT_APPLIED;
        return this;
    }

    public XMLConverter setEncoding(String encoding) {
        this.charset = encoding == null ? Charset.defaultCharset() : Charset.forName(encoding);
        return this;
    }

    public XMLConverter addConversion(XMLConversionInterface conversion) throws XMLConversionException {
        XMLConversionInterface lastConv;
        if (!this.conversions.isEmpty() && !conversion.canConvertFrom(lastConv = this.conversions.get(this.conversions.size() - 1))) {
            throw new XMLConversionException(XMLConversionException.XMLConversionExceptionType.BROKEN_CHAIN);
        }
        this.conversions.add(conversion);
        return this;
    }

    private XMLConverter convert() throws XMLConversionException {
        this.conversionStatus = XMLConversionStatus.ERROR;
        if (this.conversions == null || this.conversions.isEmpty()) {
            throw new XMLConversionException(XMLConversionException.XMLConversionExceptionType.NO_CONVERSIONS);
        }
        try {
            this.docBuilder = new ConversionDocumentBuilder(this.validate, this.dtdPrefix, this.fromJar);
            this.document = new ConversionDocument(this.docBuilder.parse(this.inputSource));
        }
        catch (FileNotFoundException e) {
            throw new XMLConversionException(XMLConversionException.XMLConversionExceptionType.FILE_NOT_FOUND, (Throwable)e);
        }
        catch (Exception e) {
            throw new XMLConversionException(XMLConversionException.XMLConversionExceptionType.PARSER, (Throwable)e);
        }
        String dtd = this.document.getDTD();
        if (this.documentIsUpToDate()) {
            this.conversionStatus = XMLConversionStatus.NOT_NEEDED;
            this.lastConversion = this.conversions.get(this.conversions.size() - 1);
            this.lastConversion.setDocument(this.document);
            return this;
        }
        this.lastConversion = null;
        for (XMLConversionInterface conversion : this.conversions) {
            if (!conversion.canConvertFrom(dtd)) {
                if (this.lastConversion == null) continue;
                this.lastConversion = null;
                throw new XMLConversionException(XMLConversionException.XMLConversionExceptionType.BROKEN_CHAIN);
            }
            this.document = conversion.convert(this.document);
            dtd = conversion.getTargetDTD();
            this.document.setDTD(dtd);
            this.lastConversion = conversion;
        }
        if (this.lastConversion == null) {
            throw new XMLConversionException(XMLConversionException.XMLConversionExceptionType.INVALID_DTD);
        }
        this.validateOutput();
        this.conversionStatus = XMLConversionStatus.SUCCESS;
        return this;
    }

    public XMLConverter convert(String content, boolean validate) throws XMLConversionException {
        return this.convert(new StringReader(content), validate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLConverter convert(File src, boolean validate) throws XMLConversionException, FileNotFoundException {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(src);
            XMLConverter xMLConverter = this.convert(stream, validate);
            return xMLConverter;
        }
        finally {
            this.close(stream);
        }
    }

    public XMLConverter convert(InputStream src, boolean validate) throws XMLConversionException {
        InputStreamReader reader = new InputStreamReader(src, this.charset);
        return this.convert(reader, validate);
    }

    public XMLConverter convert(Reader src, boolean validate) throws XMLConversionException {
        this.inputSource = new InputSource(src);
        this.validate = validate;
        return this.convert();
    }

    private void validateOutput() throws XMLConversionException {
        this.document.normalizeDocument();
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            String dtd = this.document.getDTD();
            if (dtd != null) {
                transformer.setOutputProperty("doctype-system", dtd);
            } else {
                transformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", this.charset.name());
            StringWriter stringWriter = new StringWriter();
            StreamResult result = new StreamResult(stringWriter);
            DOMSource source = new DOMSource(this.document);
            transformer.transform(source, result);
            String resultAsString = stringWriter.toString();
            ConversionDocumentBuilder validationDocBuilder = new ConversionDocumentBuilder(true, this.dtdPrefix, this.fromJar);
            validationDocBuilder.parse(new InputSource(new StringReader(resultAsString)));
            resultAsString = null;
        }
        catch (Exception e) {
            throw new XMLConversionException(XMLConversionException.XMLConversionExceptionType.CANT_VALIDATE, (Throwable)e);
        }
    }

    public String saveToString() throws XMLConversionException {
        this.checkConversionsWereApplied();
        switch (this.conversionStatus) {
            case NOT_NEEDED: 
            case SUCCESS: {
                StringWriter writer = new StringWriter();
                this.lastConversion.writeXML(writer);
                return writer.toString();
            }
            case ERROR: 
            case NOT_APPLIED: {
                return null;
            }
        }
        throw new AssertionError((Object)("status desconhecido " + this.conversionStatus.name()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveTo(File file) throws XMLConversionException, FileNotFoundException {
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(file);
            boolean bl = this.saveTo(stream);
            return bl;
        }
        finally {
            this.close(stream);
        }
    }

    public boolean saveTo(OutputStream stream) throws XMLConversionException {
        return this.saveTo(stream, this.charset);
    }

    private boolean saveTo(OutputStream stream, Charset charset) throws XMLConversionException {
        return this.saveTo(new OutputStreamWriter(stream, charset));
    }

    public boolean saveTo(Writer writer) throws XMLConversionException {
        this.checkConversionsWereApplied();
        switch (this.conversionStatus) {
            case NOT_NEEDED: 
            case SUCCESS: {
                this.lastConversion.writeXML(writer);
                return true;
            }
            case ERROR: 
            case NOT_APPLIED: {
                return false;
            }
        }
        throw new AssertionError((Object)("status desconhecido " + this.conversionStatus.name()));
    }

    private void checkConversionsWereApplied() throws XMLConversionException {
        if (this.conversions == null || this.conversions.isEmpty()) {
            throw new XMLConversionException(XMLConversionException.XMLConversionExceptionType.NO_CONVERSIONS);
        }
        if (this.document == null) {
            throw new XMLConversionException(XMLConversionException.XMLConversionExceptionType.NO_INPUT);
        }
        if (this.lastConversion == null && !this.documentIsUpToDate()) {
            throw new XMLConversionException(XMLConversionException.XMLConversionExceptionType.CONVERSIONS_NOT_APPLIED);
        }
    }

    public XMLConversionStatus getConversionStatus() {
        return this.conversionStatus;
    }

    private boolean documentIsUpToDate() {
        XMLConversionInterface lastRegisteredConversion = this.conversions.get(this.conversions.size() - 1);
        return lastRegisteredConversion.convertsTo(this.document.getDTD());
    }

    public List<String> getParserErrors() throws XMLConversionException {
        if (this.docBuilder == null) {
            throw new XMLConversionException(XMLConversionException.XMLConversionExceptionType.NO_INPUT);
        }
        return this.docBuilder.getErrorList();
    }

    public boolean hasParserErrors() throws XMLConversionException {
        if (this.docBuilder == null) {
            throw new XMLConversionException(XMLConversionException.XMLConversionExceptionType.NO_INPUT);
        }
        return this.docBuilder.hasErrors();
    }

    private void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static enum XMLConversionStatus {
        NOT_APPLIED,
        SUCCESS,
        ERROR,
        NOT_NEEDED;

    }
}

