/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.xml.exception;

import org.xml.sax.SAXParseException;
import tecgraf.javautils.xml.exception.XMLException;

public class XMLParseException
extends XMLException {
    private int columnNumber = -1;
    private int lineNumber = -1;
    protected final String attribute;

    public final String getAttribute() {
        return this.attribute;
    }

    @Override
    public String toString() {
        String msg = "";
        if (this.tag != null) {
            msg = msg + String.format("Tag: %s ", this.tag);
        }
        if (this.attribute != null) {
            msg = msg + String.format("atributo: %s ", this.attribute);
        }
        if (this.lineNumber != -1) {
            msg = msg + String.format("linha: %s ", this.lineNumber);
        }
        if (this.columnNumber != -1) {
            msg = msg + String.format("coluna: %s ", this.columnNumber);
        }
        return msg;
    }

    public XMLParseException(String tag, String attribute) {
        super(tag);
        this.attribute = attribute;
    }

    public XMLParseException(String tag, Exception e, String message) {
        super(tag, e, message);
        this.attribute = null;
    }

    public XMLParseException(String tag) {
        super(tag);
        this.attribute = null;
    }

    public XMLParseException(String tag, Exception e) {
        super(tag, e);
        this.attribute = null;
    }

    public XMLParseException(Exception e) {
        super(null, e);
        this.attribute = null;
        if (e instanceof SAXParseException) {
            SAXParseException spe = (SAXParseException)e;
            this.lineNumber = spe.getLineNumber();
            this.columnNumber = spe.getColumnNumber();
        }
    }

    public XMLParseException(Exception e, String message) {
        super(null, e, message);
        this.attribute = null;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }
}

