/*
 * Decompiled with CFR 0.152.
 */
package busexplorer;

import org.omg.CORBA.ORB;
import scs.core.IComponent;
import tecgraf.diagnostic.addons.openbus.v20.OpenBusMonitor;
import tecgraf.diagnostic.commom.StatusCode;
import tecgraf.openbus.OpenBusContext;
import tecgraf.openbus.admin.BusAdmin;
import tecgraf.openbus.admin.BusAdminImpl;
import tecgraf.openbus.assistant.Assistant;
import tecgraf.openbus.assistant.AssistantParams;
import tecgraf.openbus.assistant.OnFailureCallback;
import tecgraf.openbus.core.v2_0.services.ServiceFailure;
import tecgraf.openbus.core.v2_0.services.UnauthorizedOperation;
import tecgraf.openbus.core.v2_0.services.access_control.AccessDenied;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceProperty;

public class BusExplorerLogin {
    public final String entity;
    public final String host;
    public final int port;
    private final BusAdmin admin;
    private boolean adminRights = false;
    private Assistant assistant;

    public BusExplorerLogin(BusAdmin admin, String entity, String host, int port) {
        this.admin = admin;
        this.entity = entity;
        this.host = host;
        this.port = port;
    }

    public boolean hasAdminRights() {
        return this.adminRights;
    }

    public Assistant getAssistant() {
        return this.assistant;
    }

    public void logout() {
        if (this.assistant == null) {
            return;
        }
        ORB orb = this.assistant.orb();
        this.assistant.shutdown();
        orb.shutdown(true);
    }

    private void checkAdminRights() throws ServiceFailure {
        try {
            this.admin.getLogins();
            this.adminRights = true;
        }
        catch (UnauthorizedOperation e) {
            this.adminRights = false;
        }
    }

    private void connectToAdmin() {
        if (this.admin instanceof BusAdminImpl) {
            ((BusAdminImpl)this.admin).connect(this.host, this.port, this.assistant.orb());
        }
    }

    public static void doLogin(BusExplorerLogin login, String password) throws Exception {
        int LOGIN_CHECK_INTERVAL = 250;
        int MAX_LOGIN_FAILS = 3;
        OnFailureCallbackWithException callback = new OnFailureCallbackWithException(){
            volatile int failedAttempts = 0;
            volatile Exception exception = null;

            @Override
            public void onStartSharedAuthFailure(Assistant arg0, Exception arg1) {
            }

            @Override
            public void onRegisterFailure(Assistant arg0, IComponent arg1, ServiceProperty[] arg2, Exception arg3) {
            }

            @Override
            public void onLoginFailure(Assistant arg0, Exception arg1) {
                if (++this.failedAttempts == 3 || arg1 instanceof AccessDenied) {
                    this.exception = arg1;
                }
            }

            @Override
            public void onFindFailure(Assistant arg0, Exception arg1) {
            }

            @Override
            public Exception getException() {
                return this.exception;
            }
        };
        AssistantParams params = new AssistantParams();
        params.callback = callback;
        login.assistant = Assistant.createWithPassword(login.host, login.port, login.entity, password.getBytes(), params);
        OpenBusMonitor monitor = new OpenBusMonitor("openbus", (OpenBusContext)((Object)login.assistant.orb().resolve_initial_references("OpenBusContext")));
        while (true) {
            if (monitor.checkResource().code == StatusCode.OK) break;
            if (callback.getException() != null) {
                login.logout();
                throw callback.getException();
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
        }
        login.connectToAdmin();
        login.checkAdminRights();
    }

    private static interface OnFailureCallbackWithException
    extends OnFailureCallback {
        public Exception getException();
    }
}

