/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.interfaces;

import busexplorer.Application;
import busexplorer.desktop.dialog.BusExplorerAbstractInputDialog;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.exception.handling.ExceptionHandler;
import busexplorer.panel.TablePanelComponent;
import busexplorer.panel.interfaces.InterfaceWrapper;
import busexplorer.utils.BusExplorerTask;
import busexplorer.utils.Utils;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.openbus.admin.BusAdmin;

public class InterfaceInputDialog
extends BusExplorerAbstractInputDialog {
    private JLabel interfaceNameLabel;
    private JTextField interfaceNameField;
    private TablePanelComponent<InterfaceWrapper> panel;

    public InterfaceInputDialog(Window parentWindow, TablePanelComponent<InterfaceWrapper> panel, BusAdmin admin) {
        super(parentWindow, LNG.get(InterfaceInputDialog.class.getSimpleName() + ".title"), admin);
        this.panel = panel;
    }

    @Override
    protected boolean accept() {
        if (!this.hasValidFields()) {
            return false;
        }
        BusExplorerTask<Object> task = new BusExplorerTask<Object>((ExceptionHandler)Application.exceptionHandler(), ExceptionContext.BusCore){

            @Override
            protected void performTask() throws Exception {
                InterfaceInputDialog.this.admin.createInterface(InterfaceInputDialog.this.getInterfaceName());
            }

            @Override
            protected void afterTaskUI() {
                if (this.getStatus()) {
                    InterfaceWrapper wrapper = new InterfaceWrapper(InterfaceInputDialog.this.getInterfaceName());
                    InterfaceInputDialog.this.panel.refresh(null);
                    InterfaceInputDialog.this.panel.selectElement(wrapper, true);
                }
            }
        };
        task.execute(this, Utils.getString(this.getClass(), "waiting.title"), Utils.getString(this.getClass(), "waiting.msg"));
        return task.getStatus();
    }

    @Override
    protected JPanel buildFields() {
        JPanel panel = new JPanel(new GridBagLayout());
        GBC baseGBC = new GBC().gridx(0).insets(5).west();
        this.interfaceNameLabel = new JLabel(LNG.get("InterfaceInputDialog.interfaceName.label"));
        panel.add((Component)this.interfaceNameLabel, new GBC(baseGBC).gridy(0).none());
        this.interfaceNameField = new JTextField(30);
        panel.add((Component)this.interfaceNameField, new GBC(baseGBC).gridy(1).horizontal());
        return panel;
    }

    @Override
    public boolean hasValidFields() {
        String interfaceName = this.interfaceNameField.getText();
        if (interfaceName.equals("")) {
            this.setErrorMessage(Utils.getString(this.getClass(), "error.validation.emptyID"));
            return false;
        }
        this.clearErrorMessage();
        return true;
    }

    private String getInterfaceName() {
        return this.interfaceNameField.getText();
    }
}

