/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.offers;

import busexplorer.Application;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.exception.handling.ExceptionHandler;
import busexplorer.panel.ActionType;
import busexplorer.panel.OpenBusAction;
import busexplorer.panel.offers.OfferWrapper;
import busexplorer.utils.BusExplorerTask;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.openbus.admin.BusAdmin;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceOffer;

public class OfferDeleteAction
extends OpenBusAction<OfferWrapper> {
    public OfferDeleteAction(JFrame parentWindow, BusAdmin admin) {
        super(parentWindow, admin, LNG.get(OfferDeleteAction.class.getSimpleName() + ".name"));
    }

    @Override
    public ActionType getActionType() {
        return ActionType.REMOVE;
    }

    @Override
    public boolean abilityConditions() {
        return Application.login() != null && Application.login().hasAdminRights();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int option = JOptionPane.showConfirmDialog(this.parentWindow, this.getString("confirm.msg"), this.getString("confirm.title"), 0, 3);
        if (option != 0) {
            return;
        }
        BusExplorerTask<Object> task = new BusExplorerTask<Object>((ExceptionHandler)Application.exceptionHandler(), ExceptionContext.BusCore){

            @Override
            protected void performTask() throws Exception {
                List offers = OfferDeleteAction.this.getTablePanelComponent().getSelectedElements();
                for (OfferWrapper offer : offers) {
                    ServiceOffer ref = offer.getDescriptor().ref;
                    ref.remove();
                }
            }

            @Override
            protected void afterTaskUI() {
                if (this.getStatus()) {
                    OfferDeleteAction.this.getTablePanelComponent().removeSelectedElements();
                }
            }
        };
        task.execute(this.parentWindow, this.getString("waiting.title"), this.getString("waiting.msg"));
    }
}

