/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIResources;

public class StatusBar
extends JPanel {
    private static final String _CLEAR_STATUS_STRING = " ";
    private Timer clearTimer;
    private TimerTask clearTask;
    private final JLabel label = new JLabel();
    private int lastX = 0;

    public StatusBar() {
        super.setVisible(true);
        this.setLayout(new GridBagLayout());
        this.addComponent(this.label, 1.0);
        this.label.setFont(this.label.getFont().deriveFont(0));
        this.label.setText(_CLEAR_STATUS_STRING);
        this.clearTimer = new Timer();
        this.clearTask = null;
        this.hideStatusBar();
    }

    public void addComponent(JComponent component, double weightX) {
        this.add((Component)component, new GBC(this.lastX++, 0).horizontal(weightX).insets(0, 1, 0, 0));
        Dimension ldim = this.label.getPreferredSize();
        int hcurr = (int)ldim.getHeight();
        int hcmp = (int)component.getPreferredSize().getHeight();
        int height = Math.max(hcurr, hcmp);
        Dimension dim = new Dimension((int)ldim.getWidth(), height + 2);
        this.label.setMinimumSize(dim);
    }

    @Override
    @Deprecated
    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    public void showStatusBar(boolean condition) {
        this.setStatus(condition && this.isHidden(), _CLEAR_STATUS_STRING);
    }

    public void showStatusBar() {
        this.setStatus(true, _CLEAR_STATUS_STRING);
    }

    public void hideStatusBar(boolean condition) {
        this.setStatus(condition, null);
    }

    public void hideStatusBar() {
        this.setStatus(true, null);
    }

    public boolean isHidden() {
        String text = this.label.getText();
        return text == null || text.equals("");
    }

    public void clearStatus(boolean condition) {
        this.setStatus(condition && !this.isHidden(), _CLEAR_STATUS_STRING);
    }

    public void clearStatus() {
        this.clearStatus(true);
    }

    public void setStatus(boolean condition, ImageIcon icon, String message, int timeoutSecs) {
        if (this.clearTask != null) {
            this.clearTask.cancel();
        }
        String msg = message;
        if (message == null) {
            msg = " --- ";
        }
        if (condition) {
            this.label.setIcon(icon);
            this.label.setText(message);
        }
        if (timeoutSecs > 0 && !msg.equals(_CLEAR_STATUS_STRING)) {
            this.clearStatusIn(timeoutSecs);
        }
    }

    public void setStatus(boolean condition, ImageIcon icon, String message) {
        this.setStatus(condition, icon, message, 0);
    }

    public void setStatus(ImageIcon icon, String message) {
        this.setStatus(true, icon, message, 0);
    }

    public void setStatus(ImageIcon icon, String message, int timeoutSecs) {
        this.setStatus(true, icon, message, timeoutSecs);
    }

    public void setStatus(boolean condition, String message) {
        this.setStatus(condition, null, message, 0);
    }

    public void setStatus(boolean condition, String message, int timeoutSecs) {
        this.setStatus(condition, null, message, timeoutSecs);
    }

    public void setStatus(String message) {
        this.setStatus(true, message);
    }

    public void setStatus(String message, int timeoutSecs) {
        this.setStatus(true, message, timeoutSecs);
    }

    public void setInfo(boolean condition, String message) {
        this.setStatus(GUIResources.STATUS_INFO_ICON, message);
    }

    public void setInfo(boolean condition, String message, int timeoutSecs) {
        this.setStatus(GUIResources.STATUS_INFO_ICON, message, timeoutSecs);
    }

    public void setInfo(String message) {
        this.setInfo(true, message);
    }

    public void setInfo(String message, int timeoutSecs) {
        this.setInfo(true, message, timeoutSecs);
    }

    public void setWarning(boolean condition, String message) {
        this.setStatus(condition, GUIResources.STATUS_WARNING_ICON, message, 0);
    }

    public void setWarning(boolean condition, String message, int timeoutSecs) {
        this.setStatus(condition, GUIResources.STATUS_WARNING_ICON, message, timeoutSecs);
    }

    public void setWarning(String message) {
        this.setWarning(true, message);
    }

    public void setWarning(String message, int timeoutSecs) {
        this.setWarning(true, message, timeoutSecs);
    }

    public void setError(boolean condition, String message) {
        this.setStatus(condition, GUIResources.STATUS_ERROR_ICON, message, 0);
    }

    public void setError(boolean condition, String message, int timeoutSecs) {
        this.setStatus(condition, GUIResources.STATUS_ERROR_ICON, message, timeoutSecs);
    }

    public void setError(String message) {
        this.setError(true, message);
    }

    public void setError(String message, int timeoutSecs) {
        this.setError(true, message, timeoutSecs);
    }

    private void clearStatusIn(int timeoutSecs) {
        this.clearTask = new TimerTask(){

            @Override
            public void run() {
                StatusBar.this.clearStatus();
            }
        };
        this.clearTimer.schedule(this.clearTask, timeoutSecs * 1000);
    }

    public void shutdownTimer() {
        this.clearTimer.cancel();
    }

    public String getText() {
        return this.label.getText();
    }

    public void setText(String message) {
        this.label.setText(message);
    }
}

