/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.core;

import java.util.concurrent.atomic.AtomicInteger;
import tecgraf.openbus.core.TicketsHistory;

abstract class Session {
    private final int session;
    protected final byte[] secret;

    public Session(int session, byte[] secret) {
        this.session = session;
        this.secret = secret;
    }

    public int getSession() {
        return this.session;
    }

    public byte[] getSecret() {
        return this.secret;
    }

    static class ClientSideSession
    extends Session {
        private AtomicInteger ticket = new AtomicInteger(-1);
        private final String callee;

        public ClientSideSession(int session, byte[] secret, String callee) {
            super(session, secret);
            this.callee = callee;
        }

        public int nextTicket() {
            return this.ticket.incrementAndGet();
        }

        public String getCallee() {
            return this.callee;
        }
    }

    static class ServerSideSession
    extends Session {
        private TicketsHistory ticket = new TicketsHistory();
        private final String caller;

        public ServerSideSession(int session, byte[] secret, String caller) {
            super(session, secret);
            this.caller = caller;
        }

        public boolean checkTicket(int id) {
            return this.ticket.check(id);
        }

        public String getCaller() {
            return this.caller;
        }
    }
}

