/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.authorizations;

import busexplorer.Application;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.exception.handling.ExceptionHandler;
import busexplorer.panel.ActionType;
import busexplorer.panel.OpenBusAction;
import busexplorer.panel.authorizations.AuthorizationInputDialog;
import busexplorer.panel.authorizations.AuthorizationWrapper;
import busexplorer.utils.BusExplorerTask;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JFrame;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;
import tecgraf.openbus.admin.BusAdmin;
import tecgraf.openbus.core.v2_0.services.offer_registry.admin.v1_0.RegisteredEntityDesc;

public class AuthorizationAddAction
extends OpenBusAction<AuthorizationWrapper> {
    public AuthorizationAddAction(JFrame parentWindow, BusAdmin admin) {
        super(parentWindow, admin, LNG.get((String)(AuthorizationAddAction.class.getSimpleName() + ".name")));
    }

    @Override
    public ActionType getActionType() {
        return ActionType.ADD;
    }

    @Override
    public boolean abilityConditions() {
        return Application.login() != null && Application.login().hasAdminRights();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        BusExplorerTask<Object> task = new BusExplorerTask<Object>((ExceptionHandler)Application.exceptionHandler(), ExceptionContext.BusCore){
            List<String> entitiesIDList;
            List<String> interfacesList;
            {
                this.entitiesIDList = null;
                this.interfacesList = null;
            }

            protected void performTask() throws Exception {
                this.entitiesIDList = new LinkedList<String>();
                List entitiesDescList = AuthorizationAddAction.this.admin.getEntities();
                this.interfacesList = AuthorizationAddAction.this.admin.getInterfaces();
                for (RegisteredEntityDesc entityDesc : entitiesDescList) {
                    this.entitiesIDList.add(entityDesc.id);
                }
            }

            protected void afterTaskUI() {
                if (this.getStatus()) {
                    if (this.entitiesIDList.size() == 0) {
                        StandardDialogs.showErrorDialog((Component)this.parentWindow, (String)AuthorizationAddAction.this.getString("error.title"), (String)AuthorizationAddAction.this.getString("error.noEntities.msg"));
                    } else if (this.interfacesList.size() == 0) {
                        StandardDialogs.showErrorDialog((Component)this.parentWindow, (String)AuthorizationAddAction.this.getString("error.title"), (String)AuthorizationAddAction.this.getString("error.noInterfaces.msg"));
                    } else {
                        new AuthorizationInputDialog(AuthorizationAddAction.this.parentWindow, AuthorizationAddAction.this.getTablePanelComponent(), AuthorizationAddAction.this.admin, this.entitiesIDList, this.interfacesList).showDialog();
                    }
                }
            }
        };
        task.execute(this.parentWindow, this.getString("waiting.title"), this.getString("waiting.msg"));
    }
}

