/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.configuration.admins;

import busexplorer.Application;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.exception.handling.ExceptionHandler;
import busexplorer.panel.ActionType;
import busexplorer.panel.OpenBusAction;
import busexplorer.panel.configuration.admins.AdminWrapper;
import busexplorer.utils.BusExplorerTask;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.openbus.admin.BusAdmin;

public class AdminDeleteAction
extends OpenBusAction<AdminWrapper> {
    public AdminDeleteAction(JFrame parentWindow, BusAdmin admin) {
        super(parentWindow, admin, LNG.get((String)(AdminDeleteAction.class.getSimpleName() + ".name")));
    }

    @Override
    public ActionType getActionType() {
        return ActionType.REMOVE;
    }

    @Override
    public boolean abilityConditions() {
        return Application.login() != null && Application.login().hasAdminRights();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int option = JOptionPane.showConfirmDialog(this.parentWindow, this.getString("confirm.msg"), this.getString("confirm.title"), 0, 3);
        if (option != 0) {
            return;
        }
        BusExplorerTask<Object> task = new BusExplorerTask<Object>((ExceptionHandler)Application.exceptionHandler(), ExceptionContext.BusCore){

            protected void performTask() throws Exception {
                ArrayList<String> revoke = new ArrayList<String>();
                List admins = AdminDeleteAction.this.getTablePanelComponent().getSelectedElements();
                for (AdminWrapper admin : admins) {
                    revoke.add(admin.getAdmin());
                }
                AdminDeleteAction.this.admin.revokeAdminFrom(revoke);
            }

            protected void afterTaskUI() {
                if (this.getStatus()) {
                    AdminDeleteAction.this.getTablePanelComponent().removeSelectedElements();
                    AdminDeleteAction.this.getTablePanelComponent().refresh(null);
                }
            }
        };
        task.execute(this.parentWindow, this.getString("waiting.title"), this.getString("waiting.msg"));
    }
}

