/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.desktop.dialog;

import busexplorer.Application;
import busexplorer.ApplicationIcons;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.exception.handling.ExceptionHandler;
import busexplorer.panel.OpenBusAction;
import busexplorer.panel.RefreshDelegate;
import busexplorer.panel.RefreshablePanel;
import busexplorer.panel.TablePanelComponent;
import busexplorer.panel.authorizations.AuthorizationAddAction;
import busexplorer.panel.authorizations.AuthorizationDeleteAction;
import busexplorer.panel.authorizations.AuthorizationRefreshAction;
import busexplorer.panel.authorizations.AuthorizationTableProvider;
import busexplorer.panel.authorizations.AuthorizationWrapper;
import busexplorer.panel.categories.CategoryAddAction;
import busexplorer.panel.categories.CategoryDeleteAction;
import busexplorer.panel.categories.CategoryEditAction;
import busexplorer.panel.categories.CategoryRefreshAction;
import busexplorer.panel.categories.CategoryTableProvider;
import busexplorer.panel.categories.CategoryWrapper;
import busexplorer.panel.certificates.CertificateAddAction;
import busexplorer.panel.certificates.CertificateDeleteAction;
import busexplorer.panel.certificates.CertificateEditAction;
import busexplorer.panel.certificates.CertificateRefreshAction;
import busexplorer.panel.certificates.CertificateTableProvider;
import busexplorer.panel.certificates.CertificateWrapper;
import busexplorer.panel.configuration.admins.AdminAddAction;
import busexplorer.panel.configuration.admins.AdminDeleteAction;
import busexplorer.panel.configuration.admins.AdminEditAction;
import busexplorer.panel.configuration.admins.AdminRefreshAction;
import busexplorer.panel.configuration.admins.AdminTableProvider;
import busexplorer.panel.configuration.admins.AdminWrapper;
import busexplorer.panel.configuration.validators.ValidatorDeleteAction;
import busexplorer.panel.configuration.validators.ValidatorRefreshAction;
import busexplorer.panel.configuration.validators.ValidatorRestartAction;
import busexplorer.panel.configuration.validators.ValidatorTableProvider;
import busexplorer.panel.configuration.validators.ValidatorWrapper;
import busexplorer.panel.entities.EntityAddAction;
import busexplorer.panel.entities.EntityDeleteAction;
import busexplorer.panel.entities.EntityEditAction;
import busexplorer.panel.entities.EntityRefreshAction;
import busexplorer.panel.entities.EntityTableProvider;
import busexplorer.panel.entities.EntityWrapper;
import busexplorer.panel.interfaces.InterfaceAddAction;
import busexplorer.panel.interfaces.InterfaceDeleteAction;
import busexplorer.panel.interfaces.InterfaceRefreshAction;
import busexplorer.panel.interfaces.InterfaceTableProvider;
import busexplorer.panel.interfaces.InterfaceWrapper;
import busexplorer.panel.logins.LoginDeleteAction;
import busexplorer.panel.logins.LoginRefreshAction;
import busexplorer.panel.logins.LoginTableProvider;
import busexplorer.panel.logins.LoginWrapper;
import busexplorer.panel.offers.OfferDeleteAction;
import busexplorer.panel.offers.OfferPropertiesAction;
import busexplorer.panel.offers.OfferRefreshAction;
import busexplorer.panel.offers.OfferTableProvider;
import busexplorer.panel.offers.OfferWrapper;
import busexplorer.utils.BusExplorerTask;
import busexplorer.utils.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.table.ObjectTableModel;
import tecgraf.openbus.admin.BusAdmin;

public class MainDialog
extends JFrame
implements PropertyChangeListener {
    private BusAdmin admin;
    private JTabbedPane featuresPane;
    private JButton disconnect;
    private Properties properties;

    public MainDialog(Properties properties, BusAdmin admin) {
        this.admin = admin;
        this.properties = properties;
        this.buildDialog();
    }

    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public void dispose() {
        if (Application.login() != null) {
            Application.login().logout();
        }
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if ("Application.login".equals(propertyName)) {
            this.disconnect.setEnabled(true);
            this.setDialogTitle(Application.login().entity + "@" + Application.login().host + ":" + Application.login().port);
            this.updateAdminFeatures(Application.login().hasAdminRights());
        }
    }

    private void buildDialog() {
        this.setMinimumSize(new Dimension(800, 600));
        this.setLocationByPlatform(true);
        this.setLayout(new BorderLayout(0, 0));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MainDialog.this.dispose();
                System.exit(0);
            }
        });
        this.buildTopPanel();
        this.buildFeaturesComponent();
        this.pack();
        this.setDialogTitle(LNG.get("MainDialog.title.disconnected"));
    }

    private void buildTopPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.disconnect = new JButton(LNG.get("MainDialog.disconnect"));
        this.disconnect.setEnabled(false);
        this.disconnect.setIcon(ApplicationIcons.ICON_LOGOUT_16);
        this.disconnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BusExplorerTask<Object> task = new BusExplorerTask<Object>((ExceptionHandler)Application.exceptionHandler(), ExceptionContext.Service){

                    @Override
                    protected void performTask() throws Exception {
                        Application.login().logout();
                        MainDialog.this.setDialogTitle(LNG.get("MainDialog.title.disconnected"));
                        MainDialog.this.disconnect.setEnabled(false);
                    }

                    @Override
                    protected void afterTaskUI() {
                        Application.loginProcess(MainDialog.this);
                    }
                };
                int option = JOptionPane.showConfirmDialog(MainDialog.this, Utils.getString(MainDialog.class, "disconnect.confirm.msg"), Utils.getString(MainDialog.class, "disconnect.confirm.title"), 0, 3);
                if (option == 0) {
                    task.execute(MainDialog.this, Utils.getString(MainDialog.class, "logout.waiting.title"), Utils.getString(MainDialog.class, "logout.waiting.msg"));
                }
            }
        });
        panel.add((Component)this.disconnect, new GBC(0, 0).insets(5));
        panel.add((Component)new JLabel(), new GBC(1, 0).horizontal());
        this.add((Component)panel, "South");
    }

    private void buildFeaturesComponent() {
        String[] featureNames;
        this.featuresPane = new JTabbedPane(1);
        this.featuresPane.setTabLayoutPolicy(1);
        for (String featureName : featureNames = new String[]{"category", "entity", "certificate", "interface", "authorization", "offer", "login", "conf"}) {
            this.featuresPane.addTab(LNG.get("MainDialog." + featureName + ".title"), null, null, LNG.get("MainDialog." + featureName + ".toolTip"));
        }
        this.initFeaturePanels();
        this.featuresPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                ((RefreshDelegate)((Object)MainDialog.this.featuresPane.getSelectedComponent())).refresh(null);
            }
        });
        this.add((Component)this.featuresPane, "Center");
    }

    private void initPanelCategory() {
        ObjectTableModel<CategoryWrapper> model = new ObjectTableModel<CategoryWrapper>(new LinkedList(), new CategoryTableProvider());
        Vector<OpenBusAction> actionsVector = new Vector<OpenBusAction>(3);
        actionsVector.add(new CategoryRefreshAction(this, this.admin));
        actionsVector.add(new CategoryAddAction(this, this.admin));
        actionsVector.add(new CategoryEditAction(this, this.admin));
        actionsVector.add(new CategoryDeleteAction(this, this.admin));
        TablePanelComponent<CategoryWrapper> panelCategory = new TablePanelComponent<CategoryWrapper>(model, actionsVector, true);
        int index = this.featuresPane.indexOfTab(LNG.get("MainDialog.category.title"));
        this.featuresPane.setComponentAt(index, panelCategory);
    }

    private void initPanelEntity() {
        ObjectTableModel<EntityWrapper> model = new ObjectTableModel<EntityWrapper>(new ArrayList(), new EntityTableProvider());
        Vector<OpenBusAction> actionsVector = new Vector<OpenBusAction>(3);
        actionsVector.add(new EntityRefreshAction(this, this.admin));
        actionsVector.add(new EntityAddAction(this, this.admin));
        actionsVector.add(new EntityEditAction(this, this.admin));
        actionsVector.add(new EntityDeleteAction(this, this.admin));
        TablePanelComponent<EntityWrapper> panelEntity = new TablePanelComponent<EntityWrapper>(model, actionsVector, true);
        int index = this.featuresPane.indexOfTab(LNG.get("MainDialog.entity.title"));
        this.featuresPane.setComponentAt(index, panelEntity);
    }

    private void initPanelCertificate() {
        ObjectTableModel<CertificateWrapper> model = new ObjectTableModel<CertificateWrapper>(new LinkedList(), new CertificateTableProvider());
        Vector<OpenBusAction> actionsVector = new Vector<OpenBusAction>(3);
        actionsVector.add(new CertificateRefreshAction(this, this.admin));
        actionsVector.add(new CertificateAddAction(this, this.admin));
        actionsVector.add(new CertificateEditAction(this, this.admin));
        actionsVector.add(new CertificateDeleteAction(this, this.admin));
        TablePanelComponent<CertificateWrapper> panelCertificate = new TablePanelComponent<CertificateWrapper>(model, actionsVector, true);
        int index = this.featuresPane.indexOfTab(LNG.get("MainDialog.certificate.title"));
        this.featuresPane.setComponentAt(index, panelCertificate);
    }

    private void initPanelInterface() {
        ObjectTableModel<InterfaceWrapper> model = new ObjectTableModel<InterfaceWrapper>(new LinkedList(), new InterfaceTableProvider());
        Vector<OpenBusAction> actionsVector = new Vector<OpenBusAction>(3);
        actionsVector.add(new InterfaceRefreshAction(this, this.admin));
        actionsVector.add(new InterfaceAddAction(this, this.admin));
        actionsVector.add(new InterfaceDeleteAction(this, this.admin));
        TablePanelComponent<InterfaceWrapper> panelInterface = new TablePanelComponent<InterfaceWrapper>(model, actionsVector, true);
        int index = this.featuresPane.indexOfTab(LNG.get("MainDialog.interface.title"));
        this.featuresPane.setComponentAt(index, panelInterface);
    }

    private void initPanelAuthorization() {
        ObjectTableModel<AuthorizationWrapper> model = new ObjectTableModel<AuthorizationWrapper>(new LinkedList(), new AuthorizationTableProvider());
        Vector<OpenBusAction> actionsVector = new Vector<OpenBusAction>(3);
        actionsVector.add(new AuthorizationRefreshAction(this, this.admin));
        actionsVector.add(new AuthorizationAddAction(this, this.admin));
        actionsVector.add(new AuthorizationDeleteAction(this, this.admin));
        TablePanelComponent<AuthorizationWrapper> panelAuthorization = new TablePanelComponent<AuthorizationWrapper>(model, actionsVector, true);
        int index = this.featuresPane.indexOfTab(LNG.get("MainDialog.authorization.title"));
        this.featuresPane.setComponentAt(index, panelAuthorization);
    }

    private void initPanelOffer() {
        ObjectTableModel<OfferWrapper> model = new ObjectTableModel<OfferWrapper>(new LinkedList(), new OfferTableProvider());
        Vector<OpenBusAction> actionsVector = new Vector<OpenBusAction>(2);
        actionsVector.add(new OfferRefreshAction(this, this.admin));
        actionsVector.add(new OfferDeleteAction(this, this.admin));
        final OfferPropertiesAction propertiesAction = new OfferPropertiesAction(this, this.admin);
        actionsVector.add(propertiesAction);
        TablePanelComponent<OfferWrapper> panelOffer = new TablePanelComponent<OfferWrapper>(model, actionsVector, true);
        panelOffer.addTableMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    propertiesAction.actionPerformed(null);
                }
            }
        });
        int index = this.featuresPane.indexOfTab(Utils.getString(this.getClass(), "offer.title"));
        this.featuresPane.setComponentAt(index, panelOffer);
    }

    private void initPanelLogin() {
        ObjectTableModel<LoginWrapper> model = new ObjectTableModel<LoginWrapper>(new LinkedList(), new LoginTableProvider());
        Vector<OpenBusAction> actionsVector = new Vector<OpenBusAction>(2);
        actionsVector.add(new LoginRefreshAction(this, this.admin));
        actionsVector.add(new LoginDeleteAction(this, this.admin));
        TablePanelComponent<LoginWrapper> panelLogin = new TablePanelComponent<LoginWrapper>(model, actionsVector, true);
        int index = this.featuresPane.indexOfTab(LNG.get("MainDialog.login.title"));
        this.featuresPane.setComponentAt(index, panelLogin);
    }

    private void initPanelConfiguration() {
        Vector<OpenBusAction> adminActionsVector = new Vector<OpenBusAction>(3);
        adminActionsVector.add(new AdminRefreshAction(this, this.admin));
        adminActionsVector.add(new AdminAddAction(this, this.admin));
        adminActionsVector.add(new AdminEditAction(this, this.admin));
        adminActionsVector.add(new AdminDeleteAction(this, this.admin));
        final TablePanelComponent<AdminWrapper> adminsPanel = new TablePanelComponent<AdminWrapper>(new ObjectTableModel<AdminWrapper>(new LinkedList(), new AdminTableProvider()), adminActionsVector, false);
        Vector<OpenBusAction> validatorActionsVector = new Vector<OpenBusAction>(3);
        validatorActionsVector.add(new ValidatorRefreshAction(this, this.admin));
        validatorActionsVector.add(new ValidatorRestartAction(this, this.admin));
        validatorActionsVector.add(new ValidatorDeleteAction(this, this.admin));
        final TablePanelComponent<ValidatorWrapper> validatorsPanel = new TablePanelComponent<ValidatorWrapper>(new ObjectTableModel<ValidatorWrapper>(new LinkedList(), new ValidatorTableProvider()), validatorActionsVector, false);
        JPanel settingsPanel = new JPanel(new MigLayout("wrap 2", "[grow][]", "[][][][]"));
        settingsPanel.add((Component)new JLabel(LNG.get("MainDialog.conf.busloglevel")), "grow");
        final JSpinner busLogLevelSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 7, 1));
        busLogLevelSpinner.setToolTipText(LNG.get("MainDialog.conf.busloglevel.tooltip"));
        settingsPanel.add((Component)busLogLevelSpinner, "grow");
        settingsPanel.add((Component)new JLabel(LNG.get("MainDialog.conf.oilloglevel")), "grow");
        final JSpinner oilLogLevelSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 6, 1));
        oilLogLevelSpinner.setToolTipText(LNG.get("MainDialog.conf.oilloglevel.tooltip"));
        settingsPanel.add((Component)oilLogLevelSpinner, "grow");
        settingsPanel.add((Component)new JLabel(LNG.get("MainDialog.conf.maxchannels")), "grow");
        final JSpinner maxChannelsSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 1024, 1));
        maxChannelsSpinner.setToolTipText(LNG.get("MainDialog.conf.maxchannels.tooltip"));
        settingsPanel.add((Component)maxChannelsSpinner, "grow");
        settingsPanel.add((Component)new JLabel(LNG.get("MainDialog.conf.maxcachesize")), "grow");
        final JSpinner maxCacheSizeSpinner = new JSpinner(new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1));
        maxCacheSizeSpinner.setToolTipText(LNG.get("MainDialog.conf.maxcachesize.tooltip"));
        settingsPanel.add((Component)maxCacheSizeSpinner, "grow");
        settingsPanel.add((Component)new JLabel(LNG.get("MainDialog.conf.timeout")), "grow");
        final JSpinner timeoutSpinner = new JSpinner(new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1));
        timeoutSpinner.setToolTipText(LNG.get("MainDialog.conf.timeout.tooltip"));
        settingsPanel.add((Component)timeoutSpinner, "grow");
        final JButton cancelButton = new JButton(LNG.get("MainDialog.conf.cancel"));
        cancelButton.setToolTipText(LNG.get("MainDialog.conf.cancel.tooltip"));
        cancelButton.setIcon(ApplicationIcons.ICON_CANCEL_16);
        cancelButton.setEnabled(false);
        final JButton applyButton = new JButton(LNG.get("MainDialog.conf.apply"));
        applyButton.setIcon(ApplicationIcons.ICON_VALIDATE_16);
        applyButton.setEnabled(false);
        applyButton.setToolTipText(LNG.get("MainDialog.conf.apply.tooltip"));
        settingsPanel.add((Component)cancelButton, "gapleft push");
        settingsPanel.add((Component)applyButton, "gapleft push");
        final BusExplorerTask<Object> getBasicConfFromBusTask = new BusExplorerTask<Object>((ExceptionHandler)Application.exceptionHandler(), ExceptionContext.BusCore){
            int maxChannels;
            int maxCacheSize;
            int timeout;
            int busLogLevel;
            int oilLogLevel;
            {
                super(x0, x1);
                this.maxChannels = 0;
                this.maxCacheSize = 0;
                this.timeout = 0;
                this.busLogLevel = 0;
                this.oilLogLevel = 0;
            }

            @Override
            protected void performTask() throws Exception {
                this.maxChannels = MainDialog.this.admin.getMaxChannels();
                this.maxCacheSize = MainDialog.this.admin.getMaxCacheSize();
                this.timeout = MainDialog.this.admin.getCallsTimeout();
                this.busLogLevel = MainDialog.this.admin.getLogLevel();
                this.oilLogLevel = MainDialog.this.admin.getOilLogLevel();
            }

            @Override
            protected void afterTaskUI() {
                if (this.getStatus()) {
                    busLogLevelSpinner.setValue(this.busLogLevel);
                    oilLogLevelSpinner.setValue(this.oilLogLevel);
                    maxChannelsSpinner.setValue(this.maxChannels);
                    maxCacheSizeSpinner.setValue(this.maxCacheSize);
                    timeoutSpinner.setValue(this.timeout);
                    applyButton.setEnabled(false);
                    cancelButton.setEnabled(false);
                }
            }
        };
        final BusExplorerTask<Object> sendBasicConfToBusTask = new BusExplorerTask<Object>((ExceptionHandler)Application.exceptionHandler(), ExceptionContext.BusCore){

            @Override
            protected void performTask() throws Exception {
                MainDialog.this.admin.setMaxChannels(((SpinnerNumberModel)maxChannelsSpinner.getModel()).getNumber().intValue());
                MainDialog.this.admin.setMaxCacheSize(((SpinnerNumberModel)maxCacheSizeSpinner.getModel()).getNumber().intValue());
                MainDialog.this.admin.setCallsTimeout(((SpinnerNumberModel)timeoutSpinner.getModel()).getNumber().intValue());
                MainDialog.this.admin.setLogLevel(((SpinnerNumberModel)busLogLevelSpinner.getModel()).getNumber().shortValue());
                MainDialog.this.admin.setOilLogLevel(((SpinnerNumberModel)oilLogLevelSpinner.getModel()).getNumber().shortValue());
            }

            @Override
            protected void afterTaskUI() {
                applyButton.setEnabled(false);
                cancelButton.setEnabled(false);
            }
        };
        applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                sendBasicConfToBusTask.execute(MainDialog.this, LNG.get("MainDialog.conf.apply.waiting.title"), LNG.get("MainDialog.conf.apply.waiting.msg"));
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                getBasicConfFromBusTask.execute(MainDialog.this, LNG.get("MainDialog.conf.apply.waiting.title"), LNG.get("MainDialog.conf.apply.waiting.msg"));
            }
        });
        ChangeListener activateButtons = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (Application.login().hasAdminRights()) {
                    applyButton.setEnabled(true);
                }
                cancelButton.setEnabled(true);
            }
        };
        maxChannelsSpinner.addChangeListener(activateButtons);
        maxCacheSizeSpinner.addChangeListener(activateButtons);
        timeoutSpinner.addChangeListener(activateButtons);
        busLogLevelSpinner.addChangeListener(activateButtons);
        oilLogLevelSpinner.addChangeListener(activateButtons);
        JPanel restoreDefaultsPanel = new JPanel(new MigLayout("align center"));
        final JButton restoreDefaultsButton = new JButton(LNG.get("MainDialog.conf.restoredefaults.label"));
        restoreDefaultsPanel.add(restoreDefaultsButton);
        final RefreshablePanel customPanel = new RefreshablePanel(){

            @Override
            public void refresh(ActionEvent event) {
                if (Application.login().hasAdminRights()) {
                    restoreDefaultsButton.setEnabled(true);
                } else {
                    restoreDefaultsButton.setEnabled(false);
                }
                adminsPanel.refresh(event);
                validatorsPanel.refresh(event);
                getBasicConfFromBusTask.execute(MainDialog.this, LNG.get("MainDialog.conf.waiting.title"), LNG.get("MainDialog.conf.waiting.msg"));
            }
        };
        restoreDefaultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BusExplorerTask<Object> task = new BusExplorerTask<Object>((ExceptionHandler)Application.exceptionHandler(), ExceptionContext.BusCore){

                    @Override
                    protected void performTask() throws Exception {
                        MainDialog.this.admin.reloadConfigsFile();
                    }

                    @Override
                    protected void afterTaskUI() {
                        if (this.getStatus()) {
                            customPanel.refresh(null);
                        }
                    }
                };
                task.execute(MainDialog.this, LNG.get("MainDialog.conf.waiting.title"), LNG.get("MainDialog.conf.waiting.msg"));
            }
        });
        Border loweredBorder = BorderFactory.createEtchedBorder(1);
        settingsPanel.setBorder(BorderFactory.createTitledBorder(loweredBorder, LNG.get("MainDialog.conf.settings.label")));
        adminsPanel.setBorder(BorderFactory.createTitledBorder(loweredBorder, LNG.get("MainDialog.conf.admins.label")));
        validatorsPanel.setBorder(BorderFactory.createTitledBorder(loweredBorder, LNG.get("MainDialog.conf.validators.label")));
        customPanel.setLayout(new MigLayout("wrap 2, fill, insets 10", "[]10[]", "[][grow][]"));
        customPanel.add((Component)settingsPanel, "growx");
        customPanel.add(adminsPanel, "spany 2, grow");
        customPanel.add(validatorsPanel, "grow");
        customPanel.add((Component)restoreDefaultsPanel, "spanx 2, grow");
        int index = this.featuresPane.indexOfTab(LNG.get("MainDialog.conf.title"));
        this.featuresPane.setComponentAt(index, customPanel);
    }

    private void initFeaturePanels() {
        this.initPanelCategory();
        this.initPanelEntity();
        this.initPanelCertificate();
        this.initPanelInterface();
        this.initPanelAuthorization();
        this.initPanelLogin();
        this.initPanelOffer();
        this.initPanelConfiguration();
    }

    private void updateAdminFeatures(boolean isAdmin) {
        String[] featureNames;
        for (String featureName : featureNames = new String[]{"certificate", "login"}) {
            int index = this.featuresPane.indexOfTab(LNG.get("MainDialog." + featureName + ".title"));
            this.featuresPane.setEnabledAt(index, isAdmin);
        }
        this.featuresPane.setEnabledAt(this.featuresPane.indexOfTab(LNG.get("MainDialog.conf.title")), this.admin.isReconfigurationCapable());
        this.featuresPane.setSelectedIndex(0);
        Component component = this.featuresPane.getSelectedComponent();
        ((RefreshDelegate)((Object)component)).refresh(null);
    }

    private void setDialogTitle(String title) {
        this.setTitle(Utils.getString(Application.class, "title") + " - " + title);
    }
}

