/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.utils;

import busexplorer.utils.Utils;
import java.text.MessageFormat;

public class BusAddress {
    private String description;
    private String host;
    private int port;
    public static final BusAddress UNSPECIFIED_ADDRESS = new BusAddress(Utils.getString(BusAddress.class, "unspecified"), null);

    public BusAddress(String description, String authority) {
        this(BusAddress.toAddress(authority));
        this.description = description;
    }

    private BusAddress() {
    }

    private BusAddress(BusAddress address) {
        this.description = address.description;
        this.host = address.host;
        this.port = address.port;
    }

    public String toString() {
        String address = this.host + ":" + this.port;
        if (this.host.equals("")) {
            return this.description;
        }
        if (this.description.equals("")) {
            return address;
        }
        return this.description + " (" + address + ")";
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public static BusAddress toAddress(String addressStr) {
        BusAddress address = new BusAddress();
        address.description = "";
        address.host = "";
        address.port = 2089;
        try {
            String[] addressContents = addressStr.split(":");
            address.host = addressContents[0];
            address.port = Integer.parseInt(addressContents[1]);
        }
        catch (Exception e) {
            MessageFormat messageFormat = new MessageFormat(Utils.getString(BusAddress.class, "warning.unreadableAddress"));
            messageFormat.format(new Object[]{addressStr});
        }
        return address;
    }
}

