/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.dsi;

import java.util.Iterator;
import java.util.List;
import org.jacorb.config.Configuration;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.NVList;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.Messages;
import org.jacorb.orb.giop.ReplyOutputStream;
import org.jacorb.orb.giop.RequestInputStream;
import org.jacorb.orb.miop.ServerMIOPConnection;
import org.jacorb.orb.portableInterceptor.ServerInterceptorIterator;
import org.jacorb.orb.portableInterceptor.ServerRequestInfoImpl;
import org.jacorb.poa.util.ByteArrayKey;
import org.jacorb.poa.util.POAUtil;
import org.jacorb.util.Time;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.Context;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NamedValue;
import org.omg.CORBA.Object;
import org.omg.CORBA.ParameterMode;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.Dynamic.Parameter;
import org.omg.GIOP.ReplyStatusType_1_2;
import org.omg.IOP.ServiceContext;
import org.omg.MIOP.UIPMC_ProfileBody;
import org.omg.MIOP.UIPMC_ProfileBodyHelper;
import org.omg.Messaging.PolicyValue;
import org.omg.Messaging.PolicyValueSeqHelper;
import org.omg.PortableGroup.TagGroupTaggedComponent;
import org.omg.PortableGroup.TagGroupTaggedComponentHelper;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.TimeBase.UtcT;
import org.slf4j.Logger;

public class ServerRequest
extends org.omg.CORBA.ServerRequest
implements ResponseHandler {
    private final RequestInputStream inputStream;
    private ReplyOutputStream out;
    private final GIOPConnection connection;
    private UtcT requestStartTime = null;
    private UtcT requestEndTime = null;
    private UtcT replyEndTime = null;
    private List<String> scopes;
    private final boolean cachePoaNames;
    private int replyStatus = 0;
    private byte[] oid;
    private byte[] object_key;
    private String[] rest_of_name = null;
    private boolean isStreamBased;
    private SystemException sys_ex;
    private org.omg.PortableServer.ForwardRequest location_forward;
    private Any exception;
    private Any result;
    private NVList argList;
    private final ORB orb;
    private ServerRequestInfoImpl info = null;
    private final Logger logger;
    private ByteArrayKey byteArrayKey;
    private TagGroupTaggedComponent tagGroup = null;

    public ServerRequest(ORB orb, RequestInputStream inStream, GIOPConnection _connection) {
        this.orb = orb;
        Configuration config = orb.getConfiguration();
        this.logger = config.getLogger("org.jacorb.org.giop");
        this.cachePoaNames = config.getAttributeAsBoolean("jacorb.cachePoaNames", false);
        this.inputStream = inStream;
        this.connection = _connection;
        this.calcTimingPolicies();
        if (this.connection.getTransport() instanceof ServerMIOPConnection) {
            CDRInputStream uipmcInStream = new CDRInputStream(orb, inStream.req_hdr.target.profile().profile_data);
            uipmcInStream.openEncapsulatedArray();
            UIPMC_ProfileBody upb = UIPMC_ProfileBodyHelper.read(uipmcInStream);
            uipmcInStream.close();
            for (int i = 0; i < upb.components.length; ++i) {
                if (upb.components[i].tag != 39) continue;
                CDRInputStream groupInStream = new CDRInputStream(orb, upb.components[i].component_data);
                groupInStream.openEncapsulatedArray();
                this.tagGroup = TagGroupTaggedComponentHelper.read(groupInStream);
                groupInStream.close();
                break;
            }
        } else {
            this.object_key = orb.mapObjectKey(ParsedIOR.extractObjectKey(inStream.req_hdr.target, orb));
            this.oid = POAUtil.extractOID(this.object_key);
        }
    }

    public void setObjectKey(byte[] objectKey) {
        this.object_key = objectKey;
        this.oid = POAUtil.extractOID(this.object_key);
    }

    public TagGroupTaggedComponent getTagGroup() {
        return this.tagGroup;
    }

    public void setRemainingPOAName(String[] rest_of_name) {
        this.rest_of_name = rest_of_name;
    }

    public String[] remainingPOAName() {
        return this.rest_of_name;
    }

    @Override
    public String operation() {
        return this.inputStream.req_hdr.operation;
    }

    public Any result() {
        if (this.isStreamBased) {
            Any any = this.orb.create_any();
            CDROutputStream _out = (CDROutputStream)any.create_output_stream();
            byte[] result_buf = this.orb.getBufferManager().getBuffer(this.out.size() - this.out.getBodyBegin());
            System.arraycopy(this.out.getBufferCopy(), this.out.getBodyBegin(), result_buf, 0, result_buf.length);
            _out.setBuffer(result_buf);
            _out.skip(result_buf.length);
            return any;
        }
        return this.result;
    }

    public org.omg.CORBA.NVList arguments() {
        if (this.isStreamBased) {
            throw new BAD_INV_ORDER("This ServerRequest is stream-based!");
        }
        return this.argList;
    }

    public Any except() {
        if (this.isStreamBased) {
            throw new BAD_INV_ORDER("This ServerRequest is stream-based!");
        }
        return this.exception;
    }

    public ReplyStatusType_1_2 status() {
        return ReplyStatusType_1_2.from_int(this.replyStatus);
    }

    @Override
    public Context ctx() {
        return null;
    }

    @Override
    public void arguments(org.omg.CORBA.NVList list) {
        this.argList = (NVList)list;
        if (this.argList != null) {
            this.inputStream.mark(0);
            Iterator<NamedValue> e = this.argList.iterator();
            while (e.hasNext()) {
                NamedValue namedValue = e.next();
                if (namedValue.flags() == 2) continue;
                try {
                    namedValue.value().read_value(this.inputStream, namedValue.value().type());
                }
                catch (Exception e1) {
                    throw new MARSHAL("Couldn't unmarshal object of type " + namedValue.value().type() + " in ServerRequest.");
                }
            }
            try {
                this.inputStream.reset();
            }
            catch (Exception e1) {
                throw new UNKNOWN("Could not reset input stream");
            }
            if (this.info != null) {
                Parameter[] params = new Parameter[this.argList.count()];
                for (int i = 0; i < params.length; ++i) {
                    try {
                        NamedValue value = this.argList.item(i);
                        ParameterMode mode = null;
                        if (value.flags() == 1) {
                            mode = ParameterMode.PARAM_IN;
                        } else if (value.flags() == 2) {
                            mode = ParameterMode.PARAM_OUT;
                        } else if (value.flags() == 3) {
                            mode = ParameterMode.PARAM_INOUT;
                        }
                        params[i] = new Parameter(value.value(), mode);
                        continue;
                    }
                    catch (Exception e2) {
                        this.logger.info("DSI arguments: Caught exception ", e2);
                    }
                }
                this.info.setArguments(params);
                ServerInterceptorIterator intercept_iter = this.orb.getInterceptorManager().getServerIterator();
                try {
                    intercept_iter.iterate(this.info, (short)1);
                }
                catch (ForwardRequest e3) {
                    this.setLocationForward(new org.omg.PortableServer.ForwardRequest(e3.forward));
                }
                catch (UserException e4) {
                    this.logger.error("uncaught userexception", e4);
                }
                catch (SystemException _sys_ex) {
                    this.setSystemException(_sys_ex);
                }
                this.info = null;
            }
        }
    }

    @Override
    public void set_result(Any res) {
        if (this.isStreamBased) {
            throw new BAD_INV_ORDER("This ServerRequest is stream-based!");
        }
        this.result = res;
    }

    @Override
    public void set_exception(Any exception) {
        if (this.isStreamBased) {
            throw new BAD_INV_ORDER("This ServerRequest is stream-based!");
        }
        this.exception = exception;
        this.replyStatus = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reply() {
        if (this.responseExpected()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ServerRequest: reply to " + this.operation());
            }
            try {
                if (this.out == null) {
                    this.out = new ReplyOutputStream(this.orb, this.requestId(), ReplyStatusType_1_2.from_int(this.replyStatus), this.inputStream.getGIOPMinor(), this.inputStream.isLocateRequest(), this.logger);
                }
                if (!this.isStreamBased) {
                    if (this.replyStatus == 1) {
                        this.exception.write_value(this.out);
                    } else if (this.replyStatus == 0) {
                        if (this.result != null) {
                            this.result.write_value(this.out);
                        }
                        if (this.argList != null) {
                            Iterator<NamedValue> e = this.argList.iterator();
                            while (e.hasNext()) {
                                NamedValue namedValue = e.next();
                                if (namedValue.flags() == 1) continue;
                                try {
                                    namedValue.value().write_value(this.out);
                                }
                                catch (Exception e1) {
                                    throw new MARSHAL("Couldn't return (in)out arg of type " + namedValue.value().type() + " in ServerRequest.");
                                }
                            }
                        }
                    }
                }
                if (this.replyStatus == 3) {
                    this.out.write_Object(this.location_forward.forward_reference);
                } else if (this.replyStatus == 2) {
                    SystemExceptionHelper.write(this.out, this.sys_ex);
                }
                this.connection.sendReply(this.out);
            }
            catch (Exception ioe) {
                this.logger.info("Error replying to request!", ioe);
            }
            finally {
                this.out.close();
                this.out = null;
            }
        }
    }

    @Override
    public OutputStream createReply() {
        this.isStreamBased = true;
        if (this.out != null) {
            return this.out;
        }
        this.out = new ReplyOutputStream(this.orb, this.requestId(), ReplyStatusType_1_2.NO_EXCEPTION, this.inputStream.getGIOPMinor(), this.inputStream.isLocateRequest(), this.logger);
        this.out.updateMutatorConnection(this.connection);
        return this.out;
    }

    @Override
    public OutputStream createExceptionReply() {
        this.isStreamBased = true;
        this.replyStatus = 1;
        this.out = new ReplyOutputStream(this.orb, this.requestId(), ReplyStatusType_1_2.USER_EXCEPTION, this.inputStream.getGIOPMinor(), this.inputStream.isLocateRequest(), this.logger);
        return this.out;
    }

    public void setSystemException(SystemException exception) {
        this.replyStatus = 2;
        this.out = new ReplyOutputStream(this.orb, this.requestId(), ReplyStatusType_1_2.SYSTEM_EXCEPTION, this.inputStream.getGIOPMinor(), this.inputStream.isLocateRequest(), this.logger);
        String msg = exception.getMessage();
        if (msg != null) {
            this.out.addServiceContext(ServerRequest.createExceptionDetailMessage(msg));
        }
        this.sys_ex = exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceContext createExceptionDetailMessage(String message) {
        CDROutputStream out = new CDROutputStream();
        try {
            out.beginEncapsulatedArray();
            out.write_wstring(message);
            ServiceContext serviceContext = new ServiceContext(14, out.getBufferCopy());
            return serviceContext;
        }
        finally {
            out.close();
        }
    }

    public void setLocationForward(org.omg.PortableServer.ForwardRequest request) {
        this.replyStatus = 3;
        this.out = new ReplyOutputStream(this.orb, this.requestId(), ReplyStatusType_1_2.LOCATION_FORWARD, this.inputStream.getGIOPMinor(), this.inputStream.isLocateRequest(), this.logger);
        this.location_forward = request;
    }

    public CDRInputStream getInputStream() {
        this.isStreamBased = true;
        return this.inputStream;
    }

    public ReplyOutputStream getReplyOutputStream() {
        if (this.out == null) {
            this.createReply();
        }
        this.isStreamBased = true;
        return this.out;
    }

    public boolean responseExpected() {
        return Messages.responseExpected(this.inputStream.req_hdr.response_flags);
    }

    public short syncScope() {
        short result;
        switch (this.inputStream.req_hdr.response_flags) {
            case 0: {
                result = 0;
                break;
            }
            case 1: {
                result = 2;
                break;
            }
            case 3: {
                result = 3;
                break;
            }
            default: {
                throw new BAD_PARAM("Illegal SYNC_SCOPE: " + this.inputStream.req_hdr.response_flags);
            }
        }
        return result;
    }

    public SystemException getSystemException() {
        return this.sys_ex;
    }

    public int requestId() {
        return this.inputStream.req_hdr.request_id;
    }

    public byte[] objectKey() {
        return this.object_key;
    }

    public List<String> getScopes() {
        if (this.scopes == null || !this.cachePoaNames) {
            this.scopes = POAUtil.extractScopedPOANames(POAUtil.extractPOAName(this.object_key));
        }
        return this.scopes;
    }

    public ServiceContext[] getServiceContext() {
        return this.inputStream.req_hdr.service_context;
    }

    public byte[] objectId() {
        return this.oid;
    }

    public synchronized ByteArrayKey objectIdAsByteArrayKey() {
        if (this.byteArrayKey == null) {
            this.byteArrayKey = new ByteArrayKey(this.oid);
        }
        return this.byteArrayKey;
    }

    public boolean streamBased() {
        return this.isStreamBased;
    }

    public RequestInputStream get_in() {
        return this.inputStream;
    }

    public ReplyOutputStream get_out() {
        if (this.out == null) {
            this.out = new ReplyOutputStream(this.orb, this.requestId(), this.status(), this.inputStream.getGIOPMinor(), this.inputStream.isLocateRequest(), this.logger);
        }
        return this.out;
    }

    public void setServerRequestInfo(ServerRequestInfoImpl info) {
        this.info = info;
    }

    public Object getForwardReference() {
        if (this.location_forward != null) {
            return this.location_forward.forward_reference;
        }
        return null;
    }

    public GIOPConnection getConnection() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calcTimingPolicies() {
        ServiceContext ctx = this.inputStream.getServiceContext(7);
        if (ctx != null) {
            CDRInputStream input = new CDRInputStream(ctx.context_data);
            try {
                input.openEncapsulatedArray();
                PolicyValue[] policy = PolicyValueSeqHelper.read(input);
                for (int i = 0; i < policy.length; ++i) {
                    if (policy[i].ptype == 27) {
                        this.requestStartTime = Time.fromCDR(policy[i].pvalue);
                        continue;
                    }
                    if (policy[i].ptype == 28) {
                        this.requestEndTime = Time.fromCDR(policy[i].pvalue);
                        continue;
                    }
                    if (policy[i].ptype != 30) continue;
                    this.replyEndTime = Time.fromCDR(policy[i].pvalue);
                }
            }
            finally {
                input.close();
            }
        }
    }

    public UtcT getReplyEndTime() {
        return this.replyEndTime;
    }

    public UtcT getRequestEndTime() {
        return this.requestEndTime;
    }

    public UtcT getRequestStartTime() {
        return this.requestStartTime;
    }
}

