/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.transport;

import java.net.Socket;
import org.jacorb.orb.iiop.IIOPAddress;
import org.jacorb.orb.iiop.IIOPConnection;
import org.jacorb.orb.iiop.IIOPLoopbackConnection;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.transport.DefaultCurrentImpl;
import org.jacorb.transport.NoContext;
import org.jacorb.transport.iiop.Current;
import org.omg.ETF.Connection;

public class IIOPCurrentImpl
extends DefaultCurrentImpl
implements Current {
    @Override
    public int remote_port() throws NoContext {
        Connection transport = this.getTransport();
        if (transport instanceof IIOPConnection) {
            return ((IIOPAddress)((IIOPProfile)this.getLatestTransportCurentEvent().profile()).getAddress()).getPort();
        }
        if (transport instanceof IIOPLoopbackConnection) {
            return 0;
        }
        return -1;
    }

    @Override
    public String remote_host() throws NoContext {
        Connection transport = this.getTransport();
        if (transport instanceof IIOPConnection) {
            return ((IIOPAddress)((IIOPProfile)this.getLatestTransportCurentEvent().profile()).getAddress()).getHostName();
        }
        if (transport instanceof IIOPLoopbackConnection) {
            return "127.0.0.1 (loopback)";
        }
        return "unknown";
    }

    @Override
    public int local_port() throws NoContext {
        Connection transport = this.getTransport();
        if (transport instanceof IIOPConnection) {
            Socket so = ((IIOPConnection)transport).getSocket();
            if (so == null) {
                return 0;
            }
            return so.getLocalPort();
        }
        if (transport instanceof IIOPLoopbackConnection) {
            return 0;
        }
        return -1;
    }

    @Override
    public String local_host() throws NoContext {
        Connection transport = this.getTransport();
        if (transport instanceof IIOPConnection) {
            Socket so = ((IIOPConnection)transport).getSocket();
            if (so == null) {
                return null;
            }
            return so.getLocalAddress().getCanonicalHostName();
        }
        if (transport instanceof IIOPLoopbackConnection) {
            return "127.0.0.1 (loopback)";
        }
        return "unknown";
    }

    private Connection getTransport() throws NoContext {
        return this.getLatestTransportCurentEvent().transport();
    }

    public String toString() {
        try {
            return this.getClass().getName() + "[ " + this.local_host() + ':' + this.local_port() + '-' + this.remote_host() + ':' + this.remote_port() + ']';
        }
        catch (NoContext e) {
            return this.getClass().getName() + "[ NoContext ]";
        }
    }
}

