/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.calendar;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GUIResources;
import tecgraf.javautils.gui.GUIUtils;
import tecgraf.javautils.gui.calendar.CalendarDateFieldListener;
import tecgraf.javautils.gui.calendar.CalendarEvent;
import tecgraf.javautils.gui.calendar.CalendarPanel;
import tecgraf.javautils.gui.field.DateDocument;
import tecgraf.javautils.gui.field.DateField;
import tecgraf.javautils.gui.field.DateListener;

public class CalendarDateField
extends JPanel {
    private ArrayList<CalendarDateFieldListener> listeners;
    private CalendarPanel calendar;
    private JTextField field;
    private JLabel calendarButton;
    private boolean buttonsInCalendarVisible;

    public CalendarDateField() {
        this(null, null);
    }

    public CalendarDateField(Locale locale) {
        this(null, locale);
    }

    public CalendarDateField(JTextField field) {
        this(field, null);
    }

    public CalendarDateField(JTextField field, Locale locale) {
        this.calendar = new CalendarPanel(locale);
        if (field == null) {
            field = new DateField(locale);
            field.setColumns(10);
        } else if (field instanceof DateField) {
            field.setLocale(locale);
        }
        this.field = field;
        this.listeners = new ArrayList();
        this.buttonsInCalendarVisible = false;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.add((Component)field, gbc);
        gbc.gridx = 1;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 3, 0, 0);
        this.add((Component)this.getCalendarButton(), gbc);
    }

    public JTextField getField() {
        return this.field;
    }

    public CalendarPanel getCalendar() {
        return this.calendar;
    }

    public JLabel getCalendarButton() {
        if (this.calendarButton == null) {
            this.calendarButton = new JLabel();
            this.calendarButton.setIcon(GUIResources.BUTTON_CALENDAR_ICON);
            this.calendarButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (CalendarDateField.this.calendarButton.isEnabled()) {
                        CalendarDateField.this.showCalendar(CalendarDateField.this.buttonsInCalendarVisible);
                    }
                }
            });
        }
        return this.calendarButton;
    }

    private boolean isDateField() {
        return this.field instanceof DateField;
    }

    public Date getDate() {
        if (this.isDateField()) {
            Long date = ((DateField)this.field).getDate();
            if (date != null) {
                return new Date(date);
            }
            return null;
        }
        return DateDocument.getDate(this.field.getText(), this.getLocale());
    }

    public Long getDateInMillis() {
        Date date = this.getDate();
        return date != null ? new Long(date.getTime()) : null;
    }

    public void setDate(Date date) {
        Date oldDate = this.getDate();
        if (date != null) {
            if (this.isDateField()) {
                ((DateField)this.field).setDate(date.getTime());
            } else {
                this.field.setText(DateDocument.toString(this.getLocale(), date.getTime()));
            }
        } else {
            this.field.setText("");
        }
        if (oldDate != null && date != null) {
            this.fireDateChanged(oldDate.getTime(), date.getTime());
        }
    }

    private void fireDateChanged(long oldDate, long newDate) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTimeInMillis(oldDate);
        int actualMonth = gc.get(2);
        int actualYear = gc.get(1);
        gc.setTimeInMillis(newDate);
        boolean dateInSameMonth = gc.get(2) == actualMonth;
        boolean dateInSameYear = gc.get(1) == actualYear;
        CalendarEvent event = new CalendarEvent(newDate, dateInSameMonth && dateInSameYear);
        for (CalendarDateFieldListener listener : this.listeners) {
            listener.dateChanged(event);
        }
    }

    public String getText() {
        return this.field.getText();
    }

    public boolean isValidDate() {
        if (this.isDateField()) {
            return ((DateField)this.field).isValidValue();
        }
        return DateDocument.getDate(this.getText(), this.getLocale()) != null;
    }

    public void setEditable(boolean editable) {
        this.field.setEditable(editable);
        this.getCalendarButton().setEnabled(editable);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.field.setEnabled(enabled);
        this.getCalendarButton().setEnabled(enabled);
    }

    private void showCalendar(boolean showButtons) {
        JFrame frame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this);
        Long value = this.getDateInMillis();
        if (value != null) {
            this.calendar.setSelectedDate(value);
        } else {
            this.calendar.setSelectedDate(System.currentTimeMillis());
        }
        String title = LNG.get("javautils.gui.calendar.title");
        if (showButtons) {
            String btOK = LNG.get("javautils.confirm");
            String btCancel = LNG.get("javautils.cancel");
            value = this.calendar.showAsDialog(frame, title, btOK, btCancel, this);
        } else {
            value = this.calendar.showAsDialog(frame, title, this);
        }
        if (value != null) {
            this.setDate(new Date(value));
        }
    }

    public boolean isButtonsInCalendarVisible() {
        return this.buttonsInCalendarVisible;
    }

    public void setButtonsInCalendarVisible(boolean visible) {
        this.buttonsInCalendarVisible = visible;
    }

    @Deprecated
    public void addCalendarDateFieldListener(CalendarDateFieldListener listener) {
        this.listeners.add(listener);
    }

    @Deprecated
    public void removeCalendarDateFieldListener(CalendarDateFieldListener listener) {
        this.listeners.remove(listener);
    }

    public Long showAsDialog(JFrame owner, String title, Component comp) {
        String btOK = LNG.get("javautils.confirm");
        String btCancel = LNG.get("javautils.cancel");
        final JDialog dialog = new JDialog(owner, title, true);
        dialog.setResizable(false);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                CalendarDateField.this.setDate(null);
            }
        });
        JPanel buttonsPanel = new JPanel();
        JButton confirmButton = new JButton();
        confirmButton.setText(btOK);
        confirmButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
        buttonsPanel.add(confirmButton);
        JButton cancelButton = new JButton();
        cancelButton.setText(btCancel);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalendarDateField.this.setDate(null);
                dialog.dispose();
            }
        });
        buttonsPanel.add(cancelButton);
        JComponent[] buttons = new JButton[]{confirmButton, cancelButton};
        GUIUtils.matchPreferredSizes(buttons);
        JPanel bodyPanel = new JPanel();
        bodyPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        bodyPanel.setLayout(new BorderLayout(10, 0));
        bodyPanel.add((Component)buttonsPanel, "South");
        bodyPanel.add((Component)new JLabel(GUIResources.LABEL_QUESTION_LARGE_ICON), "West");
        bodyPanel.add((Component)this, "Center");
        dialog.add(bodyPanel);
        dialog.pack();
        dialog.setLocationRelativeTo(comp);
        dialog.setVisible(true);
        return this.getDateInMillis();
    }

    public void addDateListener(DateListener listener) {
        if (this.isDateField()) {
            DateField dateField = (DateField)this.field;
            dateField.addDateListener(listener);
        }
    }

    public void removeDateListener(DateListener listener) {
        if (this.isDateField()) {
            DateField dateField = (DateField)this.field;
            dateField.removeDateListener(listener);
        }
    }
}

