/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.offers.properties;

import busexplorer.panel.TablePanelComponent;
import busexplorer.panel.offers.OfferWrapper;
import busexplorer.panel.offers.properties.PropertiesRefreshAction;
import busexplorer.panel.offers.properties.PropertiesTableProvider;
import busexplorer.utils.Utils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import tecgraf.javautils.gui.GBC;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceProperty;

public class PropertiesDialog
extends JDialog {
    private OfferWrapper offer;

    public PropertiesDialog(Window owner, OfferWrapper offer) {
        super(owner, Utils.getString(PropertiesDialog.class, "title"), Dialog.ModalityType.APPLICATION_MODAL);
        this.offer = offer;
        this.initPanel();
    }

    private void initPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        ArrayList<PropertiesRefreshAction> actions = new ArrayList<PropertiesRefreshAction>();
        actions.add(new PropertiesRefreshAction(this, this.offer));
        List<ServiceProperty> props = Arrays.asList(this.offer.getDescriptor().properties);
        PropertiesTableProvider provider = new PropertiesTableProvider();
        TablePanelComponent<ServiceProperty> propertiesPanel = new TablePanelComponent<ServiceProperty>(props, provider, actions);
        panel.add(propertiesPanel, new GBC(0, 0).both());
        JButton closeButton = new JButton(Utils.getString(PropertiesDialog.class, "button.close"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertiesDialog.this.dispose();
            }
        });
        panel.add((Component)closeButton, new GBC(0, 1).none().east().insets(9, 9, 9, 9));
        this.setContentPane(panel);
        this.pack();
    }
}

