/*
 * Decompiled with CFR 0.152.
 */
package busexplorer;

import busexplorer.utils.BusAddress;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSIENT;
import tecgraf.openbus.Connection;
import tecgraf.openbus.OpenBusContext;
import tecgraf.openbus.admin.BusAdmin;
import tecgraf.openbus.admin.BusAdminImpl;
import tecgraf.openbus.core.ORBInitializer;
import tecgraf.openbus.core.v2_1.services.ServiceFailure;
import tecgraf.openbus.core.v2_1.services.UnauthorizedOperation;

public class BusExplorerLogin {
    public final String entity;
    public final BusAddress address;
    private final BusAdminImpl admin;
    private boolean adminRights = false;
    private OpenBusContext context;
    private Connection conn;

    public BusExplorerLogin(BusAdmin admin, String entity, BusAddress address) {
        this.admin = (BusAdminImpl)admin;
        this.entity = entity;
        this.address = address;
    }

    public boolean hasAdminRights() {
        return this.adminRights;
    }

    public void logout() {
        try {
            if (this.conn != null) {
                ORB orb = this.conn.ORB();
                this.conn.logout();
                orb.shutdown(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void checkAdminRights() throws ServiceFailure {
        try {
            this.admin.getLogins();
            this.adminRights = true;
        }
        catch (UnauthorizedOperation e) {
            this.adminRights = false;
        }
    }

    private void getAdminFacets() {
        ORB orb = this.conn.ORB();
        switch (this.address.getType()) {
            case Address: {
                this.admin.getAdminFacets(this.address.getHost(), this.address.getPort(), orb);
                break;
            }
            case Reference: {
                Object ref = orb.string_to_object(this.address.getIOR());
                this.admin.getAdminFacets(ref);
                break;
            }
            default: {
                throw new IllegalStateException("Informa\u00e7\u00f5es sobre barramento inv\u00e1lidas");
            }
        }
    }

    public static void doLogin(BusExplorerLogin login, String password, String domain) throws Exception {
        ORB orb = ORBInitializer.initORB();
        login.context = (OpenBusContext)((java.lang.Object)orb.resolve_initial_references("OpenBusContext"));
        switch (login.address.getType()) {
            case Address: {
                login.conn = login.context.connectByAddress(login.address.getHost(), login.address.getPort());
                break;
            }
            case Reference: {
                Object ref = orb.string_to_object(login.address.getIOR());
                login.conn = login.context.connectByReference(ref);
                break;
            }
            default: {
                throw new IllegalStateException("Informa\u00e7\u00f5es inv\u00e1lidas sobre o barramento.");
            }
        }
        login.context.defaultConnection(login.conn);
        for (int i = 0; i < 3; ++i) {
            try {
                login.conn.loginByPassword(login.entity, password.getBytes(), domain);
                login.getAdminFacets();
                login.checkAdminRights();
                break;
            }
            catch (COMM_FAILURE | TRANSIENT systemException) {
            }
            catch (NO_PERMISSION e) {
                if (e.minor != 1112888319) {
                    throw e;
                }
            }
            catch (Exception e) {
                login.logout();
                throw e;
            }
            try {
                Thread.sleep(250L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

