/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.categories;

import busexplorer.Application;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.exception.handling.ExceptionHandler;
import busexplorer.panel.ActionType;
import busexplorer.panel.OpenBusAction;
import busexplorer.panel.categories.CategoryWrapper;
import busexplorer.utils.BusExplorerTask;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JFrame;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.openbus.admin.BusAdmin;

public class CategoryRefreshAction
extends OpenBusAction<CategoryWrapper> {
    public CategoryRefreshAction(JFrame parentWindow, BusAdmin admin) {
        super(parentWindow, admin, LNG.get(CategoryRefreshAction.class.getSimpleName() + ".name"));
    }

    @Override
    public ActionType getActionType() {
        return ActionType.REFRESH;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        BusExplorerTask<List<CategoryWrapper>> task = new BusExplorerTask<List<CategoryWrapper>>((ExceptionHandler)Application.exceptionHandler(), ExceptionContext.BusCore){

            @Override
            protected void performTask() throws Exception {
                this.setResult(CategoryWrapper.convertToInfo(CategoryRefreshAction.this.admin.getCategories()));
            }

            @Override
            protected void afterTaskUI() {
                if (this.getStatus()) {
                    CategoryRefreshAction.this.getTablePanelComponent().setElements((List)this.getResult());
                }
            }
        };
        task.execute(this.parentWindow, this.getString("waiting.title"), this.getString("waiting.msg"));
    }
}

