/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.util.ArrayList;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.ORB;
import org.jacorb.orb.giop.ClientConnectionManager;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.iiop.IIOPAddress;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.orb.portableInterceptor.DefaultServerInterceptor;
import org.jacorb.orb.portableInterceptor.ServerRequestInfoImpl;
import org.omg.CORBA.BAD_PARAM;
import org.omg.IIOP.BiDirIIOPServiceContext;
import org.omg.IIOP.BiDirIIOPServiceContextHelper;
import org.omg.IIOP.ListenPoint;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.slf4j.Logger;

public class BiDirConnectionServerInterceptor
extends DefaultServerInterceptor {
    private static final String NAME = "BiDirConnectionServerInterceptor";
    private final ORB orb;
    private final Logger logger;
    private final ClientConnectionManager conn_mg;

    protected BiDirConnectionServerInterceptor(ORB orb) {
        this.orb = orb;
        this.logger = orb.getConfiguration().getLogger("org.jacorb.giop.bidir.interceptor");
        this.conn_mg = orb.getClientConnectionManager();
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void receive_request_service_contexts(ServerRequestInfo requestInfo) throws ForwardRequest {
        if (this.orb.useBiDirGIOP()) {
            try {
                ServiceContext context = requestInfo.get_request_service_context(5);
                this.addConnections(requestInfo, context);
            }
            catch (BAD_PARAM e) {
                this.logger.debug("no BiDir context present");
            }
        }
    }

    private void addConnections(ServerRequestInfo requestInfo, ServiceContext ctx) {
        BiDirIIOPServiceContext bidir_ctx = this.readBiDirContext(ctx);
        GIOPConnection connection = ((ServerRequestInfoImpl)requestInfo).getConnection();
        IIOPProfile prof = null;
        int numLP = bidir_ctx.listen_points.length;
        ArrayList<IIOPAddress> alternates = numLP == 1 ? null : new ArrayList<IIOPAddress>(numLP - 1);
        for (int i = 0; i < numLP; ++i) {
            ListenPoint listenPoint = bidir_ctx.listen_points[i];
            IIOPAddress addr = new IIOPAddress(listenPoint.host, listenPoint.port);
            try {
                addr.configure(this.orb.getConfiguration());
            }
            catch (ConfigurationException ce) {
                this.logger.warn("ConfigurationException", ce);
            }
            if (i == 0) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("BiDirIIOPContext: Client conn. added to target " + addr);
                }
                prof = new IIOPProfile(addr, null, connection.profile.version().minor);
                continue;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("BiDirIIOPContext: target alternate " + addr);
            }
            alternates.add(addr);
        }
        if (numLP > 1) {
            prof.setAlternateAddresses(alternates);
        }
        this.conn_mg.addConnection(connection, prof);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BiDirIIOPServiceContext readBiDirContext(ServiceContext ctx) {
        CDRInputStream cdr_in = new CDRInputStream(this.orb, ctx.context_data);
        try {
            cdr_in.openEncapsulatedArray();
            BiDirIIOPServiceContext biDirIIOPServiceContext = BiDirIIOPServiceContextHelper.read(cdr_in);
            return biDirIIOPServiceContext;
        }
        finally {
            cdr_in.close();
        }
    }
}

