/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.sas;

import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.ORB;
import org.jacorb.orb.portableInterceptor.ORBInitInfoImpl;
import org.jacorb.orb.standardInterceptors.SASComponentInterceptor;
import org.jacorb.security.sas.ATLASPolicyFactory;
import org.jacorb.security.sas.SASClientInterceptor;
import org.jacorb.security.sas.SASPolicyFactory;
import org.jacorb.security.sas.SASTargetInterceptor;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.LocalObject;
import org.omg.IOP.CodecFactoryPackage.UnknownEncoding;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitializer;
import org.slf4j.Logger;

public class SASInitializer
extends LocalObject
implements ORBInitializer {
    private Logger logger = null;
    public static final int SecurityAttributeService = 15;
    public static int sasPrincipalNamePIC = -1;

    @Override
    public void post_init(ORBInitInfo info) {
        block12: {
            ORB orb = ((ORBInitInfoImpl)info).getORB();
            this.logger = orb.getConfiguration().getLogger("org.jacorb.security.sas.log.verbosity");
            try {
                sasPrincipalNamePIC = info.allocate_slot_id();
                info.add_server_request_interceptor(new SASTargetInterceptor(info));
            }
            catch (ConfigurationException ce) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("ConfigurationException", ce);
                }
            }
            catch (DuplicateName duplicateName) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("TSS DuplicateName", duplicateName);
                }
            }
            catch (UnknownEncoding unknownEncoding) {
                if (!this.logger.isErrorEnabled()) break block12;
                this.logger.error("TSS UnknownEncoding", unknownEncoding);
            }
        }
        try {
            info.add_client_request_interceptor(new SASClientInterceptor(info));
        }
        catch (ConfigurationException ce) {
            this.logger.error("ConfigurationException", ce);
            throw new INITIALIZE(ce.getMessage());
        }
        catch (DuplicateName duplicateName) {
            this.logger.error("CSS DuplicateName", duplicateName);
            throw new INITIALIZE(duplicateName.getMessage());
        }
        catch (UnknownEncoding unknownEncoding) {
            this.logger.error("CSS UnknownEncoding", unknownEncoding);
            throw new INITIALIZE(unknownEncoding.getMessage());
        }
        try {
            info.add_ior_interceptor(new SASComponentInterceptor(info));
        }
        catch (DuplicateName duplicateName) {
            this.logger.error("IOR DuplicateName", duplicateName);
            throw new INITIALIZE(duplicateName.getMessage());
        }
        info.register_policy_factory(102, new SASPolicyFactory());
        info.register_policy_factory(103, new ATLASPolicyFactory());
    }

    @Override
    public void pre_init(ORBInitInfo info) {
    }
}

