/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.core;

import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.openbus.core.ConnectionImpl;
import tecgraf.openbus.core.v2_1.services.access_control.LoginInfo;

class InternalLogin {
    private static final Logger logger = Logger.getLogger(ConnectionImpl.class.getName());
    private LoginInfo login = null;
    private LoginInfo invalid = null;
    private final ConnectionImpl conn;

    InternalLogin(ConnectionImpl conn) {
        this.conn = conn;
        this.setLoggedOut();
    }

    LoginInfo login() {
        this.conn.readLock().lock();
        try {
            LoginInfo loginInfo = this.login;
            return loginInfo;
        }
        finally {
            this.conn.readLock().unlock();
        }
    }

    LoginInfo invalid() {
        this.conn.readLock().lock();
        try {
            LoginInfo loginInfo = this.invalid;
            return loginInfo;
        }
        finally {
            this.conn.readLock().unlock();
        }
    }

    LoginInfo getLogin() {
        this.conn.readLock().lock();
        LoginInfo login = this.login;
        LoginInfo invalid = this.invalid;
        this.conn.readLock().unlock();
        if (login == null) {
            while (invalid != null) {
                try {
                    this.conn.invalidLogin(invalid);
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, "Callback 'onInvalidLogin' gerou um erro durante execu\u00e7\u00e3o.", ex);
                }
                LoginInfo curr = this.invalid();
                if (curr != null && curr.id.equals(invalid.id) && curr.entity.equals(invalid.entity)) {
                    invalid = null;
                    this.conn.writeLock().lock();
                    this.invalid = null;
                    this.conn.writeLock().unlock();
                    continue;
                }
                invalid = curr;
            }
            login = this.login();
        }
        return login;
    }

    void setLoggedIn(LoginInfo login) {
        this.conn.writeLock().lock();
        this.login = login;
        this.invalid = null;
        this.conn.writeLock().unlock();
    }

    LoginInfo setLoggedOut() {
        this.conn.writeLock().lock();
        LoginInfo old = this.login;
        this.login = null;
        this.invalid = null;
        this.conn.writeLock().unlock();
        return old;
    }

    void setInvalid() {
        this.conn.writeLock().lock();
        this.invalid = this.login;
        this.login = null;
        this.conn.writeLock().unlock();
    }
}

