/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.configuration.validators;

import busexplorer.Application;
import busexplorer.ApplicationIcons;
import busexplorer.desktop.dialog.InputDialog;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.panel.ActionType;
import busexplorer.panel.OpenBusAction;
import busexplorer.panel.configuration.validators.ValidatorWrapper;
import busexplorer.utils.BusExplorerTask;
import java.awt.event.ActionEvent;
import javax.swing.JFrame;
import tecgraf.openbus.admin.BusAdminFacade;

public class ValidatorRestartAction
extends OpenBusAction<ValidatorWrapper> {
    public ValidatorRestartAction(JFrame parentWindow) {
        super(parentWindow);
        this.putValue("ShortDescription", this.getString("tooltip"));
        this.putValue("SmallIcon", ApplicationIcons.ICON_RESTART_16);
    }

    @Override
    public ActionType getActionType() {
        return ActionType.OTHER_SINGLE_SELECTION;
    }

    @Override
    public boolean abilityConditions() {
        return Application.login() != null && Application.login().hasAdminRights();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (InputDialog.showConfirmDialog(this.parentWindow, this.getString("confirm.explanation") + "\n" + this.getString("confirm.msg"), this.getString("confirm.title")) != 0) {
            return;
        }
        BusExplorerTask<Void> task = new BusExplorerTask<Void>(ExceptionContext.BusCore){

            @Override
            protected void doPerformTask() throws Exception {
                BusAdminFacade admin = Application.login().admin;
                String validator = ((ValidatorWrapper)ValidatorRestartAction.this.getTablePanelComponent().getSelectedElement()).getValidator();
                admin.delPasswordValidator(validator);
                admin.addPasswordValidator(validator);
            }

            @Override
            protected void afterTaskUI() {
            }
        };
        task.execute(this.parentWindow, this.getString("waiting.title"), this.getString("waiting.msg"), 2, 0);
    }
}

