/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.healing;

import busexplorer.Application;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.panel.OpenBusAction;
import busexplorer.panel.TablePanelComponent;
import busexplorer.panel.authorizations.AuthorizationDeleteAction;
import busexplorer.panel.authorizations.AuthorizationRefreshAction;
import busexplorer.panel.authorizations.AuthorizationTableProvider;
import busexplorer.panel.authorizations.AuthorizationWrapper;
import busexplorer.panel.entities.EntityWrapper;
import busexplorer.utils.BusExplorerTask;
import busexplorer.utils.BusQuery;
import busexplorer.utils.Language;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.swing.JFrame;
import tecgraf.javautils.gui.table.ObjectTableModel;
import tecgraf.openbus.core.v2_1.services.offer_registry.admin.v1_0.RegisteredEntityDesc;
import tecgraf.openbus.services.governance.v1_0.Provider;

public class AuthorizationMissingProvider
extends AuthorizationRefreshAction {
    private Consumer<TablePanelComponent> updateReportHook = null;

    public AuthorizationMissingProvider(JFrame parentWindow) {
        super(parentWindow);
    }

    public AuthorizationMissingProvider(JFrame parentWindow, Consumer<TablePanelComponent> updateReportHook) {
        this(parentWindow);
        this.updateReportHook = updateReportHook;
    }

    protected TablePanelComponent<AuthorizationWrapper> buildTableComponent() {
        if (this.getTablePanelComponent() == null) {
            ArrayList<OpenBusAction> actions = new ArrayList<OpenBusAction>();
            actions.add(new AuthorizationDeleteAction((JFrame)this.parentWindow));
            actions.add(this);
            this.setTablePanelComponent(new TablePanelComponent<AuthorizationWrapper>(new ObjectTableModel<AuthorizationWrapper>(new ArrayList(), new AuthorizationTableProvider()), actions, false, true));
        }
        return this.getTablePanelComponent();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.getTablePanelComponent().getElements().clear();
        if (!Application.login().extension.isExtensionCapable()) {
            return;
        }
        BusExplorerTask<List<AuthorizationWrapper>> task = new BusExplorerTask<List<AuthorizationWrapper>>(ExceptionContext.BusCore){

            @Override
            protected void doPerformTask() throws Exception {
                int i = 0;
                Map<RegisteredEntityDesc, List<String>> result = Application.login().admin.getAuthorizations();
                int size = result.size();
                List<Provider> providers = Application.login().extension.getProviders();
                Iterator<Map.Entry<RegisteredEntityDesc, List<String>>> it = result.entrySet().iterator();
                while (it.hasNext()) {
                    boolean found = false;
                    EntityWrapper entityGranted = new EntityWrapper(it.next().getKey());
                    for (Provider provider : providers) {
                        if (!provider.busquery().isEmpty()) {
                            Map<RegisteredEntityDesc, List<String>> map = new BusQuery(provider.busquery()).filterAuthorizations(result);
                            for (RegisteredEntityDesc providerEntity : map.keySet()) {
                                if (!new EntityWrapper(providerEntity).equals(entityGranted)) continue;
                                it.remove();
                                found = true;
                                break;
                            }
                        }
                        if (!found) continue;
                        break;
                    }
                    this.setProgressStatus(100 * i / size);
                    ++i;
                }
                this.setResult(AuthorizationWrapper.convertToInfo(result));
            }

            @Override
            protected void afterTaskUI() {
                if (this.getStatus()) {
                    TablePanelComponent tablePanelComponent = AuthorizationMissingProvider.this.getTablePanelComponent();
                    if (((List)this.getResult()).isEmpty() && AuthorizationMissingProvider.this.updateReportHook != null && tablePanelComponent.getParent() != null) {
                        AuthorizationMissingProvider.this.updateReportHook.accept(tablePanelComponent);
                    } else {
                        tablePanelComponent.setElements((List)this.getResult());
                    }
                }
            }
        };
        task.execute(this.parentWindow, Language.get(this.getClass().getSuperclass(), "waiting.title"), Language.get(this.getClass().getSuperclass(), "waiting.msg"), 2, 0, true, false);
    }
}

