/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.healing;

import busexplorer.Application;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.panel.OpenBusAction;
import busexplorer.panel.TablePanelComponent;
import busexplorer.panel.providers.ProviderDeleteAction;
import busexplorer.panel.providers.ProviderEditAction;
import busexplorer.panel.providers.ProviderRefreshAction;
import busexplorer.panel.providers.ProviderTableProvider;
import busexplorer.panel.providers.ProviderWrapper;
import busexplorer.utils.BusExplorerTask;
import busexplorer.utils.Language;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JFrame;
import tecgraf.javautils.gui.table.ObjectTableModel;
import tecgraf.openbus.services.governance.v1_0.Provider;

public class ProviderMissingContracts
extends ProviderRefreshAction {
    private Consumer<TablePanelComponent> updateReportHook = null;

    public ProviderMissingContracts(JFrame parentWindow) {
        super(parentWindow);
    }

    public ProviderMissingContracts(JFrame parentWindow, Consumer<TablePanelComponent> updateReportHook) {
        this(parentWindow);
        this.updateReportHook = updateReportHook;
    }

    protected TablePanelComponent<ProviderWrapper> buildTableComponent() {
        if (this.getTablePanelComponent() == null) {
            ArrayList<OpenBusAction> actions = new ArrayList<OpenBusAction>();
            actions.add(new ProviderDeleteAction(this.parentWindow));
            actions.add(new ProviderEditAction((JFrame)this.parentWindow));
            actions.add(this);
            this.setTablePanelComponent(new TablePanelComponent<ProviderWrapper>(new ObjectTableModel<ProviderWrapper>(new ArrayList(), new ProviderTableProvider()), actions, false, true));
        }
        return this.getTablePanelComponent();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.getTablePanelComponent().getElements().clear();
        if (!Application.login().extension.isExtensionCapable()) {
            return;
        }
        BusExplorerTask<List<ProviderWrapper>> task = new BusExplorerTask<List<ProviderWrapper>>(ExceptionContext.BusCore){

            @Override
            protected void doPerformTask() throws Exception {
                int i = 0;
                ArrayList<Provider> result = new ArrayList<Provider>();
                List<Provider> providers = Application.login().extension.getProviders();
                for (Provider provider : providers) {
                    if (provider.contracts().length == 0) {
                        result.add(provider);
                    }
                    this.setProgressStatus(100 * i / providers.size());
                    ++i;
                }
                this.setResult(ProviderWrapper.convertToInfo(result));
            }

            @Override
            protected void afterTaskUI() {
                if (this.getStatus()) {
                    TablePanelComponent tablePanelComponent = ProviderMissingContracts.this.getTablePanelComponent();
                    if (((List)this.getResult()).isEmpty() && ProviderMissingContracts.this.updateReportHook != null && tablePanelComponent.getParent() != null) {
                        ProviderMissingContracts.this.updateReportHook.accept(tablePanelComponent);
                    } else {
                        tablePanelComponent.setElements((List)this.getResult());
                    }
                }
            }
        };
        task.execute(this.parentWindow, Language.get(this.getClass().getSuperclass(), "waiting.title"), Language.get(this.getClass().getSuperclass(), "waiting.msg"), 2, 0, true, false);
    }
}

