/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.config;

import java.io.File;
import java.io.IOException;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.config.JacORBLogFormatter;
import org.jacorb.config.LoggingInitializer;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.ORBSingleton;

public class JdkLoggingInitializer
extends LoggingInitializer {
    private static final boolean ISJDKLOGGING;
    private static final boolean USEJACORBCONFIG;
    private Logger rootLogger;

    private Level toJdkLogLevel(String level) {
        if (level == null || level.length() == 0) {
            return Level.INFO;
        }
        try {
            int logLevel = Integer.parseInt(level.trim());
            switch (logLevel) {
                case 0: {
                    return Level.OFF;
                }
                case 1: {
                    return Level.SEVERE;
                }
                case 2: {
                    return Level.WARNING;
                }
                default: {
                    return Level.INFO;
                }
                case 4: {
                    return Level.FINER;
                }
                case 5: 
            }
            return Level.FINEST;
        }
        catch (NumberFormatException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void init(Configuration config) throws ConfigurationException {
        StreamHandler handler;
        if (!ISJDKLOGGING || !USEJACORBCONFIG) {
            return;
        }
        String level = config.getAttribute("jacorb.log.default.verbosity", "3");
        String file = config.getAttribute("jacorb.logfile", null);
        boolean showThread = config.getAttributeAsBoolean("jacorb.log.showThread", false);
        boolean showSrcInfo = config.getAttributeAsBoolean("jacorb.log.showSrcInfo", false);
        String clockFormat = config.getAttribute("jacorb.log.clockFormat", JacORBLogFormatter.ClockFormat.NONE.toString());
        this.rootLogger = Logger.getLogger("org.jacorb");
        this.rootLogger.setUseParentHandlers(false);
        this.rootLogger.setLevel(this.toJdkLogLevel(level));
        this.purgeHandlers(this.rootLogger);
        if (file != null && file.length() > 0) {
            if (new File(file).isDirectory()) {
                file = file.concat(File.separatorChar + "$implname");
            }
            try {
                handler = new FileHandler(this.substituteImplname(file, config), config.getAttributeAsInteger("jacorb.logfile.maxLogSize", 0), config.getAttributeAsInteger("jacorb.logfile.rotateCount", 1), config.getAttributeAsBoolean("jacorb.logfile.append", false));
            }
            catch (IOException ex) {
                System.err.println("could not write log file");
                ex.printStackTrace();
                handler = new ConsoleHandler();
            }
            catch (ConfigurationException ex) {
                System.err.println("could not write log file due to configuration exception");
                ex.printStackTrace();
                handler = new ConsoleHandler();
            }
        } else {
            handler = new ConsoleHandler();
        }
        handler.setLevel(this.toJdkLogLevel(level));
        handler.setFormatter(new JacORBLogFormatter(showThread, showSrcInfo, JacORBLogFormatter.ClockFormat.getClockFormat(clockFormat)));
        this.rootLogger.addHandler(handler);
    }

    @Override
    public void shutdownLogging() {
        if (ISJDKLOGGING) {
            Handler[] handlers = this.rootLogger.getHandlers();
            this.purgeHandlers(this.rootLogger);
            if (handlers.length > 0) {
                ConsoleHandler c = new ConsoleHandler();
                c.setFormatter(handlers[0].getFormatter());
                c.setLevel(handlers[0].getLevel());
                this.rootLogger.addHandler(c);
            }
        }
    }

    private void purgeHandlers(Logger rootLogger) {
        Handler[] handlers = rootLogger.getHandlers();
        if (handlers != null && handlers.length > 0) {
            for (int i = 0; i < handlers.length; ++i) {
                handlers[i].close();
                rootLogger.removeHandler(handlers[i]);
            }
        }
    }

    static {
        USEJACORBCONFIG = System.getProperty("java.util.logging.config.file") == null;
        Class<?> c = null;
        try {
            c = ObjectUtil.classForName("org.slf4j.impl.JDK14LoggerAdapter");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ISJDKLOGGING = c != null;
        ORBSingleton.init();
    }
}

