/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.ir.RepositoryID;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.LocateReplyReceiver;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.Reference;
import org.jacorb.orb.ReplyGroup;
import org.jacorb.orb.ReplyReceiver;
import org.jacorb.orb.ServantObjectImpl;
import org.jacorb.orb.SpecificProfileSelector;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.dii.Request;
import org.jacorb.orb.giop.ClientConnection;
import org.jacorb.orb.giop.ClientConnectionManager;
import org.jacorb.orb.giop.LocateReplyInputStream;
import org.jacorb.orb.giop.LocateRequestOutputStream;
import org.jacorb.orb.giop.ReplyInputStream;
import org.jacorb.orb.giop.RequestOutputStream;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.orb.miop.MIOPProfile;
import org.jacorb.orb.policies.PolicyManager;
import org.jacorb.orb.portableInterceptor.ClientInterceptorHandler;
import org.jacorb.orb.portableInterceptor.ClientInterceptorIterator;
import org.jacorb.orb.portableInterceptor.ClientRequestInfoImpl;
import org.jacorb.orb.portableInterceptor.DefaultClientInterceptorHandler;
import org.jacorb.orb.portableInterceptor.NullClientInterceptorHandler;
import org.jacorb.orb.portableInterceptor.ServerRequestInfoImpl;
import org.jacorb.poa.POA;
import org.jacorb.poa.util.POAUtil;
import org.jacorb.util.ObjectUtil;
import org.jacorb.util.SelectorManager;
import org.jacorb.util.Time;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Context;
import org.omg.CORBA.ContextList;
import org.omg.CORBA.DomainManager;
import org.omg.CORBA.ExceptionList;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.InterfaceDefHelper;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NVList;
import org.omg.CORBA.NamedValue;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyHelper;
import org.omg.CORBA.PolicyListHolder;
import org.omg.CORBA.SetOverrideType;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.RemarshalException;
import org.omg.CORBA.portable.ServantObject;
import org.omg.ETF.Profile;
import org.omg.IOP.IOR;
import org.omg.IOP.ServiceContext;
import org.omg.Messaging.RelativeRequestTimeoutPolicy;
import org.omg.Messaging.RelativeRoundtripTimeoutPolicy;
import org.omg.Messaging.ReplyEndTimePolicy;
import org.omg.Messaging.ReplyHandler;
import org.omg.Messaging.ReplyStartTimePolicy;
import org.omg.Messaging.RequestEndTimePolicy;
import org.omg.Messaging.RequestStartTimePolicy;
import org.omg.Messaging.SyncScopePolicy;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantLocator;
import org.omg.PortableServer.ServantLocatorPackage.CookieHolder;
import org.omg.RTCORBA.ClientProtocolPolicy;
import org.omg.RTCORBA.Protocol;
import org.omg.TimeBase.UtcT;
import org.slf4j.Logger;

public final class Delegate
extends org.omg.CORBA_2_3.portable.Delegate {
    private ParsedIOR _pior = null;
    private IOR ior = null;
    private ClientConnection[] connections = new ClientConnection[2];
    private TransportType currentConnection = TransportType.IIOP;
    private ParsedIOR piorOriginal = null;
    private ParsedIOR piorForward = null;
    private boolean bound = false;
    private POA poa;
    private final ORB orb;
    private final Logger logger;
    private boolean resolved_locality = false;
    private final ConcurrentHashMap<Profile, ReplyGroup> groups;
    private final java.lang.Object bind_sync = new java.lang.Object();
    private boolean locate_on_bind_performed = false;
    private final ClientConnectionManager conn_mg;
    private final Map<Integer, Policy> policy_overrides;
    private CookieHolder cookie = null;
    private String invokedOperation = null;
    private final SelectorManager selectorManager;
    private static final ThreadLocal<ClientInterceptorHandler> localInterceptors = new ThreadLocal();
    private final Configuration configuration;
    private boolean locateOnBind;
    private int maxBuiltinRetries = 0;
    private int defaultGiopMinor;
    private boolean disconnectAfterNonRecoverableSystemException;
    private boolean avoidIsARemoteCall = true;
    private boolean isLocalHistoricalInterceptors = false;
    private boolean disableClientOrbPolicies;
    private Random randomDelay = null;
    private SyncScope defaultSyncScope = SyncScope.TRANSPORT;
    private static final ThreadLocal<Boolean> ignoreNextCallToIsLocal = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private static final ThreadLocal<ArrayDeque<Map<INVOCATION_KEY, UtcT>>> invocationContext = new ThreadLocal<ArrayDeque<Map<INVOCATION_KEY, UtcT>>>(){

        @Override
        protected ArrayDeque<Map<INVOCATION_KEY, UtcT>> initialValue() {
            return new ArrayDeque<Map<INVOCATION_KEY, UtcT>>();
        }
    };

    public static final ArrayDeque<Map<INVOCATION_KEY, UtcT>> getInvocationContext() {
        return invocationContext.get();
    }

    public static void clearInvocationContext() {
        Map<INVOCATION_KEY, UtcT> currentCtxt;
        ArrayDeque<Map<INVOCATION_KEY, UtcT>> invocationStack = Delegate.getInvocationContext();
        if (!invocationStack.isEmpty() && (!(currentCtxt = invocationStack.peek()).containsKey((java.lang.Object)INVOCATION_KEY.INTERCEPTOR_CALL) && !currentCtxt.containsKey((java.lang.Object)INVOCATION_KEY.SERVANT_PREINVOKE) || currentCtxt.containsKey((java.lang.Object)INVOCATION_KEY.CLEAR_ALLOWED))) {
            invocationStack.pop();
        }
    }

    private Delegate(ORB orb, Configuration config, boolean parseIORLazy) {
        this.orb = orb;
        this.configuration = config;
        this.conn_mg = orb.getClientConnectionManager();
        this.selectorManager = orb.getSelectorManager();
        this.logger = config.getLogger("org.jacorb.orb.delegate");
        this.locateOnBind = config.getAttributeAsBoolean("jacorb.locate_on_bind", false);
        this.avoidIsARemoteCall = config.getAttributeAsBoolean("jacorb.avoidIsARemoteCall", true);
        this.isLocalHistoricalInterceptors = config.getAttributeAsBoolean("jacorb.isLocalHistoricalInterceptors", false);
        try {
            this.maxBuiltinRetries = config.getAttributeAsInteger("jacorb.maxBuiltinRetries", 0);
            if (this.maxBuiltinRetries < 0) {
                this.logger.error("Configuration error - max builtin retries < 0");
                throw new INTERNAL("Configuration error - max builtin retries < 0");
            }
        }
        catch (ConfigurationException ex) {
            this.logger.error("Configuration exception retrieving max builtin retries", ex);
            throw new INTERNAL("Configuration exception retrieving max builtin retries" + ex);
        }
        this.disconnectAfterNonRecoverableSystemException = config.getAttributeAsBoolean("jacorb.connection.client.disconnect_after_systemexception", true);
        this.disableClientOrbPolicies = config.getAttributeAsBoolean("jacorb.disableClientOrbPolicies", false);
        try {
            this.defaultGiopMinor = this.configuration.getAttributeAsInteger("jacorb.giop_minor_version", 2);
        }
        catch (ConfigurationException ex) {
            this.logger.error("Configuration exception retrieving giop minor version", ex);
            throw new INTERNAL("Configuration exception retrieving giop minor version" + ex);
        }
        try {
            this.defaultSyncScope = SyncScope.getSyncScope(this.configuration.getAttribute("jacorb.default_sync_scope", "TRANSPORT"));
        }
        catch (ConfigurationException ex) {
            this.logger.error("Configuration exception retrieving default sync scope ", ex);
            throw new INTERNAL("Configuration exception retrieving default sync scope " + ex);
        }
        this.groups = new ConcurrentHashMap();
        this.policy_overrides = parseIORLazy ? (this.disableClientOrbPolicies ? Collections.emptyMap() : new HashMap<Integer, Policy>(0)) : (this.disableClientOrbPolicies ? Collections.emptyMap() : new HashMap<Integer, Policy>());
    }

    private Delegate(ORB orb, boolean parseIORLazy) {
        this(orb, orb.getConfiguration(), parseIORLazy);
    }

    public Delegate(ORB orb, ParsedIOR pior) {
        this(orb, false);
        this.piorOriginal = pior;
        this.resetPior();
    }

    public Delegate(ORB orb, IOR ior, boolean parseIORLazy) {
        this(orb, parseIORLazy);
        this.ior = ior;
        if (!parseIORLazy) {
            this.getParsedIOR();
        }
    }

    public Delegate(ORB orb, IOR ior) {
        this(orb, ior, false);
    }

    public int _get_TCKind() {
        return 14;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bind() {
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            block19: {
                Profile profile;
                if (this.bound) {
                    return;
                }
                ParsedIOR ior = this.getParsedIOR();
                ior.patchSSL();
                Protocol[] protocols = this.getClientProtocols();
                if (protocols != null && !ior.isProfileSelectorSet()) {
                    ior.setProfileSelector(new SpecificProfileSelector(protocols));
                }
                if ((profile = ior.getEffectiveProfile()) == null) {
                    throw new COMM_FAILURE("no effective profile");
                }
                if (profile instanceof MIOPProfile) {
                    this.connections[TransportType.MIOP.ordinal()] = this.conn_mg.getConnection(profile);
                    profile = ((MIOPProfile)profile).getGroupIIOPProfile();
                }
                if (profile != null) {
                    this.connections[TransportType.IIOP.ordinal()] = this.conn_mg.getConnection(profile);
                }
                this.bound = true;
                if (this.locateOnBind && !this.locate_on_bind_performed) {
                    this.locate_on_bind_performed = true;
                    try {
                        LocateRequestOutputStream lros = new LocateRequestOutputStream(this.orb, ior.get_object_key(), this.connections[this.currentConnection.ordinal()].getId(), ior.getEffectiveProfile().version().minor);
                        LocateReplyReceiver receiver = new LocateReplyReceiver();
                        receiver.configure(this.configuration);
                        this.connections[this.currentConnection.ordinal()].sendRequest(lros, receiver, lros.getRequestId(), true);
                        this.getParsedIOR().markLastUsedProfile();
                        LocateReplyInputStream lris = receiver.getReply();
                        switch (lris.rep_hdr.locate_status.value()) {
                            case 0: {
                                throw new UNKNOWN("Could not bind to object, server does not know it!");
                            }
                            case 1: {
                                break;
                            }
                            case 2: 
                            case 3: {
                                this.forwardToObj(lris.read_Object());
                                break;
                            }
                            case 4: {
                                throw SystemExceptionHelper.read(lris);
                            }
                            case 5: {
                                throw new NO_IMPLEMENT("Server responded to LocateRequest with a status of LOC_NEEDS_ADDRESSING_MODE, but this isn't yet implemented by JacORB");
                            }
                            default: {
                                throw new IllegalArgumentException("Unknown reply status for LOCATE_REQUEST: " + lris.rep_hdr.locate_status.value());
                            }
                        }
                    }
                    catch (SystemException se) {
                        throw se;
                    }
                    catch (Exception e) {
                        if (!this.logger.isWarnEnabled()) break block19;
                        this.logger.warn(e.getMessage());
                    }
                }
            }
        }
    }

    public void forwardToObj(Object obj) {
        String object_reference = this.orb.object_to_string(obj);
        if (object_reference == null || object_reference.indexOf("IOR:") != 0) {
            throw new INV_OBJREF("Not an IOR: " + object_reference);
        }
        Delegate delegate = (Delegate)((ObjectImpl)obj)._get_delegate();
        this.forwardPior(new ParsedIOR(this.orb, object_reference));
        this.rebindWithProto(delegate == null ? null : delegate.getClientProtocols());
    }

    private void rebind() {
        this.rebindWithProto(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebindWithProto(Protocol[] protocols) {
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            ParsedIOR pior = this.getParsedIOR();
            if (protocols != null) {
                pior.setProfileSelector(new SpecificProfileSelector(protocols));
            } else {
                Protocol[] thisProtocols = this.getClientProtocols();
                if (thisProtocols != null && !pior.isProfileSelectorSet()) {
                    pior.setProfileSelector(new SpecificProfileSelector(thisProtocols));
                }
            }
            if (this.connections[TransportType.IIOP.ordinal()] != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Delegate.rebind, releasing connection");
                }
                this.conn_mg.releaseConnection(this.connections[TransportType.IIOP.ordinal()]);
                this.connections[TransportType.IIOP.ordinal()] = null;
            }
            if (this.connections[TransportType.MIOP.ordinal()] != null) {
                this.conn_mg.releaseConnection(this.connections[TransportType.MIOP.ordinal()]);
                this.connections[TransportType.MIOP.ordinal()] = null;
            }
            this.bound = false;
            this.bind();
        }
    }

    @Override
    public org.omg.CORBA.Request create_request(Object self, Context ctx, String operation, NVList args, NamedValue result) {
        this.checkORB();
        this.bind();
        return new Request(self, this.orb, this.connections[this.currentConnection.ordinal()], this.getParsedIOR().get_object_key(), operation, args, ctx, result);
    }

    @Override
    public org.omg.CORBA.Request create_request(Object self, Context ctx, String operation, NVList args, NamedValue result, ExceptionList exceptions, ContextList contexts) {
        this.checkORB();
        this.bind();
        return new Request(self, this.orb, this.connections[this.currentConnection.ordinal()], this.getParsedIOR().get_object_key(), operation, args, ctx, result, exceptions, contexts);
    }

    @Override
    public Object duplicate(Object self) {
        return this.orb._getDelegate(new ParsedIOR(this.orb, this.toString()));
    }

    public boolean equals(java.lang.Object obj) {
        return obj instanceof Object && this.toString().equals(obj.toString());
    }

    @Override
    public boolean equals(Object self, java.lang.Object obj) {
        return this.equals(obj);
    }

    @Override
    public DomainManager[] get_domain_managers(Object self) {
        return null;
    }

    @Override
    public Policy get_policy(Object self, int policy_type) {
        Policy result = this.get_client_policy(policy_type);
        if (result != null) {
            return result;
        }
        return this.get_policy(self, policy_type, this.request(self, "_get_policy", true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Policy get_client_policy(int policy_type) {
        Policy[] orbPolicies;
        PolicyManager policyManager;
        Policy result = null;
        if (this.disableClientOrbPolicies) {
            return null;
        }
        Map<Integer, Policy> map = this.policy_overrides;
        synchronized (map) {
            Integer key = policy_type;
            result = this.policy_overrides.get(key);
        }
        if (result == null && (policyManager = this.orb.getPolicyManager()) != null && (orbPolicies = policyManager.get_policy_overrides(new int[]{policy_type})) != null && orbPolicies.length == 1) {
            result = orbPolicies[0];
        }
        return result;
    }

    public Policy get_policy(Object self, int policy_type, OutputStream os) {
        while (true) {
            try {
                os.write_Object(self);
                os.write_long(policy_type);
                InputStream is = this.invoke(self, os);
                return PolicyHelper.narrow(is.read_Object());
            }
            catch (RemarshalException r) {
                continue;
            }
            catch (ApplicationException _ax) {
                String _id = _ax.getId();
                throw new INTERNAL("Unexpected exception " + _id);
            }
            break;
        }
    }

    public UtcT getRequestEndTime() {
        Policy policy = this.get_client_policy(28);
        if (policy != null) {
            return ((RequestEndTimePolicy)policy).end_time();
        }
        return null;
    }

    public UtcT getReplyEndTime() {
        Policy policy = this.get_client_policy(30);
        if (policy != null) {
            return ((ReplyEndTimePolicy)policy).end_time();
        }
        return null;
    }

    public UtcT getRequestStartTime() {
        Policy policy = this.get_client_policy(27);
        if (policy != null) {
            return ((RequestStartTimePolicy)policy).start_time();
        }
        return null;
    }

    public UtcT getReplyStartTime() {
        Policy policy = this.get_client_policy(29);
        if (policy != null) {
            return ((ReplyStartTimePolicy)policy).start_time();
        }
        return null;
    }

    public long getRelativeRoundtripTimeout() {
        Policy policy = this.get_client_policy(32);
        if (policy != null) {
            return ((RelativeRoundtripTimeoutPolicy)policy).relative_expiry();
        }
        return -1L;
    }

    public long getRelativeRequestTimeout() {
        Policy policy = this.get_client_policy(31);
        if (policy != null) {
            return ((RelativeRequestTimeoutPolicy)policy).relative_expiry();
        }
        return -1L;
    }

    public short getSyncScope() {
        Policy policy = this.get_client_policy(24);
        if (policy != null) {
            return ((SyncScopePolicy)policy).synchronization();
        }
        return this.defaultSyncScope.getType();
    }

    public Protocol[] getClientProtocols() {
        Policy policy = this.get_client_policy(43);
        if (policy != null) {
            return ((ClientProtocolPolicy)policy).protocols();
        }
        return null;
    }

    @Override
    @Deprecated
    public InterfaceDef get_interface(Object self) {
        return InterfaceDefHelper.narrow(this.get_interface_def(self));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get_interface_def(Object self) {
        this.checkORB();
        if (this.is_really_local(self)) {
            ServantObject so = null;
            while (so == null) {
                so = this.servant_preinvoke(self, "_interface", java.lang.Object.class);
            }
            try {
                Servant servant = (Servant)so.servant;
                this.orb.set_delegate(servant);
                Object object = servant._get_interface_def();
                return object;
            }
            finally {
                this.servant_postinvoke(self, so);
            }
        }
        InputStream is = this.invokeBuiltin(self, "_interface", null);
        return is == null ? null : is.read_Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClientConnection getConnection() {
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            this.bind();
            return this.connections[this.currentConnection.ordinal()];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOR getIOR() {
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            return this.getBaseIOR().getIOR();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getObjectId() {
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            this.bind();
            return POAUtil.extractOID(this.getBaseIOR().get_object_key());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getObjectKey() {
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            this.bind();
            return this.getParsedIOR().get_object_key();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParsedIOR getBaseIOR() {
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            return this.piorOriginal == null ? this.getParsedIOR() : this.piorOriginal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParsedIOR getParsedIOR() {
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            if (this._pior == null) {
                if (this.ior == null) {
                    throw new INTERNAL("Internal error - unable to initialise ParsedIOR as IOR is null");
                }
                this.piorOriginal = new ParsedIOR(this.orb, this.ior);
                this.resetPior();
                this.ior = null;
            }
            return this._pior;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetPior() {
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            this._pior = this.piorOriginal;
            this.piorForward = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forwardPior(ParsedIOR fwd) {
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            if (!fwd.equals(this._pior)) {
                this._pior = this.piorForward = fwd;
            }
        }
    }

    private boolean isPiorForwarded() {
        return this._pior != this.piorOriginal;
    }

    public void resolvePOA(Object self) {
        if (!this.resolved_locality) {
            this.resolved_locality = true;
            POA local_poa = this.orb.findPOA(this, self);
            if (local_poa != null) {
                this.poa = local_poa;
            }
        }
    }

    public POA getPOA() {
        return this.poa;
    }

    public ObjectImpl getReference(POA _poa) {
        if (_poa != null) {
            this.poa = _poa;
        }
        String typeId = this.ior == null ? this.typeId() : this.ior.type_id;
        Reference reference = new Reference(typeId);
        ((ObjectImpl)((java.lang.Object)reference))._set_delegate(this);
        return reference;
    }

    @Override
    public int hash(Object self, int x) {
        this.checkORB();
        return this.hashCode();
    }

    public int hashCode() {
        return this.getIDString().hashCode();
    }

    @Override
    public int hashCode(Object self) {
        return this.hashCode();
    }

    public void invoke(Object self, OutputStream os, ReplyHandler replyHandler) throws ApplicationException, RemarshalException {
        this.invoke_internal(self, os, replyHandler, true);
    }

    @Override
    public InputStream invoke(Object self, OutputStream os) throws ApplicationException, RemarshalException {
        return this.invoke_internal(self, os, null, false);
    }

    private InputStream invoke_internal(Object self, OutputStream os, ReplyHandler replyHandler, boolean async) throws ApplicationException, RemarshalException {
        try {
            InputStream in = this._invoke_internal(self, os, replyHandler, async);
            Delegate.clearInvocationContext();
            return in;
        }
        catch (ApplicationException e) {
            Delegate.clearInvocationContext();
            throw e;
        }
        catch (SystemException t) {
            Delegate.clearInvocationContext();
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InputStream _invoke_internal(Object self, OutputStream os, ReplyHandler replyHandler, boolean async) throws ApplicationException, RemarshalException {
        ClientConnection connectionToUse;
        block38: {
            this.checkORB();
            RequestOutputStream ros = (RequestOutputStream)os;
            ArrayDeque<Map<INVOCATION_KEY, UtcT>> invocationStack = invocationContext.get();
            Map<INVOCATION_KEY, UtcT> currentCtxt = invocationStack.peek();
            UtcT reqET = null;
            UtcT repET = null;
            if (currentCtxt != null) {
                reqET = currentCtxt.get((java.lang.Object)INVOCATION_KEY.REQUEST_END_TIME);
                repET = currentCtxt.get((java.lang.Object)INVOCATION_KEY.REPLY_END_TIME);
                this.checkTimeout(reqET, repET);
            }
            ReplyReceiver receiver = null;
            ClientInterceptorHandler interceptors = this.orb.hasClientRequestInterceptors() ? new DefaultClientInterceptorHandler((DefaultClientInterceptorHandler)localInterceptors.get(), this.orb, ros, self, this, this.isPiorForwarded() ? this.getBaseIOR() : null, this.connections[this.currentConnection.ordinal()]) : NullClientInterceptorHandler.getInstance();
            if (this.connections[this.currentConnection.ordinal()] != null) {
                this.orb.notifyTransportListeners(this.connections[this.currentConnection.ordinal()].getGIOPConnection());
            }
            if (this.orb.hasRequestInterceptors()) {
                localInterceptors.set(interceptors);
                try {
                    interceptors.handle_send_request();
                }
                catch (ForwardRequest fwd) {
                }
                catch (RemarshalException re) {
                    throw re;
                }
                catch (RuntimeException e) {
                    localInterceptors.set(null);
                    throw e;
                }
            }
            connectionToUse = null;
            try {
                ReplyInputStream replyInputStream;
                ReplyGroup group;
                block36: {
                    group = null;
                    try {
                        java.lang.Object object = this.bind_sync;
                        synchronized (object) {
                            if (!this.bound) {
                                throw new COMM_FAILURE("Connection closed");
                            }
                            if (ros.getConnection() != this.connections[this.currentConnection.ordinal()]) {
                                this.logger.debug("invoke: RemarshalException");
                                throw new RemarshalException();
                            }
                            connectionToUse = this.connections[this.currentConnection.ordinal()];
                            connectionToUse.incClients();
                        }
                        group = this.getReplyGroup(connectionToUse);
                        if (!ros.response_expected()) {
                            this.invoke_oneway(ros, connectionToUse, interceptors, group);
                            break block36;
                        }
                        receiver = new ReplyReceiver(this, group, ros.operation(), ros.getReplyEndTime(), interceptors, replyHandler, this.selectorManager);
                        try {
                            receiver.configure(this.configuration);
                        }
                        catch (ConfigurationException ex) {
                            this.logger.error("Configuration problem with ReplyReceiver", ex);
                            throw new INTERNAL("Caught configuration exception setting up ReplyReceiver.");
                        }
                        group.addHolder(receiver);
                        connectionToUse.sendRequest(ros, receiver, ros.requestId(), true);
                        this.getParsedIOR().markLastUsedProfile();
                    }
                    catch (SystemException cfe) {
                        this.logger.debug("invoke[-->]: SystemException", cfe);
                        if (!async && group != null) {
                            group.removeHolder(receiver);
                        }
                        try {
                            interceptors.handle_receive_exception(cfe);
                        }
                        catch (ForwardRequest fwd) {
                        }
                        catch (RemarshalException e) {
                            this.logger.debug("ClientInterceptors receive_exception threw RemarshalException (via a ForwardRequest).resetting pior to avoid extraneous forwarding loop.");
                            this.resetPior();
                            throw e;
                        }
                        if (cfe instanceof TRANSIENT) {
                            if (this.checkNextProfile(false)) {
                                if (!this.logger.isDebugEnabled()) throw new RemarshalException();
                                this.logger.debug("Delegate._invoke_internal: looping on " + cfe);
                                throw new RemarshalException();
                            }
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug("Delegate._invoke_internal: Not looping on " + cfe);
                            }
                        }
                        if (cfe instanceof TIMEOUT) throw cfe;
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Delegate._invoke_internal: closing connection due to " + cfe);
                        }
                        this.disconnect(connectionToUse);
                        throw cfe;
                    }
                    finally {
                        if (this.orb.hasRequestInterceptors()) {
                            localInterceptors.set(null);
                        }
                    }
                }
                try {
                    if (async || receiver == null) break block38;
                    ReplyInputStream is = receiver.getReply();
                    ((CDRInputStream)is).updateMutatorConnection(connectionToUse.getGIOPConnection());
                    Delegate.clearInvocationContext();
                    if (currentCtxt.containsKey((java.lang.Object)INVOCATION_KEY.INTERCEPTOR_CALL) || currentCtxt.containsKey((java.lang.Object)INVOCATION_KEY.SERVANT_PREINVOKE)) {
                        currentCtxt.put(INVOCATION_KEY.CLEAR_ALLOWED, null);
                    }
                    replyInputStream = is;
                    if (connectionToUse == null) return replyInputStream;
                }
                catch (SystemException e) {
                    this.logger.debug("invoke[<--]: SystemException", e);
                    if (e instanceof OBJECT_NOT_EXIST && e.minor != 0 && this.checkNextProfile(true)) {
                        throw new RemarshalException();
                    }
                    if (group != null) {
                        group.removeHolder(receiver);
                    }
                    this.disconnect(connectionToUse);
                    throw e;
                }
                this.conn_mg.releaseConnection(connectionToUse);
                return replyInputStream;
            }
            catch (Throwable throwable) {
                if (connectionToUse == null) throw throwable;
                this.conn_mg.releaseConnection(connectionToUse);
                throw throwable;
            }
        }
        if (connectionToUse == null) return null;
        this.conn_mg.releaseConnection(connectionToUse);
        return null;
    }

    private void checkTimeout(UtcT reqET, UtcT repET) {
        if (reqET != null && Time.hasPassed(reqET)) {
            throw new TIMEOUT("Request End Time exceeded", 2, CompletionStatus.COMPLETED_NO);
        }
        if (repET != null && Time.hasPassed(repET)) {
            throw new TIMEOUT("Reply End Time exceeded", 3, CompletionStatus.COMPLETED_NO);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnect(ClientConnection connectionInUse) {
        if (connectionInUse == null) {
            return;
        }
        if (!this.disconnectAfterNonRecoverableSystemException) {
            return;
        }
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            if (this.connections[this.currentConnection.ordinal()] == null) {
                return;
            }
            if (this.connections[this.currentConnection.ordinal()] != connectionInUse) {
                return;
            }
            this.logger.debug("release the connection");
            this.conn_mg.releaseConnection(this.connections[this.currentConnection.ordinal()]);
            this.connections[this.currentConnection.ordinal()] = null;
            this.bound = false;
        }
    }

    private void invoke_oneway(RequestOutputStream ros, ClientConnection connectionToUse, ClientInterceptorHandler interceptors, ReplyGroup group) throws RemarshalException, ApplicationException {
        switch (ros.syncScope()) {
            case 0: {
                RequestOutputStream copy = new RequestOutputStream(ros);
                this.passToTransport(connectionToUse, copy);
                try {
                    interceptors.handle_receive_other((short)0);
                }
                catch (ForwardRequest fwd) {}
                break;
            }
            case 1: {
                connectionToUse.sendRequest(ros, false);
                this.getParsedIOR().markLastUsedProfile();
                try {
                    interceptors.handle_receive_other((short)0);
                }
                catch (ForwardRequest fwd) {}
                break;
            }
            case 2: 
            case 3: {
                ReplyReceiver rcv = new ReplyReceiver(this, group, ros.operation(), ros.getReplyEndTime(), interceptors, null, this.selectorManager);
                try {
                    rcv.configure(this.configuration);
                }
                catch (ConfigurationException ex) {
                    this.logger.error("Configuration problem with ReplyReceiver", ex);
                    throw new INTERNAL("Caught configuration exception setting up ReplyReceiver.");
                }
                if (this.connections[TransportType.MIOP.ordinal()] != null) {
                    this.connections[TransportType.MIOP.ordinal()].sendRequest(ros, false);
                } else {
                    connectionToUse.sendRequest(ros, rcv, ros.requestId(), true);
                }
                this.getParsedIOR().markLastUsedProfile();
                ReplyInputStream in = rcv.getReply();
                try {
                    interceptors.handle_receive_reply(in);
                }
                catch (ForwardRequest fwd) {}
                break;
            }
            default: {
                throw new MARSHAL("Illegal SYNC_SCOPE: " + ros.syncScope(), 0, CompletionStatus.COMPLETED_MAYBE);
            }
        }
    }

    private ReplyGroup getReplyGroup(ClientConnection connectionToUse) {
        Profile profile = connectionToUse.getRegisteredProfile();
        ReplyGroup group = this.groups.get(profile);
        if (group == null) {
            ReplyGroup g;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Adding new retry group for " + profile);
            }
            if ((group = this.groups.putIfAbsent(profile, g = new ReplyGroup(this, profile))) == null) {
                group = g;
            }
        }
        return group;
    }

    private void passToTransport(final ClientConnection connectionToUse, final RequestOutputStream ros) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        connectionToUse.sendRequest(ros, false);
                        Delegate.this.getParsedIOR().markLastUsedProfile();
                    }
                    catch (Throwable e) {
                        if (!Delegate.this.logger.isWarnEnabled()) break block2;
                        Delegate.this.logger.warn("Caught CORBA SystemException ", e);
                    }
                }
            }
        }, "PassToTransport").start();
    }

    private void randomMilliSecDelay() {
        int r;
        if (this.randomDelay == null) {
            this.randomDelay = new Random(10000L);
        }
        r = (r = this.randomDelay.nextInt(3100)) < 1000 ? 1000 : r;
        try {
            Thread.sleep(r);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkNextProfile(boolean forward_only) {
        boolean doRebind = false;
        if (forward_only && !this.isPiorForwarded()) {
            return false;
        }
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            if (this.getParsedIOR().getProfiles().size() > 1) {
                Profile curProfile = this.getParsedIOR().getNextEffectiveProfile();
                if (this.logger.isDebugEnabled()) {
                    Profile lastProfile = this.getParsedIOR().getLastUsedProfile();
                    this.logger.debug("checkNextProfile: new = " + curProfile + " last = " + lastProfile);
                }
                if (curProfile != null && !curProfile.equals(this.getParsedIOR().getLastUsedProfile())) {
                    doRebind = true;
                }
            }
            if (!doRebind) {
                ArrayDeque<Map<INVOCATION_KEY, UtcT>> invocationStack = invocationContext.get();
                Map<INVOCATION_KEY, UtcT> currentCtxt = invocationStack.peek();
                boolean doCorbaName = false;
                if (this.isPiorForwarded()) {
                    if (currentCtxt == null) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("checkNextProfile, current context is null");
                        }
                        return false;
                    }
                    if (currentCtxt.containsKey((java.lang.Object)INVOCATION_KEY.FORWARD_RESET)) {
                        return false;
                    }
                    this.resetPior();
                    doCorbaName = true;
                    currentCtxt.put(INVOCATION_KEY.FORWARD_RESET, null);
                    doRebind = true;
                } else {
                    boolean bl = doCorbaName = !currentCtxt.containsKey((java.lang.Object)INVOCATION_KEY.CORBANAME_RESET);
                }
                if (doCorbaName && this.getParsedIOR().useCorbaName()) {
                    currentCtxt.put(INVOCATION_KEY.CORBANAME_RESET, null);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Delegate.checkNextProfile: resetting corbaname for next use");
                    }
                    this.getParsedIOR().reparseCorbaName();
                }
            }
            if (doRebind) {
                this.rebind();
            }
            return doRebind;
        }
    }

    public void invokeInterceptors(ClientRequestInfoImpl info, short op) throws RemarshalException {
        block4: {
            ClientInterceptorIterator intercept_iter = this.orb.getInterceptorManager().getClientIterator();
            try {
                intercept_iter.iterate(info, op);
            }
            catch (ForwardRequest fwd) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Delegate.invokeInterceptors calling rebind on forward");
                }
                this.forwardToObj(fwd.forward);
                throw new RemarshalException();
            }
            catch (UserException ue) {
                if (!this.logger.isErrorEnabled()) break block4;
                this.logger.error(ue.getMessage());
            }
        }
    }

    @Override
    public String repository_id(Object self) {
        return this.getParsedIOR().getTypeId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean is_a(Object self, String logical_type_id) {
        InputStream is;
        if (this.ior != null && this.ior.type_id.equals(logical_type_id)) {
            return true;
        }
        ParsedIOR pior = this.getParsedIOR();
        if (pior.getTypeId().equals(logical_type_id)) {
            return true;
        }
        String[] ids = ((ObjectImpl)self)._ids();
        for (int i = 0; i < ids.length - 1; ++i) {
            if (!ids[i].equals(logical_type_id)) continue;
            return true;
        }
        if (this.is_really_local(self)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Located " + self + " on local POA; assuming local.");
            }
            ServantObject so = null;
            while (so == null) {
                so = this.servant_preinvoke(self, "_is_a", java.lang.Object.class);
            }
            try {
                Servant servant = (Servant)so.servant;
                this.orb.set_delegate(servant);
                boolean bl = servant._is_a(logical_type_id);
                return bl;
            }
            finally {
                this.servant_postinvoke(self, so);
            }
        }
        if (this.avoidIsARemoteCall && !ids[0].equals("IDL:omg.org/CORBA/Object:1.0")) {
            try {
                String classname = RepositoryID.className(ids[0], "Stub", null);
                int lastDot = classname.lastIndexOf(46);
                StringBuffer buffer = new StringBuffer(classname.substring(0, lastDot + 1));
                buffer.append('_');
                buffer.append(classname.substring(lastDot + 1));
                Class<?> stub = null;
                try {
                    stub = ObjectUtil.classForName(buffer.toString());
                }
                catch (ClassNotFoundException e) {
                    stub = ObjectUtil.classForName("org.omg.stub." + buffer.toString());
                }
                Method idm = stub.getMethod("_ids", null);
                String[] newids = (String[])idm.invoke(stub.newInstance(), (java.lang.Object[])null);
                for (int i = 0; i < newids.length; ++i) {
                    if (!newids[i].equals(logical_type_id)) continue;
                    return true;
                }
            }
            catch (ClassNotFoundException e) {
            }
            catch (IllegalArgumentException e) {
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
            }
            catch (InstantiationException e) {
            }
            catch (SystemException e) {
                // empty catch block
            }
            this.logger.debug("trying is_a remotely");
        }
        return (is = this.invokeBuiltin(self, "_is_a", logical_type_id)) == null ? false : is.read_boolean();
    }

    @Override
    public boolean is_equivalent(Object self, Object obj) {
        this.checkORB();
        boolean result = true;
        if (self != obj) {
            ParsedIOR pior1 = new ParsedIOR(this.orb, obj.toString());
            ParsedIOR pior2 = new ParsedIOR(this.orb, self.toString());
            result = pior2.getIDString().equals(pior1.getIDString());
        }
        return result;
    }

    public String getIDString() {
        return this.getParsedIOR().getIDString();
    }

    @Override
    public boolean is_local(Object self) {
        if (ignoreNextCallToIsLocal.get() == Boolean.TRUE) {
            ignoreNextCallToIsLocal.set(Boolean.FALSE);
            return false;
        }
        if (this.isLocalHistoricalInterceptors && localInterceptors.get() == null && this.orb.hasRequestInterceptors()) {
            return false;
        }
        return this.is_really_local(self);
    }

    private boolean is_really_local(Object self) {
        if (this.poa == null) {
            this.resolvePOA(self);
        }
        return this.poa != null;
    }

    public boolean is_nil() {
        ParsedIOR pior = this.getParsedIOR();
        return pior.getIOR().type_id.equals("") && pior.getIOR().profiles.length == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean non_existent(Object self) {
        if (this.is_really_local(self)) {
            ServantObject so = null;
            try {
                while (so == null) {
                    so = this.servant_preinvoke(self, "_non_existent", java.lang.Object.class);
                }
            }
            catch (OBJECT_NOT_EXIST e) {
                return true;
            }
            try {
                Servant servant = (Servant)so.servant;
                this.orb.set_delegate(servant);
                boolean bl = servant._non_existent();
                return bl;
            }
            finally {
                this.servant_postinvoke(self, so);
            }
        }
        InputStream is = null;
        try {
            is = this.invokeBuiltin(self, "_non_existent", null);
        }
        catch (OBJECT_NOT_EXIST e) {
            return true;
        }
        return is == null ? false : is.read_boolean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get_component(Object self) {
        if (this.is_really_local(self)) {
            ServantObject so = null;
            while (so == null) {
                so = this.servant_preinvoke(self, "_get_component", java.lang.Object.class);
            }
            try {
                Servant servant = (Servant)so.servant;
                this.orb.set_delegate(servant);
                Object object = servant._get_component();
                return object;
            }
            finally {
                this.servant_postinvoke(self, so);
            }
        }
        InputStream is = this.invokeBuiltin(self, "_get_component", null);
        return is == null ? null : is.read_Object();
    }

    private InputStream invokeBuiltin(Object self, String op, String arg) {
        for (int retries = 0; this.maxBuiltinRetries == 0 || retries < this.maxBuiltinRetries; ++retries) {
            try {
                OutputStream os = this.request(self, op, true);
                if (arg != null) {
                    os.write_string(arg);
                }
                return this.invoke(self, os);
            }
            catch (RemarshalException re) {
                continue;
            }
            catch (ApplicationException ax) {
                throw new INTERNAL("Unexpected exception " + ax.getId());
            }
        }
        return null;
    }

    @Override
    public org.omg.CORBA.ORB orb(Object self) {
        return this.orb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(Object self) {
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            if (!this.bound) {
                return;
            }
            if (this.connections[this.currentConnection.ordinal()] != null) {
                this.conn_mg.releaseConnection(this.connections[this.currentConnection.ordinal()]);
                this.connections[this.currentConnection.ordinal()] = null;
            }
            this.bound = false;
            this.orb._release(this.getParsedIOR().getIORString());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Delegate released!");
            }
        }
    }

    @Override
    public void releaseReply(Object self, InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Time.waitFor(this.getReplyStartTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public org.omg.CORBA.Request request(Object self, String operation) {
        this.orb.perform_work();
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            this.bind();
            return new Request(self, this.orb, this.connections[this.currentConnection.ordinal()], this.getParsedIOR().get_object_key(), operation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream request(Object self, String operation, boolean responseExpected) {
        this.orb.perform_work();
        ArrayDeque<Map<INVOCATION_KEY, UtcT>> invocationStack = Delegate.getInvocationContext();
        Map<INVOCATION_KEY, UtcT> currentCtxt = null;
        if (!invocationStack.isEmpty()) {
            currentCtxt = invocationStack.peek();
        }
        if (currentCtxt == null || currentCtxt.containsKey((java.lang.Object)INVOCATION_KEY.INTERCEPTOR_CALL) || currentCtxt.containsKey((java.lang.Object)INVOCATION_KEY.SERVANT_PREINVOKE)) {
            currentCtxt = new HashMap<INVOCATION_KEY, UtcT>();
            invocationStack.push(currentCtxt);
        }
        UtcT requestEndTime = currentCtxt.get((java.lang.Object)INVOCATION_KEY.REQUEST_END_TIME);
        UtcT replyEndTime = currentCtxt.get((java.lang.Object)INVOCATION_KEY.REPLY_END_TIME);
        if (!this.disableClientOrbPolicies) {
            if (requestEndTime == null) {
                requestEndTime = this.getRequestEndTime();
                long requestTimeout = this.getRelativeRequestTimeout();
                if ((requestTimeout > 0L || requestEndTime != null) && Time.hasPassed(requestEndTime = Time.earliest(Time.corbaFuture(requestTimeout), requestEndTime))) {
                    Delegate.clearInvocationContext();
                    throw new TIMEOUT("Request End Time exceeded prior to invocation", 2, CompletionStatus.COMPLETED_NO);
                }
                currentCtxt.put(INVOCATION_KEY.REQUEST_END_TIME, requestEndTime);
            } else if (Time.hasPassed(requestEndTime)) {
                Delegate.clearInvocationContext();
                throw new TIMEOUT("Request End Time exceeded", 2, CompletionStatus.COMPLETED_NO);
            }
            if (replyEndTime == null) {
                replyEndTime = this.getReplyEndTime();
                long roundtripTimeout = this.getRelativeRoundtripTimeout();
                if ((roundtripTimeout > 0L || replyEndTime != null) && Time.hasPassed(replyEndTime = Time.earliest(Time.corbaFuture(roundtripTimeout), replyEndTime))) {
                    Delegate.clearInvocationContext();
                    throw new TIMEOUT("Reply End Time exceeded prior to invocation", 3, CompletionStatus.COMPLETED_NO);
                }
                currentCtxt.put(INVOCATION_KEY.REPLY_END_TIME, replyEndTime);
            } else if (Time.hasPassed(replyEndTime)) {
                Delegate.clearInvocationContext();
                throw new TIMEOUT("Reply End Time exceeded", 3, CompletionStatus.COMPLETED_NO);
            }
        }
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            if (this.connections[this.currentConnection.ordinal()] != null && this.connections[this.currentConnection.ordinal()].isClosed()) {
                this.release(self);
            }
            this.bind();
            ParsedIOR ior = this.getParsedIOR();
            Profile profile = ior.getEffectiveProfile();
            byte[] objectKey = profile.get_object_key();
            int giopMinor = profile.version().minor;
            if (profile instanceof MIOPProfile) {
                if (responseExpected) {
                    IIOPProfile ip = ((MIOPProfile)profile).getGroupIIOPProfile();
                    if (ip == null) {
                        throw new INV_OBJREF("No Group IIOP Profile so unable to send a two-way request.");
                    }
                    objectKey = ip.get_object_key();
                    this.currentConnection = TransportType.IIOP;
                } else {
                    this.currentConnection = TransportType.MIOP;
                }
                giopMinor = this.defaultGiopMinor;
            } else {
                this.currentConnection = TransportType.IIOP;
            }
            RequestOutputStream out = new RequestOutputStream(this.orb, this.connections[this.currentConnection.ordinal()], this.connections[this.currentConnection.ordinal()].getId(), operation, responseExpected, this.getSyncScope(), this.getRequestStartTime(), requestEndTime, replyEndTime, objectKey, giopMinor);
            if (!this.connections[this.currentConnection.ordinal()].isTCSNegotiated()) {
                this.connections[this.currentConnection.ordinal()].setCodeSet(ior);
            }
            out.setCodeSets(this.connections[this.currentConnection.ordinal()].getTCS(), this.connections[this.currentConnection.ordinal()].getTCSW());
            out.updateMutatorConnection(this.connections[this.currentConnection.ordinal()].getGIOPConnection());
            return out;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void servant_postinvoke(Object self, ServantObject servant) {
        try {
            if (this.orb.hasRequestInterceptors()) {
                ServerRequestInfoImpl sinfo = ((ServantObjectImpl)servant).getServerRequestInfo();
                DefaultClientInterceptorHandler interceptors = ((ServantObjectImpl)servant).getClientInterceptorHandler();
                if (sinfo != null && interceptors != null) {
                    Collection<ServiceContext> ctx = sinfo.getReplyServiceContexts();
                    interceptors.getInfo().setReplyServiceContexts(ctx.toArray(new ServiceContext[ctx.size()]));
                    this.orb.getInterceptorManager().removeLocalPICurrent();
                    try {
                        if (sinfo.reply_status() == 0) {
                            interceptors.handle_receive_reply(null);
                        } else if (sinfo.reply_status() == 1) {
                            interceptors.handle_receive_exception(SystemExceptionHelper.read(sinfo.sending_exception().create_input_stream()));
                        } else if (sinfo.reply_status() == 3) {
                            try {
                                interceptors.handle_location_forward(null, sinfo.forward_reference());
                            }
                            catch (BAD_INV_ORDER bio) {
                                interceptors.handle_receive_other(sinfo.reply_status());
                            }
                        } else if (sinfo.reply_status() == 2) {
                            interceptors.handle_receive_other(sinfo.reply_status());
                        }
                    }
                    catch (ForwardRequest fwd) {
                        throw new RuntimeException(fwd);
                    }
                    catch (RemarshalException re) {
                        // empty catch block
                    }
                }
            }
            if (this.poa != null && this.poa.isUseServantManager() && !this.poa.isRetain() && this.cookie != null && this.invokedOperation != null) {
                try {
                    byte[] oid = POAUtil.extractOID(this.getParsedIOR().get_object_key());
                    ServantLocator sl = (ServantLocator)this.poa.get_servant_manager();
                    sl.postinvoke(oid, this.poa, this.invokedOperation, this.cookie.value, (Servant)servant.servant);
                    this.cookie = null;
                    this.invokedOperation = null;
                }
                catch (Throwable e) {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn(e.getMessage());
                    }
                }
            }
        }
        finally {
            if (this.poa != null) {
                this.poa.removeLocalRequest();
            }
            this.orb.getPOACurrent()._removeContext(Thread.currentThread());
            if (this.orb.getInterceptorManager() != null) {
                this.orb.getInterceptorManager().removeLocalPICurrent();
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public ServantObject servant_preinvoke(Object self, String operation, Class expectedType) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            return this.getBaseIOR().getIORString();
        }
    }

    @Override
    public String toString(Object self) {
        return this.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String typeId() {
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            return this.getBaseIOR().getIOR().type_id;
        }
    }

    @Override
    public Object set_policy_override(Object self, Policy[] policies, SetOverrideType set_add) {
        return this.set_policy_overrides(self, policies, set_add);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object set_policy_overrides(Object self, Policy[] policies, SetOverrideType set_add) {
        if (this.disableClientOrbPolicies) {
            throw new BAD_PARAM("policy override is disabled per configuration");
        }
        Object result = this.duplicate(self);
        Delegate delResult = (Delegate)((ObjectImpl)result)._get_delegate();
        Map<Integer, Policy> map = this.policy_overrides;
        synchronized (map) {
            if (set_add == SetOverrideType.ADD_OVERRIDE) {
                delResult.policy_overrides.putAll(this.policy_overrides);
            }
            for (int i = 0; i < policies.length; ++i) {
                delResult.policy_overrides.put(policies[i].policy_type(), policies[i]);
            }
        }
        return result;
    }

    @Override
    public String get_codebase(Object self) {
        return this.getParsedIOR().getCodebaseComponent();
    }

    private void checkORB() {
        this.orb.work_pending();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validate_connection(Object self, PolicyListHolder inconsistent_policies) {
        if (this.non_existent(self)) {
            inconsistent_policies.value = new Policy[0];
            return false;
        }
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            try {
                this.bind();
            }
            catch (INV_POLICY e) {
                inconsistent_policies.value = new Policy[0];
                return false;
            }
        }
        return true;
    }

    private static enum SyncScope {
        NONE(0),
        TRANSPORT(1),
        SERVER(2),
        TARGET(3);

        private short value;

        public static SyncScope getSyncScope(String ss) throws ConfigurationException {
            try {
                return SyncScope.valueOf(ss.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new ConfigurationException("Invalid type for SyncScope", e);
            }
        }

        public short getType() {
            return this.value;
        }

        private SyncScope(short value) {
            this.value = value;
        }
    }

    public static enum INVOCATION_KEY {
        REQUEST_END_TIME,
        REPLY_END_TIME,
        INTERCEPTOR_CALL,
        SERVANT_PREINVOKE,
        CLEAR_ALLOWED,
        CORBANAME_RESET,
        FORWARD_RESET;

    }

    private static enum TransportType {
        IIOP,
        MIOP;

    }
}

