/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;

public class ToolTipButton
extends JPanel {
    private static final long serialVersionUID = 6L;
    public static final Color DEFAULT_BACKGROUND = new Color(255, 255, 220);
    private Color borderColor = Color.BLACK;
    private Color toolTipBackground;
    private Icon image;
    private Icon imageMouseOver;
    private int toolTipWrapWidth = 300;
    private JLabel imageComponent;
    private Insets margin;
    private int borderThickness = 2;
    private String text;
    private ToolTipButtonTimer timer;
    private JPopupMenu popup;
    private Rectangle2D popupBounds;
    private JComponent extraComponent;
    private ToolTipButtonAnchor extraComponentAnchor;

    public ToolTipButton(Icon image) {
        this(image, null, null);
    }

    public ToolTipButton(Icon image, String tooltip) {
        this(image, null, tooltip);
    }

    public ToolTipButton(Icon image, Icon imageMouseOver, String tooltip) {
        this(image, imageMouseOver, tooltip, null, null);
    }

    public ToolTipButton(Icon image, Icon imageMouseOver, String tooltip, JComponent extraComponent, ToolTipButtonAnchor extraComponentAnchor) {
        this.extraComponent = extraComponent;
        this.extraComponentAnchor = extraComponentAnchor;
        this.setTooltipMargin(null);
        this.setLayout(new GridBagLayout());
        this.imageComponent = new JLabel(image);
        this.add(this.imageComponent);
        this.image = image;
        this.imageMouseOver = imageMouseOver;
        this.toolTipBackground = DEFAULT_BACKGROUND;
        this.setText(tooltip);
        this.setOpaque(false);
        this.timer = new ToolTipButtonTimer();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ToolTipButton.this.timer.startNextAction(NextAction.SHOW);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                ToolTipButton.this.timer.stop();
                ToolTipButton.this.showTooltip();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ToolTipButton.this.timer.startNextAction(NextAction.DISPOSE);
            }
        });
        if (imageMouseOver != null) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    ToolTipButton.this.imageComponent.setIcon(ToolTipButton.this.imageMouseOver);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    ToolTipButton.this.imageComponent.setIcon(ToolTipButton.this.image);
                }
            });
        }
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        this.text = text;
    }

    @Override
    public void setToolTipText(String text) {
        this.setText(text);
    }

    public int getDisposeTime() {
        return this.timer.getDisposeTime();
    }

    public void setDisposeTime(int time) {
        this.timer.setDisposeTime(time);
    }

    public int getShowTime() {
        return this.timer.getShowTime();
    }

    public void setShowTime(int time) {
        this.timer.setShowTime(time);
    }

    public Insets getTooltipMargin() {
        return this.margin;
    }

    public void setTooltipMargin(Insets margin) {
        if (margin == null) {
            margin = new Insets(10, 10, 10, 10);
        }
        margin.bottom = Math.max(margin.bottom, 0);
        margin.top = Math.max(margin.top, 0);
        margin.right = Math.max(margin.right, 0);
        margin.left = Math.max(margin.left, 0);
        this.margin = margin;
    }

    public void setTooltipBorderThickness(int thickness) {
        this.borderThickness = Math.max(0, thickness);
    }

    public int getTooltipBorderThickness() {
        return this.borderThickness;
    }

    public Color getTooltipBorderColor() {
        return this.borderColor;
    }

    public void setTooltipBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public Color getToolTipBackground() {
        return this.toolTipBackground;
    }

    public void setToolTipBackground(Color toolTipBackground) {
        this.toolTipBackground = toolTipBackground;
    }

    public int getToolTipWrapWidth() {
        return this.toolTipWrapWidth;
    }

    public void setToolTipWrapWidth(int toolTipWrapWidth) {
        this.toolTipWrapWidth = Math.max(200, toolTipWrapWidth);
    }

    private void tryDisposeTooltip() {
        if (this.popup != null) {
            if (this.popup.isShowing()) {
                Point cursorLocation = MouseInfo.getPointerInfo().getLocation();
                if (!this.popupBounds.contains(cursorLocation)) {
                    this.disposeTooltip();
                }
            } else {
                this.disposeTooltip();
            }
        }
    }

    public void disposeTooltip() {
        if (this.popup != null) {
            this.timer.stop();
            this.popup.setVisible(false);
            this.popup = null;
        }
    }

    private void showTooltip() {
        Wrap tooltipLabel = new Wrap(this.toolTipWrapWidth);
        tooltipLabel.setForeground(this.getForeground());
        tooltipLabel.setFont(this.getFont());
        tooltipLabel.setText(this.text);
        JPanel panel = new JPanel();
        panel.setBackground(this.toolTipBackground);
        panel.setLayout(new BorderLayout());
        panel.add((Component)tooltipLabel, "Center");
        if (this.extraComponent != null && this.extraComponentAnchor != null) {
            if (this.extraComponentAnchor.equals((Object)ToolTipButtonAnchor.SOUTH)) {
                panel.add((Component)this.extraComponent, "South");
            } else if (this.extraComponentAnchor.equals((Object)ToolTipButtonAnchor.NORTH)) {
                panel.add((Component)this.extraComponent, "North");
            } else if (this.extraComponentAnchor.equals((Object)ToolTipButtonAnchor.EAST)) {
                panel.add((Component)this.extraComponent, "East");
            } else if (this.extraComponentAnchor.equals((Object)ToolTipButtonAnchor.WEST)) {
                panel.add((Component)this.extraComponent, "West");
            }
        }
        Border out = BorderFactory.createLineBorder(this.borderColor, this.borderThickness);
        Border in = BorderFactory.createEmptyBorder(this.margin.top, this.margin.left, this.margin.bottom, this.margin.right);
        CompoundBorder border = BorderFactory.createCompoundBorder(out, in);
        panel.setBorder(border);
        this.popup = new JPopupMenu();
        this.popup.setBorder(BorderFactory.createEmptyBorder());
        this.popup.add(panel);
        this.popup.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                ToolTipButton.this.tryDisposeTooltip();
            }
        });
        this.popup.pack();
        this.popup.show(this, 0, this.getHeight());
        Point point = this.popup.getLocationOnScreen();
        Dimension dim = this.popup.getSize();
        this.popupBounds = new Rectangle2D.Double(point.getX(), point.getY(), dim.getWidth(), dim.getHeight());
    }

    public static enum ToolTipButtonAnchor {
        SOUTH,
        NORTH,
        EAST,
        WEST;

    }

    private class ToolTipButtonTimer
    extends Timer
    implements ActionListener {
        private int showTime;
        private int disposeTime;
        private NextAction nextAction;

        public ToolTipButtonTimer() {
            super(0, null);
            this.showTime = 800;
            this.disposeTime = 200;
            this.nextAction = NextAction.SHOW;
            this.addActionListener(this);
            this.setRepeats(false);
        }

        public void setShowTime(int showTime) {
            this.showTime = showTime;
        }

        public int getShowTime() {
            return this.showTime;
        }

        public void setDisposeTime(int disposeTime) {
            this.disposeTime = disposeTime;
        }

        public int getDisposeTime() {
            return this.disposeTime;
        }

        public void startNextAction(NextAction nextAction) {
            this.stop();
            this.nextAction = nextAction;
            if (nextAction.equals((Object)NextAction.SHOW)) {
                this.setInitialDelay(this.getShowTime());
            } else if (nextAction.equals((Object)NextAction.DISPOSE)) {
                this.setInitialDelay(this.getDisposeTime());
            }
            this.start();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.nextAction.equals((Object)NextAction.SHOW)) {
                ToolTipButton.this.showTooltip();
            } else if (this.nextAction.equals((Object)NextAction.DISPOSE)) {
                ToolTipButton.this.tryDisposeTooltip();
            }
        }
    }

    private static enum NextAction {
        SHOW,
        DISPOSE;

    }

    private static class Wrap
    extends JTextPane {
        private static final long serialVersionUID = 2849635511260534304L;
        private View view;
        private int width;

        public Wrap(int width) {
            this.width = width;
            this.setText("");
            this.setContentType("text/html");
            this.setOpaque(false);
            this.setEditable(false);
            this.setHighlighter(null);
            this.setBorder(null);
            this.setBackground(new Color(0, 0, 0, 0));
        }

        private void setHTMLFont(Font font) {
            MutableAttributeSet attrs = this.getInputAttributes();
            StyleConstants.setFontFamily(attrs, font.getFamily());
            StyleConstants.setFontSize(attrs, font.getSize());
            StyleConstants.setForeground(attrs, this.getForeground());
            StyledDocument doc = this.getStyledDocument();
            doc.setCharacterAttributes(0, doc.getLength() + 1, attrs, false);
        }

        @Override
        public void setText(String t) {
            super.setText(t);
            this.view = BasicHTML.createHTMLView(this, t);
            this.setHTMLFont(this.getFont());
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.isPreferredSizeSet()) {
                return super.getPreferredSize();
            }
            this.view.setSize(this.width, 0.0f);
            Insets insets = this.getInsets();
            Insets margin = this.getMargin();
            float w = this.view.getPreferredSpan(0) + (float)insets.left + (float)insets.right + (float)margin.left + (float)margin.right;
            float h = this.view.getPreferredSpan(1) + (float)insets.bottom + (float)insets.top + (float)margin.bottom + (float)margin.top;
            return new Dimension((int)Math.ceil(w), (int)Math.ceil(h));
        }
    }
}

