/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.japura.gui.CheckList;
import org.japura.gui.model.ListCheckModel;

public class CheckListTransferable
implements Transferable {
    public static final DataFlavor CHECKEDS_LIST_FLAVOR = new DataFlavor(ArrayList.class, "CHECKEDS_LIST_FLAVOR");
    private ListCheckModel model;
    private Comparator<Object> comparator;
    private String separator;

    public static boolean isAvailableToTransfer(CheckList list) {
        ListCheckModel model = list.getModel();
        if (model.getChecksCount() == 0) {
            return false;
        }
        int index = list.getSelectedIndex();
        if (index == -1) {
            return false;
        }
        if (index >= model.getSize()) {
            return false;
        }
        Object selectedElement = model.getElementAt(index);
        return model.isChecked(selectedElement);
    }

    public CheckListTransferable(CheckList list, String separator, Comparator<Object> comparator) {
        this.model = list.getModel();
        this.separator = separator;
        this.comparator = comparator;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{CHECKEDS_LIST_FLAVOR, DataFlavor.stringFlavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(CHECKEDS_LIST_FLAVOR) || flavor.equals(DataFlavor.stringFlavor);
    }

    private List<Object> getCheckeds() {
        List<Object> objs = this.model.getCheckeds();
        if (this.comparator != null) {
            Collections.sort(objs, this.comparator);
        }
        return objs;
    }

    public static String toString(ListCheckModel model, String separator) {
        StringBuilder sb = new StringBuilder();
        List<Object> objs = model.getCheckeds();
        for (int i = 0; i < objs.size(); ++i) {
            Object obj = objs.get(i);
            sb.append(obj.toString());
            if (separator == null || i >= objs.size() - 1) continue;
            sb.append(separator);
        }
        return sb.toString().trim();
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(DataFlavor.stringFlavor)) {
            return CheckListTransferable.toString(this.model, this.separator);
        }
        if (flavor.equals(CHECKEDS_LIST_FLAVOR)) {
            return new ArrayList<Object>(this.getCheckeds());
        }
        return null;
    }
}

