/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.panel;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIResources;
import tecgraf.javautils.gui.SwingThreadDispatcher;
import tecgraf.javautils.gui.panel.FilteredView;

public class TextFieldFilterPanel
extends JPanel {
    private static final long TEXTFIELD_COUNT_DOWN = 1L;
    private JTextField filterTextField;
    private JButton clearFieldButton;
    private FilteredView fView;
    private KeyEventDispatcher filterInputDispatcher;

    public TextFieldFilterPanel(FilteredView fView) {
        this(fView, GUIResources.BUTTON_CLEAR_ICON);
    }

    public TextFieldFilterPanel(FilteredView fView, ImageIcon clearButtonIcon) {
        super(new GridBagLayout());
        this.fView = fView;
        this.filterTextField = new JTextField(10);
        this.createfilterInputDipatcher(this.filterTextField);
        this.filterTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            public void update() {
                TextFieldFilterPanel.this.clearFieldButton.setEnabled(TextFieldFilterPanel.this.filterTextField.getText().length() > 0);
            }
        });
        this.filterTextField.setToolTipText(LNG.get("TreeFilterPanel.filterTextField.tooltip"));
        this.filterTextField.addKeyListener(new KeyAdapter(){
            Timer timer = new Timer();

            @Override
            public void keyReleased(KeyEvent e) {
                this.timer.cancel();
                this.timer = new Timer();
                this.timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        SwingThreadDispatcher.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                TextFieldFilterPanel.this.filter();
                            }
                        });
                    }
                }, 1000L);
            }
        });
        this.clearFieldButton = new JButton(clearButtonIcon);
        this.clearFieldButton.setMargin(new Insets(0, 0, 0, 0));
        this.clearFieldButton.setEnabled(false);
        this.clearFieldButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextFieldFilterPanel.this.filterTextField.setText("");
                TextFieldFilterPanel.this.clearFieldButton.setEnabled(false);
                TextFieldFilterPanel.this.filterTextField.requestFocusInWindow();
                TextFieldFilterPanel.this.filter();
            }
        });
        JPanel entryPanel = new JPanel(new GridBagLayout());
        Insets margins = new Insets(5, 5, 5, 5);
        TitledBorder border = BorderFactory.createTitledBorder(LNG.get("TreeFilterPanel.border.title"));
        entryPanel.setBorder(border);
        entryPanel.add((Component)this.filterTextField, new GBC(1, 0).insets(margins).west().weightx(1.0).horizontal());
        entryPanel.add((Component)this.clearFieldButton, new GBC(2, 0).insets(margins).west());
        this.add((Component)entryPanel, new GBC(0, 0).both());
    }

    private void filter() {
        this.fView.filter(this.filterTextField.getText());
    }

    private void addFilterInputDispatcher() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.filterInputDispatcher);
    }

    private void removeFilterInputDispatcher() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.filterInputDispatcher);
    }

    private void createfilterInputDipatcher(final Component cmp) {
        this.filterInputDispatcher = new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent e) {
                boolean discardEvent = false;
                if (e.getID() == 400 && cmp.isFocusOwner() && !this.isValid(e.getKeyChar())) {
                    discardEvent = true;
                }
                return discardEvent;
            }

            private boolean isValid(char keyChar) {
                if (Character.isLetterOrDigit(keyChar)) {
                    return true;
                }
                return "?*$._".indexOf(keyChar) >= 0;
            }
        };
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible == this.isVisible()) {
            return;
        }
        super.setVisible(visible);
        if (visible) {
            this.filterTextField.requestFocusInWindow();
            this.addFilterInputDispatcher();
        } else {
            this.reset();
            this.removeFilterInputDispatcher();
        }
    }

    public void reset() {
        this.filterTextField.setText(null);
    }
}

