/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.print;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.swing.table.DefaultTableModel;
import tecgraf.javautils.gui.print.DefaultPrintableTable;

public class DefaultPrintableTableSample {
    public static void main(String[] args) throws Exception {
        int numRows = 125;
        int numColumns = 6;
        Object[] names = new Object[]{"Navio", "Origem", "ETD", "Destino", "ETA", "Volume\n(1000 m3)"};
        Object[][] data = new Object[numRows][numColumns];
        Object[] ships = new Object[]{"Norma", "Nilza", "Clara", "Pero", "Restinga", "TBN", "TBN", "TBN", "TBN"};
        Object[] points = new Object[]{"Ilha D'\u00e1gua", "Angra dos Reis", "Mucuripe", "Cabedelo", "Santos", "N/A"};
        double totalVolume = 0.0;
        for (int row = 0; row < numRows - 1; ++row) {
            data[row][0] = ships[(int)Math.floor(Math.random() * (double)ships.length)];
            data[row][1] = points[(int)Math.floor(Math.random() * (double)points.length)];
            data[row][3] = points[(int)Math.floor(Math.random() * (double)points.length)];
            if (data[row][1] == data[row][3]) {
                data[row][3] = points[points.length - 1];
            }
            int days = (int)Math.floor((Math.random() - 0.5) * 30.0);
            GregorianCalendar cal = new GregorianCalendar();
            ((Calendar)cal).add(5, days);
            data[row][2] = cal.getTime();
            days = (int)Math.floor(Math.random() * 30.0);
            ((Calendar)cal).add(5, days);
            data[row][4] = cal.getTime();
            double volume = Math.random() * 1000.0;
            data[row][5] = volume;
            totalVolume += volume;
        }
        data[numRows - 1][0] = "Total";
        data[numRows - 1][numColumns - 1] = totalVolume;
        DefaultTableModel m1 = new DefaultTableModel(data, names);
        final DefaultPrintableTable t1 = new DefaultPrintableTable(m1);
        t1.setTitle("Mapa de Navega\u00e7\u00e3o de Cabotagem\nViagens Programadas", new Font("Serif", 1, 14));
        t1.setTableHeader("Para aloca\u00e7\u00e3o de petr\u00f3leos.\nN\u00e3o considera cabotagem de derivados.", new Font("SansSerif", 2, 8));
        t1.setPosText("Terminal N/A: indefinido.", new Font("SansSerif", 2, 8));
        t1.setColumnNameFont(0, numColumns - 1, new Font("SansSerif", 1, 9));
        t1.setCellFont(0, numRows - 1, 0, 0, new Font("SansSerif", 1, 65));
        t1.setCellFont(numRows - 1, numRows - 1, numColumns - 1, numColumns - 1, new Font("SansSerif", 1, 9));
        t1.setDefaultFont(new Font("SansSerif", 0, 9));
        t1.setDecimalFormat(new DecimalFormat("#.00"));
        t1.setLineWidth(0.0f);
        t1.setInsets(1.0f, 1.0f);
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintable(new Printable(){
            int lastPage = 0;
            boolean finished = false;

            @Override
            public int print(Graphics g, PageFormat format, int page) {
                if (this.finished && page > this.lastPage) {
                    return 1;
                }
                this.lastPage = page;
                format = (PageFormat)format.clone();
                Graphics2D g2d = (Graphics2D)g;
                g2d.setPaint(Color.black);
                this.finished = t1.print(g2d, format, page);
                Rectangle2D.Double bbox = new Rectangle2D.Double(format.getImageableX(), format.getImageableY(), format.getImageableWidth(), format.getImageableHeight());
                g2d.setStroke(new BasicStroke(0.0f, 0, 2));
                g2d.setPaint(Color.red);
                g2d.draw(bbox);
                return 0;
            }
        });
        job.printDialog();
        job.print();
        System.out.println("Digite <enter> para terminar.");
        System.in.read();
        System.exit(0);
    }
}

