/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.core;

import java.util.ArrayList;
import java.util.List;
import tecgraf.openbus.Connection;
import tecgraf.openbus.LoginObserver;
import tecgraf.openbus.LoginSubscription;
import tecgraf.openbus.core.LoginRegistryImpl;
import tecgraf.openbus.core.v2_1.services.ServiceFailure;
import tecgraf.openbus.core.v2_1.services.access_control.InvalidLogins;
import tecgraf.openbus.core.v2_1.services.access_control.LoginInfo;

class LoginSubscriptionImpl
implements LoginSubscription,
LoginObserver {
    private final LoginRegistryImpl registry;
    private final LoginObserver observer;
    private final List<String> logins = new ArrayList<String>();
    private final Object lock = new Object();

    protected LoginSubscriptionImpl(LoginObserver callback, LoginRegistryImpl registry) {
        this.observer = callback;
        this.registry = registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean watchLogin(String loginId) throws ServiceFailure {
        boolean ret = this.registry.watchLogin(loginId);
        if (ret) {
            Object object = this.lock;
            synchronized (object) {
                this.logins.add(loginId);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forgetLogin(String loginId) throws ServiceFailure {
        this.registry.forgetLogin(loginId);
        Object object = this.lock;
        synchronized (object) {
            this.logins.remove(loginId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void watchLogins(List<String> loginIds) throws InvalidLogins, ServiceFailure {
        this.registry.watchLogins(loginIds);
        Object object = this.lock;
        synchronized (object) {
            this.logins.addAll(loginIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forgetLogins(List<String> loginIds) throws ServiceFailure {
        this.registry.forgetLogins(loginIds);
        Object object = this.lock;
        synchronized (object) {
            this.logins.removeAll(loginIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<LoginInfo> watchedLogins() {
        List<LoginInfo> watched = this.registry.getWatchedLogins();
        ArrayList<LoginInfo> ret = new ArrayList<LoginInfo>();
        Object object = this.lock;
        synchronized (object) {
            for (LoginInfo info : watched) {
                if (!this.logins.contains(info.id)) continue;
                ret.add(info);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove() {
        Object object = this.lock;
        synchronized (object) {
            this.registry.remove(this);
            this.logins.clear();
        }
    }

    @Override
    public Connection connection() {
        return this.registry.connection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LoginObserver observer() {
        Object object = this.lock;
        synchronized (object) {
            return this.observer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void entityLogout(LoginInfo login) {
        LoginObserver observer;
        boolean doit = false;
        Object object = this.lock;
        synchronized (object) {
            observer = this.observer;
            if (this.logins.contains(login.id)) {
                doit = true;
            }
        }
        if (doit) {
            observer.entityLogout(login);
        }
    }

    @Override
    public void nonExistentLogins(String[] logins) {
        this.observer().nonExistentLogins(logins);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> loginsCopy() {
        Object object = this.lock;
        synchronized (object) {
            return new ArrayList<String>(this.logins);
        }
    }
}

