#!/bin/bash

PROJECTS_DIR_PATH=$1

# TODO Usar com H M S
DATE=$(date +"%Y%m%d-%H%M%S")
DATE=$(date +"%Y%m%d")
PROJECTS_DATA_COPY=$HOME/temp/csgrid-projects-data-$HOSTNAME-$DATE

if [ ! -e $PROJECTS_DATA_COPY ]; then
	mkdir $PROJECTS_DATA_COPY
fi

for u in $(ls $PROJECTS_DIR_PATH); do
	echo "Copy $u data"
	USER_PROJECTS_DATA_SOURCE="$PROJECTS_DIR_PATH/$u"

	# Create user directory in project data copy
	USER_PROJECT_DATA_COPY="$PROJECTS_DATA_COPY/$u"
	mkdir $USER_PROJECT_DATA_COPY

	for ppath in $(ls -d $USER_PROJECTS_DATA_SOURCE/*); do

		p=${ppath##$USER_PROJECTS_DATA_SOURCE}
		p=${p##/}

		if [ -d $ppath ]; then
			PROJECT_USER_COPY="$USER_PROJECT_DATA_COPY/$p"
			echo "Creating copy directory: $PROJECT_USER_COPY"
			mkdir $PROJECT_USER_COPY

			echo "Copying $ppath/.cmds directory ..."
			cp $ppath/..cmds* $PROJECT_USER_COPY/

			CMDS_PROJECT_COPY="$PROJECT_USER_COPY/.cmds"
			mkdir $CMDS_PROJECT_COPY

			CMD_PROJECT_SOURCE="$ppath/.cmds"
			for cmdpath in $(ls -d $CMD_PROJECT_SOURCE/*); do
				cmdid=${cmdpath##$CMD_PROJECT_SOURCE}
				cmdid=${cmdid##/}
				#echo $cmdpath			
				#echo $cmdid
				
				CMD_ID_PROJECT_COPY="$CMDS_PROJECT_COPY/$cmdid"
				echo $CMD_ID_PROJECT_COPY

				mkdir $CMD_ID_PROJECT_COPY 
				cp $CMD_PROJECT_SOURCE/.${cmdid}* $CMDS_PROJECT_COPY/
				cp $cmdpath/cmd.* $cmdpath/.cmd* $cmdpath/script.ksh $cmdpath/.script* $CMD_ID_PROJECT_COPY/
			done
			
		else		
			# Create .csbase_project_info files
			echo "Copying file $p ..."
#			echo "cp -f $ppath $USER_PROJECT_DATA_COPY/"
			cp -f $ppath $USER_PROJECT_DATA_COPY/
			
		fi
		echo " "
	done
done