package br.pucrio.tecgraf.soma.serviceapi.persistence.specification.impl;

import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;

import com.github.tennaito.rsql.jpa.JpaPredicateVisitor;

import br.pucrio.tecgraf.soma.serviceapi.persistence.specification.JPASpecification;

import cz.jirutka.rsql.parser.ast.Node;

public class RSQLSpecification<T> extends JPASpecification<T> {

  private final Node parsedQuery;
  private final JpaPredicateVisitor<T> visitor;
  private final EntityManager entityManager;

  RSQLSpecification(Node parsedQuery, JpaPredicateVisitor<T> visitor, EntityManager entityManager) {
    this.parsedQuery = parsedQuery;
    this.visitor = visitor;
    this.entityManager = entityManager;
  }

  public boolean isSatisfiedBy(T element) {
    throw new UnsupportedOperationException(
        "Missing implementation of isSatisfiedBy() on RSQLSpecification");
  }

  @Override
  public Predicate toPredicate(Root<T> root, CriteriaBuilder cb) {
    return parsedQuery.accept(visitor.defineRoot(root), entityManager);
  }

}
