/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.menu;

import br.pucrio.tecgraf.soma.job.SomaJobHistoryConsumer;
import java.io.File;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.lang3.StringUtils;

public class Version {
    private static String version;

    public String getVersion() {
        if (StringUtils.isBlank((CharSequence)version)) {
            Class<SomaJobHistoryConsumer> clazz = SomaJobHistoryConsumer.class;
            String className = clazz.getSimpleName() + ".class";
            String classPath = clazz.getResource(className).toString();
            if (!classPath.startsWith("jar")) {
                String relativePath = clazz.getName().replace('.', File.separatorChar) + ".class";
                String classFolder = classPath.substring(0, classPath.length() - relativePath.length() - 1);
                String manifestPath = classFolder + "/META-INF/MANIFEST.MF";
                version = this.readVersionFrom(manifestPath);
            } else {
                String manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
                version = this.readVersionFrom(manifestPath);
            }
        }
        return version;
    }

    private String readVersionFrom(String manifestPath) {
        Manifest manifest = null;
        try {
            manifest = new Manifest(new URL(manifestPath).openStream());
            Attributes attrs = manifest.getMainAttributes();
            String implementationVersion = attrs.getValue("Implementation-Version");
            String implementationBuild = attrs.getValue("Implementation-Build");
            String version = implementationVersion;
            if (StringUtils.isNotBlank((CharSequence)implementationBuild)) {
                version = StringUtils.join((Object[])new String[]{implementationVersion, implementationBuild}, (char)'.');
            }
            return version;
        }
        catch (Exception exception) {
            return "";
        }
    }
}

