/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job;

import br.pucrio.tecgraf.soma.job.infrastructure.persistence.message.JobHistoryEventReader;
import br.pucrio.tecgraf.soma.job.menu.Menu;
import br.pucrio.tecgraf.soma.serviceapi.ServiceContext;
import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@ComponentScan
@EnableTransactionManagement
public class SomaJobHistoryConsumer
implements ApplicationRunner {
    private final Logger logger = LoggerFactory.getLogger(SomaJobHistoryConsumer.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private ServiceContext serviceContext;
    private static SomaJobHistoryConsumer singleton;

    @Override
    public void run(ApplicationArguments args) {
        String[] argsFromCommandLine = args.getSourceArgs();
        String server = argsFromCommandLine[0];
        String registry = argsFromCommandLine[1];
        String topic = argsFromCommandLine[2];
        String group = argsFromCommandLine[3];
        singleton = new SomaJobHistoryConsumer();
        JobHistoryEventReader receiver = this.applicationContext.getBean(JobHistoryEventReader.class);
        try {
            receiver.run(server, registry, topic, group);
        }
        catch (IOException | InterruptedException e) {
            this.logger.error("Error trying to read data from the kafka message queue.", e);
        }
    }

    public static SomaJobHistoryConsumer getInstance() {
        return singleton;
    }

    @Bean
    public ServiceContext serviceContext(@Value(value="${hibernate-config}") String hibernateConfiguration) {
        Properties properties = null;
        if (hibernateConfiguration != null) {
            properties = new Properties();
            try {
                properties.load(new StringReader(hibernateConfiguration.replaceAll(",", "\n")));
            }
            catch (IOException e) {
                this.logger.error("Error reading Hibernate configuration from arguments.", e);
            }
        }
        return new ServiceContext(properties, "hibernate.cfg.xml", "br.pucrio.tecgraf.soma.job.domain.model");
    }

    @Bean
    public EntityManagerFactory entityManagerFactory() {
        return this.serviceContext.getEntityManagerFactory();
    }

    @Bean
    public PlatformTransactionManager transactionManager(EntityManagerFactory emf) {
        JpaTransactionManager transactionManager = new JpaTransactionManager();
        transactionManager.setEntityManagerFactory(emf);
        return transactionManager;
    }

    public static void main(String[] args) {
        Menu menu = new Menu();
        if (menu.parser(args)) {
            String server = menu.getServer();
            String registry = menu.getRegistry();
            String topic = menu.getTopic();
            String group = menu.getGroup();
            String hibernateConfiguration = menu.getHibernateConfiguration();
            if (StringUtils.isNotBlank(hibernateConfiguration)) {
                System.setProperty("hibernate-config", hibernateConfiguration);
            }
            SpringApplication.run(SomaJobHistoryConsumer.class, server, registry, topic, group);
        }
    }
}

