/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.serviceapi;

import java.util.Properties;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.EntityManagerFactory;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class ServiceContext {
    private EntityManagerFactory entityManagerFactory;
    private String hibernateConfigFilePath;
    private String[] hibernateAnnotatedPackages;
    private Properties hibernateProperties;

    public ServiceContext(Properties hibernateProperties, String hibernateConfigFilePath, String ... hibernateAnnotatedPackages) {
        this.hibernateProperties = hibernateProperties;
        this.hibernateConfigFilePath = hibernateConfigFilePath;
        this.hibernateAnnotatedPackages = hibernateAnnotatedPackages;
        this.buildHibernateSessionFactory();
    }

    protected void buildHibernateSessionFactory() {
        Configuration configuration = new Configuration();
        for (int i = 0; i < this.hibernateAnnotatedPackages.length; ++i) {
            Reflections reflections = new Reflections(this.hibernateAnnotatedPackages[i], new Scanner[0]);
            Set<Class<?>> allEntites = reflections.getTypesAnnotatedWith(Entity.class);
            for (Class<?> c : allEntites) {
                configuration.addAnnotatedClass(c);
            }
        }
        configuration.configure(this.hibernateConfigFilePath);
        if (this.hibernateProperties != null) {
            configuration.addProperties(this.hibernateProperties);
        }
        StandardServiceRegistry serviceRegistry = new StandardServiceRegistryBuilder().applySettings(configuration.getProperties()).build();
        this.entityManagerFactory = configuration.buildSessionFactory(serviceRegistry);
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public void finalize() {
        if (this.entityManagerFactory != null && this.entityManagerFactory.isOpen()) {
            this.entityManagerFactory.close();
        }
    }
}

