/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.spi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CacheRetrieveMode;
import javax.persistence.CacheStoreMode;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.EntityNotFoundException;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.OptimisticLockException;
import javax.persistence.PersistenceContextType;
import javax.persistence.PersistenceException;
import javax.persistence.PessimisticLockScope;
import javax.persistence.StoredProcedureQuery;
import javax.persistence.SynchronizationType;
import javax.persistence.TransactionRequiredException;
import javax.persistence.Tuple;
import javax.persistence.TupleElement;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.CriteriaUpdate;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.hibernate.AssertionFailure;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.NonUniqueResultException;
import org.hibernate.ObjectDeletedException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.PessimisticLockException;
import org.hibernate.Query;
import org.hibernate.QueryException;
import org.hibernate.QueryTimeoutException;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.StaleObjectStateException;
import org.hibernate.StaleStateException;
import org.hibernate.TransactionException;
import org.hibernate.TransientObjectException;
import org.hibernate.TypeMismatchException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.dialect.lock.LockingStrategyException;
import org.hibernate.dialect.lock.OptimisticEntityLockException;
import org.hibernate.dialect.lock.PessimisticEntityLockException;
import org.hibernate.engine.ResultSetMappingDefinition;
import org.hibernate.engine.query.spi.HQLQueryPlan;
import org.hibernate.engine.query.spi.sql.NativeSQLQueryConstructorReturn;
import org.hibernate.engine.query.spi.sql.NativeSQLQueryReturn;
import org.hibernate.engine.query.spi.sql.NativeSQLQueryRootReturn;
import org.hibernate.engine.spi.NamedQueryDefinition;
import org.hibernate.engine.spi.NamedSQLQueryDefinition;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.jpa.HibernateEntityManagerFactory;
import org.hibernate.jpa.criteria.ValueHandlerFactory;
import org.hibernate.jpa.criteria.compile.CompilableCriteria;
import org.hibernate.jpa.criteria.compile.CriteriaCompiler;
import org.hibernate.jpa.criteria.expression.CompoundSelectionImpl;
import org.hibernate.jpa.internal.EntityManagerFactoryImpl;
import org.hibernate.jpa.internal.EntityManagerMessageLogger;
import org.hibernate.jpa.internal.HEMLogging;
import org.hibernate.jpa.internal.QueryImpl;
import org.hibernate.jpa.internal.StoredProcedureQueryImpl;
import org.hibernate.jpa.internal.TransactionImpl;
import org.hibernate.jpa.internal.util.CacheModeHelper;
import org.hibernate.jpa.internal.util.ConfigurationHelper;
import org.hibernate.jpa.internal.util.LockModeTypeHelper;
import org.hibernate.jpa.spi.HibernateEntityManagerImplementor;
import org.hibernate.procedure.ProcedureCallMemento;
import org.hibernate.procedure.UnknownSqlResultSetMappingException;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.resource.transaction.TransactionRequiredForJoinException;
import org.hibernate.transform.BasicTransformerAdapter;
import org.hibernate.type.Type;

public abstract class AbstractEntityManagerImpl
implements HibernateEntityManagerImplementor,
Serializable {
    private static final long serialVersionUID = 78818181L;
    private static final EntityManagerMessageLogger LOG = HEMLogging.messageLogger(AbstractEntityManagerImpl.class);
    private static final List<String> ENTITY_MANAGER_SPECIFIC_PROPERTIES = new ArrayList<String>();
    private EntityManagerFactoryImpl entityManagerFactory;
    protected transient TransactionImpl tx = new TransactionImpl(this);
    private SynchronizationType synchronizationType;
    private PersistenceUnitTransactionType transactionType;
    private Map<String, Object> properties;
    private LockOptions lockOptions;
    private CriteriaCompiler criteriaCompiler;

    protected AbstractEntityManagerImpl(EntityManagerFactoryImpl entityManagerFactory, PersistenceContextType type, SynchronizationType synchronizationType, PersistenceUnitTransactionType transactionType, Map properties) {
        this.entityManagerFactory = entityManagerFactory;
        this.synchronizationType = synchronizationType;
        this.transactionType = transactionType;
        this.lockOptions = new LockOptions();
        this.properties = new HashMap<String, Object>();
        for (String key : ENTITY_MANAGER_SPECIFIC_PROPERTIES) {
            if (entityManagerFactory.getProperties().containsKey(key)) {
                this.properties.put(key, entityManagerFactory.getProperties().get(key));
            }
            if (properties == null || !properties.containsKey(key)) continue;
            this.properties.put(key, properties.get(key));
        }
    }

    public PersistenceUnitTransactionType getTransactionType() {
        return this.transactionType;
    }

    public SynchronizationType getSynchronizationType() {
        return this.synchronizationType;
    }

    protected void postInit() {
        ((SessionImplementor)this.internalGetSession()).getTransactionCoordinator().pulse();
        this.setDefaultProperties();
        this.applyProperties();
    }

    private void applyProperties() {
        this.getSession().setFlushMode(ConfigurationHelper.getFlushMode(this.properties.get("org.hibernate.flushMode")));
        this.setLockOptions(this.properties, this.lockOptions);
        this.getSession().setCacheMode(CacheModeHelper.interpretCacheMode(this.currentCacheStoreMode(), this.currentCacheRetrieveMode()));
    }

    private javax.persistence.Query applyProperties(javax.persistence.Query query) {
        Object lockTimeout;
        Object queryTimeout;
        if (this.lockOptions.getLockMode() != LockMode.NONE) {
            query.setLockMode(this.getLockMode((Object)this.lockOptions.getLockMode()));
        }
        if ((queryTimeout = this.getProperties().get("javax.persistence.query.timeout")) != null) {
            query.setHint("javax.persistence.query.timeout", queryTimeout);
        }
        if ((lockTimeout = this.getProperties().get("javax.persistence.lock.timeout")) != null) {
            query.setHint("javax.persistence.lock.timeout", lockTimeout);
        }
        return query;
    }

    private CacheRetrieveMode currentCacheRetrieveMode() {
        return this.determineCacheRetrieveMode(this.properties);
    }

    private CacheRetrieveMode determineCacheRetrieveMode(Map<String, Object> settings) {
        return (CacheRetrieveMode)((Object)settings.get("javax.persistence.cache.retrieveMode"));
    }

    private CacheStoreMode currentCacheStoreMode() {
        return this.determineCacheStoreMode(this.properties);
    }

    private CacheStoreMode determineCacheStoreMode(Map<String, Object> settings) {
        return (CacheStoreMode)((Object)settings.get("javax.persistence.cache.storeMode"));
    }

    private void setLockOptions(Map<String, Object> props, LockOptions options) {
        Object lockScope = props.get("javax.persistence.lock.scope");
        if (lockScope instanceof String && PessimisticLockScope.valueOf((String)lockScope) == PessimisticLockScope.EXTENDED) {
            options.setScope(true);
        } else if (lockScope instanceof PessimisticLockScope) {
            boolean extended = PessimisticLockScope.EXTENDED.equals(lockScope);
            options.setScope(extended);
        } else if (lockScope != null) {
            throw new PersistenceException("Unable to parse javax.persistence.lock.scope: " + lockScope);
        }
        Object lockTimeout = props.get("javax.persistence.lock.timeout");
        int timeout = 0;
        boolean timeoutSet = false;
        if (lockTimeout instanceof String) {
            timeout = Integer.parseInt((String)lockTimeout);
            timeoutSet = true;
        } else if (lockTimeout instanceof Number) {
            timeout = ((Number)lockTimeout).intValue();
            timeoutSet = true;
        } else if (lockTimeout != null) {
            throw new PersistenceException("Unable to parse javax.persistence.lock.timeout: " + lockTimeout);
        }
        if (timeoutSet) {
            if (timeout == -2) {
                options.setTimeOut(-2);
            } else if (timeout < 0) {
                options.setTimeOut(-1);
            } else if (timeout == 0) {
                options.setTimeOut(0);
            } else {
                options.setTimeOut(timeout);
            }
        }
    }

    private void setDefaultProperties() {
        if (this.properties.get("org.hibernate.flushMode") == null) {
            this.properties.put("org.hibernate.flushMode", this.getSession().getFlushMode().toString());
        }
        if (this.properties.get("javax.persistence.lock.scope") == null) {
            this.properties.put("javax.persistence.lock.scope", PessimisticLockScope.EXTENDED.name());
        }
        if (this.properties.get("javax.persistence.lock.timeout") == null) {
            this.properties.put("javax.persistence.lock.timeout", -1);
        }
        if (this.properties.get("javax.persistence.cache.retrieveMode") == null) {
            this.properties.put("javax.persistence.cache.retrieveMode", (Object)CacheModeHelper.DEFAULT_RETRIEVE_MODE);
        }
        if (this.properties.get("javax.persistence.cache.storeMode") == null) {
            this.properties.put("javax.persistence.cache.storeMode", (Object)CacheModeHelper.DEFAULT_STORE_MODE);
        }
    }

    @Override
    public javax.persistence.Query createQuery(String jpaqlString) {
        this.checkOpen();
        try {
            return this.applyProperties(new QueryImpl((Query)this.internalGetSession().createQuery(jpaqlString), this));
        }
        catch (RuntimeException e) {
            throw this.convert(e);
        }
    }

    protected abstract void checkOpen();

    @Override
    public <T> TypedQuery<T> createQuery(String jpaqlString, Class<T> resultClass) {
        this.checkOpen();
        try {
            javax.persistence.Query hqlQuery = this.internalGetSession().createQuery(jpaqlString);
            this.resultClassChecking(resultClass, (Query)hqlQuery);
            return new QueryImpl((Query)hqlQuery, this);
        }
        catch (RuntimeException e) {
            throw this.convert(e);
        }
    }

    protected void resultClassChecking(Class resultClass, Query hqlQuery) {
        SessionImplementor session = this.unwrap(SessionImplementor.class);
        HQLQueryPlan queryPlan = session.getFactory().getQueryPlanCache().getHQLQueryPlan(hqlQuery.getQueryString(), false, session.getLoadQueryInfluencers().getEnabledFilters());
        if (queryPlan.getTranslators()[0].isManipulationStatement()) {
            throw new IllegalArgumentException("Update/delete queries cannot be typed");
        }
        if (!Object[].class.equals((Object)resultClass)) {
            if (Tuple.class.equals((Object)resultClass)) {
                TupleBuilderTransformer tupleTransformer = new TupleBuilderTransformer(hqlQuery);
                hqlQuery.setResultTransformer(tupleTransformer);
            } else {
                Class dynamicInstantiationClass = queryPlan.getDynamicInstantiationResultType();
                if (dynamicInstantiationClass != null) {
                    if (!resultClass.isAssignableFrom(dynamicInstantiationClass)) {
                        throw new IllegalArgumentException("Mismatch in requested result type [" + resultClass.getName() + "] and actual result type [" + dynamicInstantiationClass.getName() + "]");
                    }
                } else if (hqlQuery.getReturnTypes().length == 1) {
                    if (!resultClass.isAssignableFrom(hqlQuery.getReturnTypes()[0].getReturnedClass())) {
                        throw new IllegalArgumentException("Type specified for TypedQuery [" + resultClass.getName() + "] is incompatible with query return type [" + hqlQuery.getReturnTypes()[0].getReturnedClass() + "]");
                    }
                } else {
                    throw new IllegalArgumentException("Cannot create TypedQuery for query with more than one return using requested result type [" + resultClass.getName() + "]");
                }
            }
        }
    }

    public <T> QueryImpl<T> createQuery(String jpaqlString, Class<T> resultClass, Selection selection, HibernateEntityManagerImplementor.QueryOptions queryOptions) {
        try {
            List<Selection<?>> tupleElements;
            javax.persistence.Query hqlQuery = this.internalGetSession().createQuery(jpaqlString);
            if (queryOptions.getValueHandlers() == null && queryOptions.getResultMetadataValidator() != null) {
                queryOptions.getResultMetadataValidator().validate(hqlQuery.getReturnTypes());
            }
            List<Selection<?>> list = tupleElements = Tuple.class.equals(resultClass) ? ((CompoundSelectionImpl)selection).getCompoundSelectionItems() : null;
            if (queryOptions.getValueHandlers() != null || tupleElements != null) {
                hqlQuery.setResultTransformer(new CriteriaQueryTransformer(queryOptions.getValueHandlers(), tupleElements));
            }
            return new QueryImpl((Query)hqlQuery, this, queryOptions.getNamedParameterExplicitTypes());
        }
        catch (RuntimeException e) {
            throw this.convert(e);
        }
    }

    protected CriteriaCompiler criteriaCompiler() {
        if (this.criteriaCompiler == null) {
            this.criteriaCompiler = new CriteriaCompiler(this);
        }
        return this.criteriaCompiler;
    }

    @Override
    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        this.checkOpen();
        try {
            return (TypedQuery)this.criteriaCompiler().compile((CompilableCriteria)((Object)criteriaQuery));
        }
        catch (RuntimeException e) {
            throw this.convert(e);
        }
    }

    @Override
    public javax.persistence.Query createQuery(CriteriaUpdate criteriaUpdate) {
        this.checkOpen();
        try {
            return this.criteriaCompiler().compile((CompilableCriteria)((Object)criteriaUpdate));
        }
        catch (RuntimeException e) {
            throw this.convert(e);
        }
    }

    @Override
    public javax.persistence.Query createQuery(CriteriaDelete criteriaDelete) {
        this.checkOpen();
        try {
            return this.criteriaCompiler().compile((CompilableCriteria)((Object)criteriaDelete));
        }
        catch (RuntimeException e) {
            throw this.convert(e);
        }
    }

    @Override
    public javax.persistence.Query createNamedQuery(String name) {
        return this.buildQueryFromName(name, null);
    }

    private QueryImpl buildQueryFromName(String name, Class resultType) {
        this.checkOpen();
        SessionFactoryImplementor sfi = this.entityManagerFactory.getSessionFactory();
        NamedQueryDefinition jpqlDefinition = sfi.getNamedQueryRepository().getNamedQueryDefinition(name);
        if (jpqlDefinition != null) {
            return this.createNamedJpqlQuery(jpqlDefinition, resultType);
        }
        NamedSQLQueryDefinition nativeQueryDefinition = sfi.getNamedQueryRepository().getNamedSQLQueryDefinition(name);
        if (nativeQueryDefinition != null) {
            return this.createNamedSqlQuery(nativeQueryDefinition, resultType);
        }
        throw this.convert(new IllegalArgumentException("No query defined for that name [" + name + "]"));
    }

    protected QueryImpl createNamedJpqlQuery(NamedQueryDefinition namedQueryDefinition, Class resultType) {
        Query hibQuery = ((SessionImplementor)this.internalGetSession()).createQuery(namedQueryDefinition);
        if (resultType != null) {
            this.resultClassChecking(resultType, hibQuery);
        }
        return this.wrapAsJpaQuery(namedQueryDefinition, hibQuery);
    }

    protected QueryImpl wrapAsJpaQuery(NamedQueryDefinition namedQueryDefinition, Query hibQuery) {
        try {
            QueryImpl jpaQuery = new QueryImpl(hibQuery, this);
            this.applySavedSettings(namedQueryDefinition, jpaQuery);
            return jpaQuery;
        }
        catch (RuntimeException e) {
            throw this.convert(e);
        }
    }

    protected void applySavedSettings(NamedQueryDefinition namedQueryDefinition, QueryImpl jpaQuery) {
        if (namedQueryDefinition.isCacheable()) {
            jpaQuery.setHint("org.hibernate.cacheable", true);
            if (namedQueryDefinition.getCacheRegion() != null) {
                jpaQuery.setHint("org.hibernate.cacheRegion", namedQueryDefinition.getCacheRegion());
            }
        }
        if (namedQueryDefinition.getCacheMode() != null) {
            jpaQuery.setHint("org.hibernate.cacheMode", (Object)namedQueryDefinition.getCacheMode());
        }
        if (namedQueryDefinition.isReadOnly()) {
            jpaQuery.setHint("org.hibernate.readOnly", true);
        }
        if (namedQueryDefinition.getTimeout() != null) {
            jpaQuery.setHint("javax.persistence.query.timeout", namedQueryDefinition.getTimeout() * 1000);
        }
        if (namedQueryDefinition.getFetchSize() != null) {
            jpaQuery.setHint("org.hibernate.fetchSize", namedQueryDefinition.getFetchSize());
        }
        if (namedQueryDefinition.getComment() != null) {
            jpaQuery.setHint("org.hibernate.comment", namedQueryDefinition.getComment());
        }
        if (namedQueryDefinition.getFirstResult() != null) {
            jpaQuery.setFirstResult(namedQueryDefinition.getFirstResult());
        }
        if (namedQueryDefinition.getMaxResults() != null) {
            jpaQuery.setMaxResults(namedQueryDefinition.getMaxResults());
        }
        if (namedQueryDefinition.getLockOptions() != null && namedQueryDefinition.getLockOptions().getLockMode() != null) {
            jpaQuery.setLockMode(LockModeTypeHelper.getLockModeType(namedQueryDefinition.getLockOptions().getLockMode()));
        }
        if (namedQueryDefinition.getFlushMode() != null) {
            if (namedQueryDefinition.getFlushMode() == FlushMode.COMMIT) {
                jpaQuery.setFlushMode(FlushModeType.COMMIT);
            } else {
                jpaQuery.setFlushMode(FlushModeType.AUTO);
            }
        }
    }

    protected QueryImpl createNamedSqlQuery(NamedSQLQueryDefinition namedQueryDefinition, Class resultType) {
        if (resultType != null) {
            this.resultClassChecking(resultType, namedQueryDefinition);
        }
        return this.wrapAsJpaQuery(namedQueryDefinition, ((SessionImplementor)this.internalGetSession()).createSQLQuery(namedQueryDefinition));
    }

    protected void resultClassChecking(Class resultType, NamedSQLQueryDefinition namedQueryDefinition) {
        NativeSQLQueryConstructorReturn ctorRtn;
        NativeSQLQueryReturn[] queryReturns;
        SessionFactoryImplementor sfi = this.entityManagerFactory.getSessionFactory();
        if (namedQueryDefinition.getQueryReturns() != null) {
            queryReturns = namedQueryDefinition.getQueryReturns();
        } else if (namedQueryDefinition.getResultSetRef() != null) {
            ResultSetMappingDefinition rsMapping = sfi.getResultSetMapping(namedQueryDefinition.getResultSetRef());
            queryReturns = rsMapping.getQueryReturns();
        } else {
            throw new AssertionFailure("Unsupported named query model. Please report the bug in Hibernate EntityManager");
        }
        if (queryReturns.length > 1) {
            throw new IllegalArgumentException("Cannot create TypedQuery for query with more than one return");
        }
        NativeSQLQueryReturn nativeSQLQueryReturn = queryReturns[0];
        if (nativeSQLQueryReturn instanceof NativeSQLQueryRootReturn) {
            Class actualReturnedClass;
            String entityClassName = ((NativeSQLQueryRootReturn)nativeSQLQueryReturn).getReturnEntityName();
            try {
                actualReturnedClass = sfi.getServiceRegistry().getService(ClassLoaderService.class).classForName(entityClassName);
            }
            catch (ClassLoadingException e) {
                throw new AssertionFailure("Unable to load class [" + entityClassName + "] declared on named native query [" + namedQueryDefinition.getName() + "]");
            }
            if (!resultType.isAssignableFrom(actualReturnedClass)) {
                throw this.buildIncompatibleException(resultType, actualReturnedClass);
            }
        } else if (nativeSQLQueryReturn instanceof NativeSQLQueryConstructorReturn && !resultType.isAssignableFrom((ctorRtn = (NativeSQLQueryConstructorReturn)nativeSQLQueryReturn).getTargetClass())) {
            throw this.buildIncompatibleException(resultType, ctorRtn.getTargetClass());
        }
    }

    @Override
    public <T> TypedQuery<T> createNamedQuery(String name, Class<T> resultClass) {
        return this.buildQueryFromName(name, resultClass);
    }

    private IllegalArgumentException buildIncompatibleException(Class<?> resultClass, Class<?> actualResultClass) {
        return new IllegalArgumentException("Type specified for TypedQuery [" + resultClass.getName() + "] is incompatible with query return type [" + actualResultClass + "]");
    }

    @Override
    public javax.persistence.Query createNativeQuery(String sqlString) {
        this.checkOpen();
        try {
            SQLQuery q = this.internalGetSession().createSQLQuery(sqlString);
            return new QueryImpl(q, this);
        }
        catch (RuntimeException he) {
            throw this.convert(he);
        }
    }

    @Override
    public javax.persistence.Query createNativeQuery(String sqlString, Class resultClass) {
        this.checkOpen();
        try {
            SQLQuery q = this.internalGetSession().createSQLQuery(sqlString);
            q.addEntity("alias1", resultClass.getName(), LockMode.READ);
            return new QueryImpl(q, this);
        }
        catch (RuntimeException he) {
            throw this.convert(he);
        }
    }

    @Override
    public javax.persistence.Query createNativeQuery(String sqlString, String resultSetMapping) {
        this.checkOpen();
        try {
            SQLQuery q = this.internalGetSession().createSQLQuery(sqlString);
            q.setResultSetMapping(resultSetMapping);
            return new QueryImpl(q, this);
        }
        catch (RuntimeException he) {
            throw this.convert(he);
        }
    }

    @Override
    public StoredProcedureQuery createNamedStoredProcedureQuery(String name) {
        this.checkOpen();
        try {
            ProcedureCallMemento memento = ((SessionImplementor)this.internalGetSession()).getFactory().getNamedQueryRepository().getNamedProcedureCallMemento(name);
            if (memento == null) {
                throw new IllegalArgumentException("No @NamedStoredProcedureQuery was found with that name : " + name);
            }
            StoredProcedureQueryImpl jpaImpl = new StoredProcedureQueryImpl(memento, (HibernateEntityManagerImplementor)this);
            if (memento.getHintsMap() != null) {
                for (Map.Entry<String, Object> hintEntry : memento.getHintsMap().entrySet()) {
                    jpaImpl.setHint(hintEntry.getKey(), hintEntry.getValue());
                }
            }
            return jpaImpl;
        }
        catch (RuntimeException e) {
            throw this.convert(e);
        }
    }

    @Override
    public StoredProcedureQuery createStoredProcedureQuery(String procedureName) {
        this.checkOpen();
        try {
            return new StoredProcedureQueryImpl(this.internalGetSession().createStoredProcedureCall(procedureName), (HibernateEntityManagerImplementor)this);
        }
        catch (RuntimeException e) {
            throw this.convert(e);
        }
    }

    @Override
    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, Class ... resultClasses) {
        this.checkOpen();
        try {
            return new StoredProcedureQueryImpl(this.internalGetSession().createStoredProcedureCall(procedureName, resultClasses), (HibernateEntityManagerImplementor)this);
        }
        catch (RuntimeException e) {
            throw this.convert(e);
        }
    }

    @Override
    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, String ... resultSetMappings) {
        this.checkOpen();
        try {
            try {
                return new StoredProcedureQueryImpl(this.internalGetSession().createStoredProcedureCall(procedureName, resultSetMappings), (HibernateEntityManagerImplementor)this);
            }
            catch (UnknownSqlResultSetMappingException unknownResultSetMapping) {
                throw new IllegalArgumentException(unknownResultSetMapping.getMessage(), unknownResultSetMapping);
            }
        }
        catch (RuntimeException e) {
            throw this.convert(e);
        }
    }

    @Override
    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        this.checkOpen();
        try {
            return this.internalGetSession().load(entityClass, (Serializable)primaryKey);
        }
        catch (MappingException e) {
            throw this.convert(new IllegalArgumentException(e.getMessage(), e));
        }
        catch (TypeMismatchException e) {
            throw this.convert(new IllegalArgumentException(e.getMessage(), e));
        }
        catch (ClassCastException e) {
            throw this.convert(new IllegalArgumentException(e.getMessage(), e));
        }
        catch (RuntimeException e) {
            throw this.convert(e);
        }
    }

    public <A> A find(Class<A> entityClass, Object primaryKey) {
        this.checkOpen();
        return this.find(entityClass, primaryKey, (LockModeType)null, (Map<String, Object>)null);
    }

    @Override
    public <T> T find(Class<T> entityClass, Object primaryKey, Map<String, Object> properties) {
        this.checkOpen();
        return this.find((Class)entityClass, primaryKey, (LockModeType)null, properties);
    }

    public <A> A find(Class<A> entityClass, Object primaryKey, LockModeType lockModeType) {
        this.checkOpen();
        return this.find(entityClass, primaryKey, lockModeType, (Map<String, Object>)null);
    }

    public <A> A find(Class<A> entityClass, Object primaryKey, LockModeType lockModeType, Map<String, Object> properties) {
        this.checkOpen();
        Session session = this.internalGetSession();
        CacheMode previousCacheMode = session.getCacheMode();
        CacheMode cacheMode = this.determineAppropriateLocalCacheMode(properties);
        LockOptions lockOptions = null;
        try {
            if (properties != null && !properties.isEmpty()) {
                ((SessionImplementor)session).getLoadQueryInfluencers().setFetchGraph((EntityGraph)properties.get("javax.persistence.fetchgraph"));
                ((SessionImplementor)session).getLoadQueryInfluencers().setLoadGraph((EntityGraph)properties.get("javax.persistence.loadgraph"));
            }
            session.setCacheMode(cacheMode);
            if (lockModeType != null) {
                lockOptions = this.getLockRequest(lockModeType, properties);
                if (!LockModeType.NONE.equals((Object)lockModeType)) {
                    this.checkTransactionNeeded();
                }
                A a = session.get(entityClass, (Serializable)primaryKey, lockOptions);
                return a;
            }
            A a = session.get(entityClass, (Serializable)primaryKey);
            return a;
        }
        catch (EntityNotFoundException ignored) {
            if (LOG.isDebugEnabled()) {
                String entityName = entityClass != null ? entityClass.getName() : null;
                String identifierValue = primaryKey != null ? primaryKey.toString() : null;
                LOG.ignoringEntityNotFound(entityName, identifierValue);
            }
            A a = null;
            return a;
        }
        catch (ObjectDeletedException e) {
            A a = null;
            return a;
        }
        catch (ObjectNotFoundException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (MappingException e) {
            throw this.convert(new IllegalArgumentException(e.getMessage(), e));
        }
        catch (TypeMismatchException e) {
            throw this.convert(new IllegalArgumentException(e.getMessage(), e));
        }
        catch (ClassCastException e) {
            throw this.convert(new IllegalArgumentException(e.getMessage(), e));
        }
        catch (RuntimeException e) {
            throw this.convert(e, lockOptions);
        }
        finally {
            session.setCacheMode(previousCacheMode);
            ((SessionImplementor)session).getLoadQueryInfluencers().setFetchGraph(null);
            ((SessionImplementor)session).getLoadQueryInfluencers().setLoadGraph(null);
        }
    }

    public CacheMode determineAppropriateLocalCacheMode(Map<String, Object> localProperties) {
        CacheRetrieveMode retrieveMode = null;
        CacheStoreMode storeMode = null;
        if (localProperties != null) {
            retrieveMode = this.determineCacheRetrieveMode(localProperties);
            storeMode = this.determineCacheStoreMode(localProperties);
        }
        if (retrieveMode == null) {
            retrieveMode = this.determineCacheRetrieveMode(this.properties);
        }
        if (storeMode == null) {
            storeMode = this.determineCacheStoreMode(this.properties);
        }
        return CacheModeHelper.interpretCacheMode(storeMode, retrieveMode);
    }

    private void checkTransactionNeeded() {
        if (!this.isTransactionInProgress()) {
            throw new TransactionRequiredException("no transaction is in progress");
        }
    }

    @Override
    public void persist(Object entity) {
        this.checkOpen();
        try {
            this.internalGetSession().persist(entity);
        }
        catch (MappingException e) {
            throw this.convert(new IllegalArgumentException(e.getMessage()));
        }
        catch (RuntimeException e) {
            throw this.convert(e);
        }
    }

    public <A> A merge(A entity) {
        this.checkOpen();
        try {
            return (A)this.internalGetSession().merge(entity);
        }
        catch (ObjectDeletedException sse) {
            throw this.convert(new IllegalArgumentException(sse));
        }
        catch (MappingException e) {
            throw this.convert(new IllegalArgumentException(e.getMessage(), e));
        }
        catch (RuntimeException e) {
            throw this.convert(e);
        }
    }

    @Override
    public void remove(Object entity) {
        this.checkOpen();
        try {
            this.internalGetSession().delete(entity);
        }
        catch (MappingException e) {
            throw this.convert(new IllegalArgumentException(e.getMessage(), e));
        }
        catch (RuntimeException e) {
            throw this.convert(e);
        }
    }

    @Override
    public void refresh(Object entity) {
        this.refresh(entity, null, null);
    }

    @Override
    public void refresh(Object entity, Map<String, Object> properties) {
        this.refresh(entity, null, properties);
    }

    @Override
    public void refresh(Object entity, LockModeType lockModeType) {
        this.refresh(entity, lockModeType, null);
    }

    @Override
    public void refresh(Object entity, LockModeType lockModeType, Map<String, Object> properties) {
        this.checkOpen();
        Session session = this.internalGetSession();
        CacheMode previousCacheMode = session.getCacheMode();
        CacheMode localCacheMode = this.determineAppropriateLocalCacheMode(properties);
        LockOptions lockOptions = null;
        try {
            session.setCacheMode(localCacheMode);
            if (!session.contains(entity)) {
                throw this.convert(new IllegalArgumentException("Entity not managed"));
            }
            if (lockModeType != null) {
                if (!LockModeType.NONE.equals((Object)lockModeType)) {
                    this.checkTransactionNeeded();
                }
                lockOptions = this.getLockRequest(lockModeType, properties);
                session.refresh(entity, lockOptions);
            } else {
                session.refresh(entity);
            }
        }
        catch (MappingException e) {
            throw this.convert(new IllegalArgumentException(e.getMessage(), e));
        }
        catch (RuntimeException e) {
            throw this.convert(e, lockOptions);
        }
        finally {
            session.setCacheMode(previousCacheMode);
        }
    }

    @Override
    public boolean contains(Object entity) {
        this.checkOpen();
        try {
            if (entity != null && !(entity instanceof HibernateProxy) && this.internalGetSession().getSessionFactory().getClassMetadata(entity.getClass()) == null) {
                throw this.convert(new IllegalArgumentException("Not an entity:" + entity.getClass()));
            }
            return this.internalGetSession().contains(entity);
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (RuntimeException e) {
            throw this.convert(e);
        }
    }

    @Override
    public LockModeType getLockMode(Object entity) {
        this.checkOpen();
        if (!this.isTransactionInProgress()) {
            throw new TransactionRequiredException("Call to EntityManager#getLockMode should occur within transaction according to spec");
        }
        if (!this.contains(entity)) {
            throw this.convert(new IllegalArgumentException("entity not in the persistence context"));
        }
        return AbstractEntityManagerImpl.getLockModeType(this.internalGetSession().getCurrentLockMode(entity));
    }

    @Override
    public void setProperty(String s, Object o) {
        this.checkOpen();
        if (ENTITY_MANAGER_SPECIFIC_PROPERTIES.contains(s)) {
            this.properties.put(s, o);
            this.applyProperties();
        } else {
            LOG.debugf("Trying to set a property which is not supported on entity manager level", new Object[0]);
        }
    }

    @Override
    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public void flush() {
        this.checkOpen();
        this.checkTransactionNeeded();
        try {
            this.internalGetSession().flush();
        }
        catch (RuntimeException e) {
            throw this.convert(e);
        }
    }

    @Override
    public abstract Session getSession();

    @Deprecated
    protected abstract Session getRawSession();

    protected abstract Session internalGetSession();

    @Override
    public EntityTransaction getTransaction() {
        if (this.transactionType == PersistenceUnitTransactionType.JTA) {
            throw new IllegalStateException("A JTA EntityManager cannot use getTransaction()");
        }
        return this.tx;
    }

    @Override
    public EntityManagerFactoryImpl getEntityManagerFactory() {
        this.checkOpen();
        return this.internalGetEntityManagerFactory();
    }

    protected EntityManagerFactoryImpl internalGetEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    @Override
    public HibernateEntityManagerFactory getFactory() {
        return this.entityManagerFactory;
    }

    @Override
    public CriteriaBuilder getCriteriaBuilder() {
        this.checkOpen();
        return this.getEntityManagerFactory().getCriteriaBuilder();
    }

    @Override
    public Metamodel getMetamodel() {
        this.checkOpen();
        return this.getEntityManagerFactory().getMetamodel();
    }

    @Override
    public void setFlushMode(FlushModeType flushModeType) {
        this.checkOpen();
        if (flushModeType == FlushModeType.AUTO) {
            this.internalGetSession().setFlushMode(FlushMode.AUTO);
        } else if (flushModeType == FlushModeType.COMMIT) {
            this.internalGetSession().setFlushMode(FlushMode.COMMIT);
        } else {
            throw new AssertionFailure("Unknown FlushModeType: " + (Object)((Object)flushModeType));
        }
    }

    @Override
    public void clear() {
        this.checkOpen();
        try {
            this.internalGetSession().clear();
        }
        catch (RuntimeException e) {
            throw this.convert(e);
        }
    }

    @Override
    public void detach(Object entity) {
        this.checkOpen();
        try {
            this.internalGetSession().evict(entity);
        }
        catch (RuntimeException e) {
            throw this.convert(e);
        }
    }

    @Override
    public FlushModeType getFlushMode() {
        this.checkOpen();
        FlushMode mode = this.internalGetSession().getFlushMode();
        if (mode == FlushMode.AUTO) {
            return FlushModeType.AUTO;
        }
        if (mode == FlushMode.COMMIT) {
            return FlushModeType.COMMIT;
        }
        return null;
    }

    @Override
    public void lock(Object entity, LockModeType lockMode) {
        this.lock(entity, lockMode, null);
    }

    @Override
    public void lock(Object entity, LockModeType lockModeType, Map<String, Object> properties) {
        this.checkOpen();
        this.checkTransactionNeeded();
        LockOptions lockOptions = null;
        try {
            if (!this.contains(entity)) {
                throw new IllegalArgumentException("entity not in the persistence context");
            }
            lockOptions = this.getLockRequest(lockModeType, properties);
            this.internalGetSession().buildLockRequest(lockOptions).lock(entity);
        }
        catch (RuntimeException e) {
            throw this.convert(e, lockOptions);
        }
    }

    @Override
    public LockOptions getLockRequest(LockModeType lockModeType, Map<String, Object> properties) {
        LockOptions lockOptions = new LockOptions();
        LockOptions.copy(this.lockOptions, lockOptions);
        lockOptions.setLockMode(AbstractEntityManagerImpl.getLockMode(lockModeType));
        if (properties != null) {
            this.setLockOptions(properties, lockOptions);
        }
        return lockOptions;
    }

    private static LockModeType getLockModeType(LockMode lockMode) {
        return LockModeTypeHelper.getLockModeType(lockMode);
    }

    private static LockMode getLockMode(LockModeType lockMode) {
        return LockModeTypeHelper.getLockMode(lockMode);
    }

    @Override
    public boolean isTransactionInProgress() {
        return ((SessionImplementor)this.internalGetSession()).isTransactionInProgress();
    }

    private SessionFactoryImplementor sfi() {
        return (SessionFactoryImplementor)this.internalGetSession().getSessionFactory();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        this.checkOpen();
        if (Session.class.isAssignableFrom(clazz)) {
            return (T)this.internalGetSession();
        }
        if (SessionImplementor.class.isAssignableFrom(clazz)) {
            return (T)this.internalGetSession();
        }
        if (EntityManager.class.isAssignableFrom(clazz)) {
            return (T)this;
        }
        throw new PersistenceException("Hibernate cannot unwrap " + clazz);
    }

    @Override
    public void markForRollbackOnly() {
        LOG.debugf("Mark transaction for rollback", new Object[0]);
        if (this.tx.isActive()) {
            this.tx.setRollbackOnly();
        } else if (PersistenceUnitTransactionType.JTA == this.transactionType) {
            TransactionManager transactionManager = this.sfi().getServiceRegistry().getService(JtaPlatform.class).retrieveTransactionManager();
            if (transactionManager == null) {
                throw new PersistenceException("Using a JTA persistence context wo setting hibernate.transaction.jta.platform");
            }
            try {
                if (transactionManager.getStatus() != 6) {
                    transactionManager.setRollbackOnly();
                }
            }
            catch (SystemException e) {
                throw new PersistenceException("Unable to set the JTA transaction as RollbackOnly", e);
            }
        }
    }

    @Override
    public boolean isJoinedToTransaction() {
        this.checkOpen();
        SessionImplementor session = (SessionImplementor)this.internalGetSession();
        return this.isOpen() && session.getTransactionCoordinator().isJoined();
    }

    @Override
    public void joinTransaction() {
        this.checkOpen();
        this.joinTransaction(true);
    }

    private void joinTransaction(boolean explicitRequest) {
        if (this.transactionType != PersistenceUnitTransactionType.JTA) {
            if (explicitRequest) {
                LOG.callingJoinTransactionOnNonJtaEntityManager();
            }
            return;
        }
        try {
            ((SessionImplementor)this.internalGetSession()).getTransactionCoordinator().explicitJoin();
        }
        catch (TransactionRequiredForJoinException e) {
            throw new TransactionRequiredException(e.getMessage());
        }
        catch (HibernateException he) {
            throw this.convert(he);
        }
    }

    @Override
    public Object getDelegate() {
        this.checkOpen();
        return this.internalGetSession();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.tx = new TransactionImpl(this);
    }

    public void handlePersistenceException(PersistenceException e) {
        if (e instanceof NoResultException) {
            return;
        }
        if (e instanceof javax.persistence.NonUniqueResultException) {
            return;
        }
        if (e instanceof javax.persistence.LockTimeoutException) {
            return;
        }
        if (e instanceof javax.persistence.QueryTimeoutException) {
            return;
        }
        try {
            this.markForRollbackOnly();
        }
        catch (Exception ne) {
            LOG.unableToMarkForRollbackOnPersistenceException(ne);
        }
    }

    public void throwPersistenceException(PersistenceException e) {
        this.handlePersistenceException(e);
        throw e;
    }

    public RuntimeException convert(HibernateException e) {
        return this.convert(e, null);
    }

    public RuntimeException convert(RuntimeException e) {
        RuntimeException result = e;
        if (e instanceof HibernateException) {
            result = this.convert((HibernateException)e);
        } else {
            this.markForRollbackOnly();
        }
        return result;
    }

    public RuntimeException convert(RuntimeException e, LockOptions lockOptions) {
        RuntimeException result = e;
        if (e instanceof HibernateException) {
            result = this.convert((HibernateException)e, lockOptions);
        } else {
            this.markForRollbackOnly();
        }
        return result;
    }

    public RuntimeException convert(HibernateException e, LockOptions lockOptions) {
        Throwable cause = e;
        if (e instanceof TransactionException) {
            cause = e.getCause();
        }
        if (cause instanceof StaleStateException) {
            PersistenceException converted = this.wrapStaleStateException((StaleStateException)cause);
            this.handlePersistenceException(converted);
            return converted;
        }
        if (cause instanceof LockingStrategyException) {
            PersistenceException converted = this.wrapLockException((HibernateException)cause, lockOptions);
            this.handlePersistenceException(converted);
            return converted;
        }
        if (cause instanceof LockTimeoutException) {
            PersistenceException converted = this.wrapLockException((HibernateException)cause, lockOptions);
            this.handlePersistenceException(converted);
            return converted;
        }
        if (cause instanceof PessimisticLockException) {
            PersistenceException converted = this.wrapLockException((HibernateException)cause, lockOptions);
            this.handlePersistenceException(converted);
            return converted;
        }
        if (cause instanceof QueryTimeoutException) {
            javax.persistence.QueryTimeoutException converted = new javax.persistence.QueryTimeoutException(cause.getMessage(), cause);
            this.handlePersistenceException(converted);
            return converted;
        }
        if (cause instanceof ObjectNotFoundException) {
            EntityNotFoundException converted = new EntityNotFoundException(cause.getMessage());
            this.handlePersistenceException(converted);
            return converted;
        }
        if (cause instanceof NonUniqueObjectException) {
            EntityExistsException converted = new EntityExistsException(cause.getMessage());
            this.handlePersistenceException(converted);
            return converted;
        }
        if (cause instanceof NonUniqueResultException) {
            javax.persistence.NonUniqueResultException converted = new javax.persistence.NonUniqueResultException(cause.getMessage());
            this.handlePersistenceException(converted);
            return converted;
        }
        if (cause instanceof UnresolvableObjectException) {
            EntityNotFoundException converted = new EntityNotFoundException(cause.getMessage());
            this.handlePersistenceException(converted);
            return converted;
        }
        if (cause instanceof QueryException) {
            return new IllegalArgumentException(cause);
        }
        if (cause instanceof TransientObjectException) {
            try {
                this.markForRollbackOnly();
            }
            catch (Exception ne) {
                LOG.unableToMarkForRollbackOnTransientObjectException(ne);
            }
            return new IllegalStateException(e);
        }
        PersistenceException converted = new PersistenceException(cause);
        this.handlePersistenceException(converted);
        return converted;
    }

    public void throwPersistenceException(HibernateException e) {
        throw this.convert(e);
    }

    public PersistenceException wrapStaleStateException(StaleStateException e) {
        OptimisticLockException pe;
        block7: {
            if (e instanceof StaleObjectStateException) {
                StaleObjectStateException sose = (StaleObjectStateException)e;
                Serializable identifier = sose.getIdentifier();
                if (identifier != null) {
                    try {
                        Object entity = this.internalGetSession().load(sose.getEntityName(), identifier);
                        if (entity instanceof Serializable) {
                            pe = new OptimisticLockException(e.getMessage(), e, entity);
                            break block7;
                        }
                        pe = new OptimisticLockException(e.getMessage(), e);
                    }
                    catch (EntityNotFoundException enfe) {
                        pe = new OptimisticLockException(e.getMessage(), e);
                    }
                } else {
                    pe = new OptimisticLockException(e.getMessage(), e);
                }
            } else {
                pe = new OptimisticLockException(e.getMessage(), e);
            }
        }
        return pe;
    }

    public PersistenceException wrapLockException(HibernateException e, LockOptions lockOptions) {
        PersistenceException pe;
        if (e instanceof OptimisticEntityLockException) {
            OptimisticEntityLockException lockException = (OptimisticEntityLockException)e;
            pe = new OptimisticLockException(lockException.getMessage(), lockException, lockException.getEntity());
        } else if (e instanceof LockTimeoutException) {
            pe = new javax.persistence.LockTimeoutException(e.getMessage(), e, null);
        } else if (e instanceof PessimisticEntityLockException) {
            PessimisticEntityLockException lockException = (PessimisticEntityLockException)e;
            pe = lockOptions != null && lockOptions.getTimeOut() > -1 ? new javax.persistence.LockTimeoutException(lockException.getMessage(), lockException, lockException.getEntity()) : new javax.persistence.PessimisticLockException(lockException.getMessage(), lockException, lockException.getEntity());
        } else if (e instanceof PessimisticLockException) {
            PessimisticLockException jdbcLockException = (PessimisticLockException)e;
            pe = lockOptions != null && lockOptions.getTimeOut() > -1 ? new javax.persistence.LockTimeoutException(jdbcLockException.getMessage(), jdbcLockException, null) : new javax.persistence.PessimisticLockException(jdbcLockException.getMessage(), jdbcLockException, null);
        } else {
            pe = new OptimisticLockException(e);
        }
        return pe;
    }

    static {
        ENTITY_MANAGER_SPECIFIC_PROPERTIES.add("javax.persistence.lock.scope");
        ENTITY_MANAGER_SPECIFIC_PROPERTIES.add("javax.persistence.lock.timeout");
        ENTITY_MANAGER_SPECIFIC_PROPERTIES.add("org.hibernate.flushMode");
        ENTITY_MANAGER_SPECIFIC_PROPERTIES.add("javax.persistence.cache.retrieveMode");
        ENTITY_MANAGER_SPECIFIC_PROPERTIES.add("javax.persistence.cache.storeMode");
        ENTITY_MANAGER_SPECIFIC_PROPERTIES.add("javax.persistence.query.timeout");
    }

    private static class CriteriaQueryTransformer
    extends BasicTransformerAdapter {
        private final List<ValueHandlerFactory.ValueHandler> valueHandlers;
        private final List tupleElements;

        private CriteriaQueryTransformer(List<ValueHandlerFactory.ValueHandler> valueHandlers, List tupleElements) {
            this.valueHandlers = valueHandlers;
            this.tupleElements = tupleElements;
        }

        @Override
        public Object transformTuple(Object[] tuple, String[] aliases) {
            Object[] valueHandlerResult;
            if (this.valueHandlers == null) {
                valueHandlerResult = tuple;
            } else {
                valueHandlerResult = new Object[tuple.length];
                for (int i = 0; i < tuple.length; ++i) {
                    ValueHandlerFactory.ValueHandler valueHandler = this.valueHandlers.get(i);
                    valueHandlerResult[i] = valueHandler == null ? tuple[i] : valueHandler.convert(tuple[i]);
                }
            }
            return this.tupleElements == null ? (valueHandlerResult.length == 1 ? valueHandlerResult[0] : valueHandlerResult) : new TupleImpl(tuple);
        }

        private class TupleImpl
        implements Tuple {
            private final Object[] tuples;

            private TupleImpl(Object[] tuples) {
                if (tuples.length != CriteriaQueryTransformer.this.tupleElements.size()) {
                    throw new IllegalArgumentException("Size mismatch between tuple result [" + tuples.length + "] and expected tuple elements [" + CriteriaQueryTransformer.this.tupleElements.size() + "]");
                }
                this.tuples = tuples;
            }

            @Override
            public <X> X get(TupleElement<X> tupleElement) {
                int index = CriteriaQueryTransformer.this.tupleElements.indexOf(tupleElement);
                if (index < 0) {
                    throw new IllegalArgumentException("Requested tuple element did not correspond to element in the result tuple");
                }
                return (X)this.tuples[index];
            }

            @Override
            public Object get(String alias) {
                int index = -1;
                if (alias != null && (alias = alias.trim()).length() > 0) {
                    int i = 0;
                    for (TupleElement selection : CriteriaQueryTransformer.this.tupleElements) {
                        if (alias.equals(selection.getAlias())) {
                            index = i;
                            break;
                        }
                        ++i;
                    }
                }
                if (index < 0) {
                    throw new IllegalArgumentException("Given alias [" + alias + "] did not correspond to an element in the result tuple");
                }
                return this.tuples[index];
            }

            @Override
            public <X> X get(String alias, Class<X> type) {
                Object untyped = this.get(alias);
                if (untyped != null && !type.isInstance(untyped)) {
                    throw new IllegalArgumentException(String.format("Requested tuple value [alias=%s, value=%s] cannot be assigned to requested type [%s]", alias, untyped, type.getName()));
                }
                return (X)untyped;
            }

            @Override
            public Object get(int i) {
                if (i >= this.tuples.length) {
                    throw new IllegalArgumentException("Given index [" + i + "] was outside the range of result tuple size [" + this.tuples.length + "] ");
                }
                return this.tuples[i];
            }

            @Override
            public <X> X get(int i, Class<X> type) {
                Object result = this.get(i);
                if (result != null && !type.isInstance(result)) {
                    throw new IllegalArgumentException(String.format("Requested tuple value [index=%s, realType=%s] cannot be assigned to requested type [%s]", i, result.getClass().getName(), type.getName()));
                }
                return (X)result;
            }

            @Override
            public Object[] toArray() {
                return this.tuples;
            }

            @Override
            public List<TupleElement<?>> getElements() {
                return CriteriaQueryTransformer.this.tupleElements;
            }
        }
    }

    public static class TupleBuilderTransformer
    extends BasicTransformerAdapter {
        private List<TupleElement<?>> tupleElements;
        private Map<String, HqlTupleElementImpl> tupleElementsByAlias;

        public TupleBuilderTransformer(Query hqlQuery) {
            Type[] resultTypes = hqlQuery.getReturnTypes();
            int tupleSize = resultTypes.length;
            this.tupleElements = CollectionHelper.arrayList(tupleSize);
            String[] aliases = hqlQuery.getReturnAliases();
            boolean hasAliases = aliases != null && aliases.length > 0;
            this.tupleElementsByAlias = hasAliases ? CollectionHelper.mapOfSize(tupleSize) : Collections.emptyMap();
            for (int i = 0; i < tupleSize; ++i) {
                String alias;
                HqlTupleElementImpl tupleElement = new HqlTupleElementImpl(i, aliases == null ? null : aliases[i], resultTypes[i]);
                this.tupleElements.add(tupleElement);
                if (!hasAliases || (alias = aliases[i]) == null) continue;
                this.tupleElementsByAlias.put(alias, tupleElement);
            }
        }

        @Override
        public Object transformTuple(Object[] tuple, String[] aliases) {
            if (tuple.length != this.tupleElements.size()) {
                throw new IllegalArgumentException("Size mismatch between tuple result [" + tuple.length + "] and expected tuple elements [" + this.tupleElements.size() + "]");
            }
            return new HqlTupleImpl(tuple);
        }

        public class HqlTupleImpl
        implements Tuple {
            private Object[] tuple;

            public HqlTupleImpl(Object[] tuple) {
                this.tuple = tuple;
            }

            @Override
            public <X> X get(String alias, Class<X> type) {
                Object untyped = this.get(alias);
                if (untyped != null && !type.isInstance(untyped)) {
                    throw new IllegalArgumentException(String.format("Requested tuple value [alias=%s, value=%s] cannot be assigned to requested type [%s]", alias, untyped, type.getName()));
                }
                return (X)untyped;
            }

            @Override
            public Object get(String alias) {
                HqlTupleElementImpl tupleElement = (HqlTupleElementImpl)TupleBuilderTransformer.this.tupleElementsByAlias.get(alias);
                if (tupleElement == null) {
                    throw new IllegalArgumentException("Unknown alias [" + alias + "]");
                }
                return this.tuple[tupleElement.getPosition()];
            }

            @Override
            public <X> X get(int i, Class<X> type) {
                Object result = this.get(i);
                if (result != null && !type.isInstance(result)) {
                    throw new IllegalArgumentException(String.format("Requested tuple value [index=%s, realType=%s] cannot be assigned to requested type [%s]", i, result.getClass().getName(), type.getName()));
                }
                return (X)result;
            }

            @Override
            public Object get(int i) {
                if (i < 0) {
                    throw new IllegalArgumentException("requested tuple index must be greater than zero");
                }
                if (i > this.tuple.length) {
                    throw new IllegalArgumentException("requested tuple index exceeds actual tuple size");
                }
                return this.tuple[i];
            }

            @Override
            public Object[] toArray() {
                return this.tuple;
            }

            @Override
            public List<TupleElement<?>> getElements() {
                return TupleBuilderTransformer.this.tupleElements;
            }

            @Override
            public <X> X get(TupleElement<X> tupleElement) {
                if (HqlTupleElementImpl.class.isInstance(tupleElement)) {
                    return this.get(((HqlTupleElementImpl)tupleElement).getPosition(), tupleElement.getJavaType());
                }
                return this.get(tupleElement.getAlias(), tupleElement.getJavaType());
            }
        }

        public static class HqlTupleElementImpl<X>
        implements TupleElement<X> {
            private final int position;
            private final String alias;
            private final Type hibernateType;

            public HqlTupleElementImpl(int position, String alias, Type hibernateType) {
                this.position = position;
                this.alias = alias;
                this.hibernateType = hibernateType;
            }

            @Override
            public Class getJavaType() {
                return this.hibernateType.getReturnedClass();
            }

            @Override
            public String getAlias() {
                return this.alias;
            }

            public int getPosition() {
                return this.position;
            }

            public Type getHibernateType() {
                return this.hibernateType;
            }
        }
    }
}

