/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal;

import java.util.List;
import org.modelmapper.config.Configuration;
import org.modelmapper.internal.Accessor;
import org.modelmapper.internal.Mutator;
import org.modelmapper.internal.util.Stack;
import org.modelmapper.internal.util.ToStringBuilder;
import org.modelmapper.spi.NameableType;
import org.modelmapper.spi.PropertyInfo;
import org.modelmapper.spi.PropertyNameInfo;
import org.modelmapper.spi.Tokens;

class PropertyNameInfoImpl
implements PropertyNameInfo {
    private final Class<?> sourceClass;
    private final Configuration configuration;
    private Tokens sourceClassTokens;
    private Stack<Tokens> sourcePropertyTypeTokens;
    private final Stack<Tokens> sourcePropertyTokens = new Stack();
    private final Stack<Tokens> destinationPropertyTokens = new Stack();
    private final Stack<PropertyInfo> sourceProperties = new Stack();
    private final Stack<PropertyInfo> destinationProperties = new Stack();

    PropertyNameInfoImpl(Class<?> sourceClass, Configuration configuration) {
        this.sourceClass = sourceClass;
        this.configuration = configuration;
    }

    @Override
    public List<PropertyInfo> getDestinationProperties() {
        return this.destinationProperties;
    }

    @Override
    public List<Tokens> getDestinationPropertyTokens() {
        return this.destinationPropertyTokens;
    }

    @Override
    public Tokens getSourceClassTokens() {
        if (this.sourceClassTokens == null) {
            String className = this.configuration.getSourceNameTransformer().transform(this.sourceClass.getSimpleName(), NameableType.CLASS);
            this.sourceClassTokens = Tokens.of(this.configuration.getSourceNameTokenizer().tokenize(className, NameableType.CLASS));
        }
        return this.sourceClassTokens;
    }

    @Override
    public List<PropertyInfo> getSourceProperties() {
        return this.sourceProperties;
    }

    @Override
    public List<Tokens> getSourcePropertyTokens() {
        return this.sourcePropertyTokens;
    }

    @Override
    public List<Tokens> getSourcePropertyTypeTokens() {
        if (this.sourcePropertyTypeTokens == null) {
            this.sourcePropertyTypeTokens = new Stack();
            for (PropertyInfo sourceProperty : this.sourceProperties) {
                this.pushSourcePropertyType(sourceProperty);
            }
        }
        return this.sourcePropertyTypeTokens;
    }

    public String toString() {
        return new ToStringBuilder(PropertyNameInfoImpl.class).add("sourceProperties", this.sourceProperties).add("destinationProperties", this.destinationProperties).toString();
    }

    void clearSource() {
        this.sourceProperties.clear();
        this.sourcePropertyTokens.clear();
        if (this.sourcePropertyTypeTokens != null) {
            this.sourcePropertyTypeTokens.clear();
        }
    }

    void popDestination() {
        this.destinationProperties.pop();
        this.destinationPropertyTokens.pop();
    }

    void popSource() {
        this.sourceProperties.pop();
        this.sourcePropertyTokens.pop();
        if (this.sourcePropertyTypeTokens != null) {
            this.sourcePropertyTypeTokens.pop();
        }
    }

    void pushDestination(String destinationName, Mutator destinationProperty) {
        NameableType nameableType = NameableType.forPropertyType(destinationProperty.getPropertyType());
        String[] tokens = this.configuration.getDestinationNameTokenizer().tokenize(destinationName, nameableType);
        this.destinationPropertyTokens.push(Tokens.of(tokens));
        this.destinationProperties.push(destinationProperty);
    }

    void pushSource(String sourceName, Accessor sourceProperty) {
        NameableType nameableType = NameableType.forPropertyType(sourceProperty.getPropertyType());
        String[] tokens = this.configuration.getSourceNameTokenizer().tokenize(sourceName, nameableType);
        this.sourcePropertyTokens.push(Tokens.of(tokens));
        this.sourceProperties.push(sourceProperty);
        this.pushSourcePropertyType(sourceProperty);
    }

    private void pushSourcePropertyType(PropertyInfo sourceProperty) {
        if (this.sourcePropertyTypeTokens == null) {
            return;
        }
        String typeName = this.configuration.getSourceNameTransformer().transform(sourceProperty.getType().getSimpleName(), NameableType.CLASS);
        String[] tokens = this.configuration.getSourceNameTokenizer().tokenize(typeName, NameableType.CLASS);
        this.sourcePropertyTypeTokens.add(Tokens.of(tokens));
    }
}

