/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal.converter;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import javax.xml.datatype.XMLGregorianCalendar;
import org.modelmapper.internal.Errors;
import org.modelmapper.spi.ConditionalConverter;
import org.modelmapper.spi.MappingContext;

class DateConverter
implements ConditionalConverter<Object, Date> {
    DateConverter() {
    }

    @Override
    public Date convert(MappingContext<Object, Date> context) {
        Object source = context.getSource();
        if (source == null) {
            return null;
        }
        Class<Date> destinationType = context.getDestinationType();
        if (source instanceof Date) {
            return this.dateFor(((Date)source).getTime(), destinationType);
        }
        if (source instanceof Calendar) {
            return this.dateFor(((Calendar)source).getTimeInMillis(), destinationType);
        }
        if (source instanceof XMLGregorianCalendar) {
            return this.dateFor(((XMLGregorianCalendar)source).toGregorianCalendar().getTimeInMillis(), destinationType);
        }
        if (source instanceof Long) {
            return this.dateFor((Long)source, destinationType);
        }
        return this.dateFor(source.toString(), context.getDestinationType());
    }

    @Override
    public ConditionalConverter.MatchResult match(Class<?> sourceType, Class<?> destinationType) {
        return Date.class.isAssignableFrom(destinationType) && (Date.class.isAssignableFrom(sourceType) || Calendar.class.isAssignableFrom(sourceType) || sourceType == XMLGregorianCalendar.class || sourceType == Long.class || sourceType == Long.TYPE || sourceType == String.class) ? ConditionalConverter.MatchResult.FULL : ConditionalConverter.MatchResult.NONE;
    }

    Date dateFor(long source, Class<?> destinationType) {
        if (destinationType.equals(Date.class)) {
            return new Date(source);
        }
        if (destinationType.equals(java.sql.Date.class)) {
            return new java.sql.Date(source);
        }
        if (destinationType.equals(Time.class)) {
            return new Time(source);
        }
        if (destinationType.equals(Timestamp.class)) {
            return new Timestamp(source);
        }
        throw new Errors().errorMapping(source, destinationType).toMappingException();
    }

    Date dateFor(String source, Class<?> destinationType) {
        String sourceString = this.toString().trim();
        if (sourceString.length() == 0) {
            throw new Errors().errorMapping(source, destinationType).toMappingException();
        }
        if (destinationType.equals(java.sql.Date.class)) {
            try {
                return java.sql.Date.valueOf(source);
            }
            catch (IllegalArgumentException e) {
                throw new Errors().addMessage("String must be in JDBC format [yyyy-MM-dd] to create a java.sql.Date", new Object[0]).toMappingException();
            }
        }
        if (destinationType.equals(Time.class)) {
            try {
                return Time.valueOf(source);
            }
            catch (IllegalArgumentException e) {
                throw new Errors().addMessage("String must be in JDBC format [HH:mm:ss] to create a java.sql.Time", new Object[0]).toMappingException();
            }
        }
        if (destinationType.equals(Timestamp.class)) {
            try {
                return Timestamp.valueOf(source);
            }
            catch (IllegalArgumentException e) {
                throw new Errors().addMessage("String must be in JDBC format [yyyy-MM-dd HH:mm:ss.fffffffff] to create a java.sql.Timestamp", new Object[0]).toMappingException();
            }
        }
        throw new Errors().errorMapping(source, destinationType).toMappingException();
    }
}

