/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.convert;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.util.ClassUtils;

public abstract class Jsr310Converters {
    private static final boolean JAVA_8_IS_PRESENT = ClassUtils.isPresent("java.time.LocalDateTime", Jsr310Converters.class.getClassLoader());

    public static Collection<Converter<?, ?>> getConvertersToRegister() {
        if (!JAVA_8_IS_PRESENT) {
            return Collections.emptySet();
        }
        ArrayList converters = new ArrayList();
        converters.add(DateToLocalDateTimeConverter.INSTANCE);
        converters.add(LocalDateTimeToDateConverter.INSTANCE);
        converters.add(DateToLocalDateConverter.INSTANCE);
        converters.add(LocalDateToDateConverter.INSTANCE);
        converters.add(DateToLocalTimeConverter.INSTANCE);
        converters.add(LocalTimeToDateConverter.INSTANCE);
        converters.add(DateToInstantConverter.INSTANCE);
        converters.add(InstantToDateConverter.INSTANCE);
        converters.add(ZoneIdToStringConverter.INSTANCE);
        converters.add(StringToZoneIdConverter.INSTANCE);
        converters.add(DurationToStringConverter.INSTANCE);
        converters.add(StringToDurationConverter.INSTANCE);
        converters.add(PeriodToStringConverter.INSTANCE);
        converters.add(StringToPeriodConverter.INSTANCE);
        return converters;
    }

    public static boolean supports(Class<?> type) {
        if (!JAVA_8_IS_PRESENT) {
            return false;
        }
        return Arrays.asList(LocalDateTime.class, LocalDate.class, LocalTime.class, Instant.class).contains(type);
    }

    @ReadingConverter
    public static enum StringToPeriodConverter implements Converter<String, Period>
    {
        INSTANCE;


        @Override
        public Period convert(String s) {
            return Period.parse(s);
        }
    }

    @WritingConverter
    public static enum PeriodToStringConverter implements Converter<Period, String>
    {
        INSTANCE;


        @Override
        public String convert(Period period) {
            return period.toString();
        }
    }

    @ReadingConverter
    public static enum StringToDurationConverter implements Converter<String, Duration>
    {
        INSTANCE;


        @Override
        public Duration convert(String s) {
            return Duration.parse(s);
        }
    }

    @WritingConverter
    public static enum DurationToStringConverter implements Converter<Duration, String>
    {
        INSTANCE;


        @Override
        public String convert(Duration duration) {
            return duration.toString();
        }
    }

    @ReadingConverter
    public static enum StringToZoneIdConverter implements Converter<String, ZoneId>
    {
        INSTANCE;


        @Override
        public ZoneId convert(String source) {
            return ZoneId.of(source);
        }
    }

    @WritingConverter
    public static enum ZoneIdToStringConverter implements Converter<ZoneId, String>
    {
        INSTANCE;


        @Override
        public String convert(ZoneId source) {
            return source.toString();
        }
    }

    public static enum InstantToDateConverter implements Converter<Instant, Date>
    {
        INSTANCE;


        @Override
        public Date convert(Instant source) {
            return source == null ? null : Date.from(source.atZone(ZoneId.systemDefault()).toInstant());
        }
    }

    public static enum DateToInstantConverter implements Converter<Date, Instant>
    {
        INSTANCE;


        @Override
        public Instant convert(Date source) {
            return source == null ? null : source.toInstant();
        }
    }

    public static enum LocalTimeToDateConverter implements Converter<LocalTime, Date>
    {
        INSTANCE;


        @Override
        public Date convert(LocalTime source) {
            return source == null ? null : Date.from(source.atDate(LocalDate.now()).atZone(ZoneId.systemDefault()).toInstant());
        }
    }

    public static enum DateToLocalTimeConverter implements Converter<Date, LocalTime>
    {
        INSTANCE;


        @Override
        public LocalTime convert(Date source) {
            return source == null ? null : LocalDateTime.ofInstant(Instant.ofEpochMilli(source.getTime()), ZoneId.systemDefault()).toLocalTime();
        }
    }

    public static enum LocalDateToDateConverter implements Converter<LocalDate, Date>
    {
        INSTANCE;


        @Override
        public Date convert(LocalDate source) {
            return source == null ? null : Date.from(source.atStartOfDay(ZoneId.systemDefault()).toInstant());
        }
    }

    public static enum DateToLocalDateConverter implements Converter<Date, LocalDate>
    {
        INSTANCE;


        @Override
        public LocalDate convert(Date source) {
            return source == null ? null : LocalDateTime.ofInstant(Instant.ofEpochMilli(source.getTime()), ZoneId.systemDefault()).toLocalDate();
        }
    }

    public static enum LocalDateTimeToDateConverter implements Converter<LocalDateTime, Date>
    {
        INSTANCE;


        @Override
        public Date convert(LocalDateTime source) {
            return source == null ? null : Date.from(source.atZone(ZoneId.systemDefault()).toInstant());
        }
    }

    public static enum DateToLocalDateTimeConverter implements Converter<Date, LocalDateTime>
    {
        INSTANCE;


        @Override
        public LocalDateTime convert(Date source) {
            return source == null ? null : LocalDateTime.ofInstant(source.toInstant(), ZoneId.systemDefault());
        }
    }
}

