package br.pucrio.tecgraf.soma.job.application.service;

import br.pucrio.tecgraf.soma.job.domain.model.LostEvent;
import br.pucrio.tecgraf.soma.serviceapi.persistence.repository.Repository;
import br.pucrio.tecgraf.soma.serviceapi.persistence.specification.JPASpecification;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LostEventService {
	
	private Repository<LostEvent, JPASpecification<LostEvent>> lostEventRepository;
	
	@Autowired
	public LostEventService(Repository<LostEvent, JPASpecification<LostEvent>> lostEventRepository) {
		this.lostEventRepository = lostEventRepository;
	}
	
	@Transactional
	public void saveLostEvent(LostEvent event) {
		lostEventRepository.add(event);
	}
	
}
