/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.serviceapi.persistence.specification.impl;

import br.pucrio.tecgraf.soma.serviceapi.persistence.specification.JPASpecification;
import java.lang.reflect.Field;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;

public class GenericSpecification<T>
extends JPASpecification<T> {
    private String fieldName;
    private ComparisonOperator comparisonOperator;
    private Object value;
    private Class<T> typeParameterClass;

    public GenericSpecification(Class<T> typeParameterClass, String fieldName, ComparisonOperator comparisonOperator, Object value) {
        this.typeParameterClass = typeParameterClass;
        this.fieldName = fieldName;
        this.comparisonOperator = comparisonOperator;
        this.value = value;
    }

    @Override
    public Predicate toPredicate(Root<T> root, CriteriaBuilder cb) {
        switch (this.comparisonOperator) {
            case GT: {
                return cb.and(cb.greaterThan(root.get(this.fieldName), (Comparable)this.value));
            }
            case LT: {
                return cb.and(cb.lessThan(root.get(this.fieldName), (Comparable)this.value));
            }
            case GTE: {
                return cb.and(cb.greaterThanOrEqualTo(root.get(this.fieldName), (Comparable)this.value));
            }
            case LTE: {
                return cb.and(cb.lessThanOrEqualTo(root.get(this.fieldName), (Comparable)this.value));
            }
            case EQ: {
                return cb.and(cb.equal(root.get(this.fieldName), this.value));
            }
            case NE: {
                return cb.and(cb.notEqual(root.get(this.fieldName), this.value));
            }
            case LIKE: {
                return cb.and(cb.like(root.get(this.fieldName), "%" + this.value + "%"));
            }
        }
        return null;
    }

    @Override
    public boolean isSatisfiedBy(T element) {
        try {
            Field field = this.typeParameterClass.getDeclaredField(this.fieldName);
            field.setAccessible(true);
            switch (this.comparisonOperator) {
                case GT: {
                    return ((Comparable)field.get(element)).compareTo(this.value) > 0;
                }
                case LT: {
                    return ((Comparable)field.get(element)).compareTo(this.value) < 0;
                }
                case GTE: {
                    return ((Comparable)field.get(element)).compareTo(this.value) >= 0;
                }
                case LTE: {
                    return ((Comparable)field.get(element)).compareTo(this.value) <= 0;
                }
                case EQ: {
                    return field.get(element).equals(this.value);
                }
                case NE: {
                    return !field.get(element).equals(this.value);
                }
                case LIKE: {
                    return ((String)field.get(element)).contains((String)this.value);
                }
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public Class<T> getType() {
        return this.typeParameterClass;
    }

    public static enum ComparisonOperator {
        GT,
        LT,
        GTE,
        LTE,
        EQ,
        NE,
        LIKE;

    }
}

