/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.internal.javassist;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.enhance.internal.javassist.CompositeEnhancer;
import org.hibernate.bytecode.enhance.internal.javassist.EntityEnhancer;
import org.hibernate.bytecode.enhance.internal.javassist.FieldWriter;
import org.hibernate.bytecode.enhance.internal.javassist.JavassistEnhancementContext;
import org.hibernate.bytecode.enhance.internal.javassist.MappedSuperclassEnhancer;
import org.hibernate.bytecode.enhance.internal.javassist.PersistentAttributesEnhancer;
import org.hibernate.bytecode.enhance.internal.javassist.PersistentAttributesHelper;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.enhance.spi.EnhancementException;
import org.hibernate.bytecode.enhance.spi.Enhancer;
import org.hibernate.engine.spi.Managed;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;

public class EnhancerImpl
implements Enhancer {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(Enhancer.class);
    protected final JavassistEnhancementContext enhancementContext;
    private final ClassPool classPool;

    public EnhancerImpl(EnhancementContext enhancementContext) {
        this.enhancementContext = new JavassistEnhancementContext(enhancementContext);
        this.classPool = this.buildClassPool(this.enhancementContext);
    }

    EnhancerImpl(JavassistEnhancementContext enhancementContext) {
        this.enhancementContext = enhancementContext;
        this.classPool = this.buildClassPool(enhancementContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized byte[] enhance(String className, byte[] originalBytes) throws EnhancementException {
        CtClass managedCtClass = null;
        try {
            managedCtClass = this.classPool.makeClassIfNew(new ByteArrayInputStream(originalBytes));
            byte[] byArray = this.enhance(managedCtClass) ? this.getByteCode(managedCtClass) : null;
            return byArray;
        }
        catch (IOException e) {
            log.unableToBuildEnhancementMetamodel(className);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (managedCtClass != null) {
                managedCtClass.detach();
            }
        }
    }

    private ClassPool buildClassPool(final JavassistEnhancementContext enhancementContext) {
        ClassPool classPool = new ClassPool(false){

            @Override
            public ClassLoader getClassLoader() {
                return enhancementContext.getLoadingClassLoader();
            }
        };
        ClassLoader loadingClassLoader = enhancementContext.getLoadingClassLoader();
        if (loadingClassLoader != null) {
            classPool.appendClassPath(new LoaderClassPath(loadingClassLoader));
        }
        return classPool;
    }

    protected CtClass loadCtClassFromClass(Class<?> aClass) {
        String resourceName = aClass.getName().replace('.', '/') + ".class";
        InputStream resourceAsStream = aClass.getClassLoader().getResourceAsStream(resourceName);
        if (resourceAsStream == null) {
            throw new UncheckedIOException(new FileNotFoundException("Not found: " + resourceName));
        }
        try {
            CtClass ctClass = this.classPool.makeClass(resourceAsStream);
            return ctClass;
        }
        catch (IOException e) {
            throw new EnhancementException("Could not prepare Javassist ClassPool", e);
        }
        finally {
            try {
                resourceAsStream.close();
            }
            catch (IOException ioe) {
                log.debugf("An error occurs closing InputStream for class [%s]", (Object)aClass.getName());
            }
        }
    }

    private boolean enhance(CtClass managedCtClass) {
        if (managedCtClass.isInterface()) {
            log.debugf("Skipping enhancement of [%s]: it's an interface!", (Object)managedCtClass.getName());
            return false;
        }
        if (this.alreadyEnhanced(managedCtClass)) {
            log.debugf("Skipping enhancement of [%s]: already enhanced", (Object)managedCtClass.getName());
            return false;
        }
        if (this.enhancementContext.isEntityClass(managedCtClass)) {
            log.infof("Enhancing [%s] as Entity", (Object)managedCtClass.getName());
            new EntityEnhancer(this.enhancementContext).enhance(managedCtClass);
            return true;
        }
        if (this.enhancementContext.isCompositeClass(managedCtClass)) {
            log.infof("Enhancing [%s] as Composite", (Object)managedCtClass.getName());
            new CompositeEnhancer(this.enhancementContext).enhance(managedCtClass);
            return true;
        }
        if (this.enhancementContext.isMappedSuperclassClass(managedCtClass)) {
            log.infof("Enhancing [%s] as MappedSuperclass", (Object)managedCtClass.getName());
            new MappedSuperclassEnhancer(this.enhancementContext).enhance(managedCtClass);
            return true;
        }
        if (this.enhancementContext.doExtendedEnhancement(managedCtClass)) {
            log.infof("Extended enhancement of [%s]", (Object)managedCtClass.getName());
            new PersistentAttributesEnhancer(this.enhancementContext).extendedEnhancement(managedCtClass);
            return true;
        }
        log.debugf("Skipping enhancement of [%s]: not entity or composite", (Object)managedCtClass.getName());
        return false;
    }

    private boolean alreadyEnhanced(CtClass managedCtClass) {
        try {
            for (CtClass declaredInterface : managedCtClass.getInterfaces()) {
                if (!PersistentAttributesHelper.isAssignable(declaredInterface, Managed.class.getName())) continue;
                return true;
            }
            return false;
        }
        catch (NotFoundException e) {
            throw new HibernateException("Unable to transform class: " + e.getMessage(), e);
        }
    }

    private byte[] getByteCode(CtClass managedCtClass) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteStream);
        try {
            managedCtClass.toBytecode(out);
            byte[] byArray = byteStream.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            log.unableToTransformClass(e.getMessage());
            throw new HibernateException("Unable to transform class: " + e.getMessage(), e);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected void addInterceptorHandling(CtClass managedCtClass) {
        if (!this.enhancementContext.hasLazyLoadableAttributes(managedCtClass)) {
            return;
        }
        log.debugf("Weaving in PersistentAttributeInterceptable implementation on [%s]", (Object)managedCtClass.getName());
        managedCtClass.addInterface(this.loadCtClassFromClass(PersistentAttributeInterceptable.class));
        FieldWriter.addFieldWithGetterAndSetter(managedCtClass, this.loadCtClassFromClass(PersistentAttributeInterceptor.class), "$$_hibernate_attributeInterceptor", "$$_hibernate_getInterceptor", "$$_hibernate_setInterceptor");
    }
}

