/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.internal.ast;

import antlr.ASTFactory;
import antlr.Token;
import antlr.collections.AST;
import java.lang.reflect.Constructor;
import org.hibernate.hql.internal.antlr.HqlSqlTokenTypes;
import org.hibernate.hql.internal.ast.HqlSqlWalker;
import org.hibernate.hql.internal.ast.tree.AggregateNode;
import org.hibernate.hql.internal.ast.tree.BetweenOperatorNode;
import org.hibernate.hql.internal.ast.tree.BinaryArithmeticOperatorNode;
import org.hibernate.hql.internal.ast.tree.BinaryLogicOperatorNode;
import org.hibernate.hql.internal.ast.tree.BooleanLiteralNode;
import org.hibernate.hql.internal.ast.tree.CastFunctionNode;
import org.hibernate.hql.internal.ast.tree.CollectionFunction;
import org.hibernate.hql.internal.ast.tree.ConstructorNode;
import org.hibernate.hql.internal.ast.tree.CountNode;
import org.hibernate.hql.internal.ast.tree.DeleteStatement;
import org.hibernate.hql.internal.ast.tree.DotNode;
import org.hibernate.hql.internal.ast.tree.FromClause;
import org.hibernate.hql.internal.ast.tree.FromElement;
import org.hibernate.hql.internal.ast.tree.IdentNode;
import org.hibernate.hql.internal.ast.tree.ImpliedFromElement;
import org.hibernate.hql.internal.ast.tree.InLogicOperatorNode;
import org.hibernate.hql.internal.ast.tree.IndexNode;
import org.hibernate.hql.internal.ast.tree.InitializeableNode;
import org.hibernate.hql.internal.ast.tree.InsertStatement;
import org.hibernate.hql.internal.ast.tree.IntoClause;
import org.hibernate.hql.internal.ast.tree.IsNotNullLogicOperatorNode;
import org.hibernate.hql.internal.ast.tree.IsNullLogicOperatorNode;
import org.hibernate.hql.internal.ast.tree.JavaConstantNode;
import org.hibernate.hql.internal.ast.tree.LiteralNode;
import org.hibernate.hql.internal.ast.tree.MapEntryNode;
import org.hibernate.hql.internal.ast.tree.MapKeyNode;
import org.hibernate.hql.internal.ast.tree.MapValueNode;
import org.hibernate.hql.internal.ast.tree.MethodNode;
import org.hibernate.hql.internal.ast.tree.NullNode;
import org.hibernate.hql.internal.ast.tree.OrderByClause;
import org.hibernate.hql.internal.ast.tree.ParameterNode;
import org.hibernate.hql.internal.ast.tree.QueryNode;
import org.hibernate.hql.internal.ast.tree.ResultVariableRefNode;
import org.hibernate.hql.internal.ast.tree.SearchedCaseNode;
import org.hibernate.hql.internal.ast.tree.SelectClause;
import org.hibernate.hql.internal.ast.tree.SelectExpressionImpl;
import org.hibernate.hql.internal.ast.tree.SessionFactoryAwareNode;
import org.hibernate.hql.internal.ast.tree.SimpleCaseNode;
import org.hibernate.hql.internal.ast.tree.SqlFragment;
import org.hibernate.hql.internal.ast.tree.SqlNode;
import org.hibernate.hql.internal.ast.tree.UnaryArithmeticNode;
import org.hibernate.hql.internal.ast.tree.UnaryLogicOperatorNode;
import org.hibernate.hql.internal.ast.tree.UpdateStatement;

public class SqlASTFactory
extends ASTFactory
implements HqlSqlTokenTypes {
    private HqlSqlWalker walker;

    public SqlASTFactory(HqlSqlWalker walker) {
        this.walker = walker;
    }

    @Override
    public Class getASTNodeType(int tokenType) {
        switch (tokenType) {
            case 45: 
            case 89: {
                return QueryNode.class;
            }
            case 50: {
                return UpdateStatement.class;
            }
            case 13: {
                return DeleteStatement.class;
            }
            case 29: {
                return InsertStatement.class;
            }
            case 30: {
                return IntoClause.class;
            }
            case 22: {
                return FromClause.class;
            }
            case 137: {
                return FromElement.class;
            }
            case 138: {
                return ImpliedFromElement.class;
            }
            case 15: {
                return DotNode.class;
            }
            case 81: {
                return IndexNode.class;
            }
            case 108: 
            case 144: {
                return IdentNode.class;
            }
            case 154: {
                return ResultVariableRefNode.class;
            }
            case 146: {
                return SqlFragment.class;
            }
            case 84: {
                return MethodNode.class;
            }
            case 77: {
                return CastFunctionNode.class;
            }
            case 17: 
            case 27: {
                return CollectionFunction.class;
            }
            case 141: {
                return SelectClause.class;
            }
            case 148: {
                return SelectExpressionImpl.class;
            }
            case 73: {
                return AggregateNode.class;
            }
            case 12: {
                return CountNode.class;
            }
            case 75: {
                return ConstructorNode.class;
            }
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 126: 
            case 129: {
                return LiteralNode.class;
            }
            case 20: 
            case 49: {
                return BooleanLiteralNode.class;
            }
            case 103: {
                return JavaConstantNode.class;
            }
            case 41: {
                return OrderByClause.class;
            }
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: {
                return BinaryArithmeticOperatorNode.class;
            }
            case 93: 
            case 94: {
                return UnaryArithmeticNode.class;
            }
            case 76: {
                return SimpleCaseNode.class;
            }
            case 56: {
                return SearchedCaseNode.class;
            }
            case 128: 
            case 152: {
                return ParameterNode.class;
            }
            case 34: 
            case 87: 
            case 105: 
            case 112: 
            case 114: 
            case 115: 
            case 116: 
            case 117: {
                return BinaryLogicOperatorNode.class;
            }
            case 26: 
            case 86: {
                return InLogicOperatorNode.class;
            }
            case 10: 
            case 85: {
                return BetweenOperatorNode.class;
            }
            case 83: {
                return IsNullLogicOperatorNode.class;
            }
            case 82: {
                return IsNotNullLogicOperatorNode.class;
            }
            case 19: {
                return UnaryLogicOperatorNode.class;
            }
            case 70: {
                return MapKeyNode.class;
            }
            case 71: {
                return MapValueNode.class;
            }
            case 72: {
                return MapEntryNode.class;
            }
            case 39: {
                return NullNode.class;
            }
        }
        return SqlNode.class;
    }

    @Override
    protected AST createUsingCtor(Token token, String className) {
        AST t;
        try {
            Class<?> c = Class.forName(className);
            Class[] tokenArgType = new Class[]{Token.class};
            Constructor<?> ctor = c.getConstructor(tokenArgType);
            if (ctor != null) {
                t = (AST)ctor.newInstance(token);
                this.initializeSqlNode(t);
            } else {
                t = this.create(c);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid class or can't make instance, " + className);
        }
        return t;
    }

    private void initializeSqlNode(AST t) {
        if (t instanceof InitializeableNode) {
            InitializeableNode initializeableNode = (InitializeableNode)((Object)t);
            initializeableNode.initialize(this.walker);
        }
        if (t instanceof SessionFactoryAwareNode) {
            ((SessionFactoryAwareNode)((Object)t)).setSessionFactory(this.walker.getSessionFactoryHelper().getFactory());
        }
    }

    @Override
    protected AST create(Class c) {
        AST t;
        try {
            t = (AST)c.newInstance();
            this.initializeSqlNode(t);
        }
        catch (Exception e) {
            this.error("Can't create AST Node " + c.getName());
            return null;
        }
        return t;
    }
}

