/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.internal.schemagen;

import java.sql.Connection;
import java.sql.SQLException;
import javax.persistence.PersistenceException;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.internal.DDLFormatterImpl;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.jboss.logging.Logger;

class JdbcConnectionContext {
    private static final Logger log = Logger.getLogger(JdbcConnectionContext.class);
    private final JdbcConnectionAccess jdbcConnectionAccess;
    private final SqlStatementLogger sqlStatementLogger;
    private Connection jdbcConnection;

    JdbcConnectionContext(JdbcConnectionAccess jdbcConnectionAccess, SqlStatementLogger sqlStatementLogger) {
        this.jdbcConnectionAccess = jdbcConnectionAccess;
        this.sqlStatementLogger = sqlStatementLogger;
    }

    public Connection getJdbcConnection() {
        if (this.jdbcConnection == null) {
            try {
                this.jdbcConnection = this.jdbcConnectionAccess.obtainConnection();
            }
            catch (SQLException e) {
                throw new PersistenceException("Unable to obtain JDBC Connection", e);
            }
        }
        return this.jdbcConnection;
    }

    public void release() {
        if (this.jdbcConnection != null) {
            try {
                if (!this.jdbcConnection.getAutoCommit()) {
                    this.jdbcConnection.commit();
                }
            }
            catch (SQLException e) {
                log.debug("Unable to commit JDBC transaction used for JPA schema export; may or may not be a problem");
            }
            try {
                this.jdbcConnectionAccess.releaseConnection(this.jdbcConnection);
            }
            catch (SQLException e) {
                throw new PersistenceException("Unable to release JDBC Connection", e);
            }
        }
    }

    public void logSqlStatement(String sqlStatement) {
        this.sqlStatementLogger.logStatement(sqlStatement, DDLFormatterImpl.INSTANCE);
    }
}

