/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.condition;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.springframework.boot.autoconfigure.condition.OnJavaCondition;
import org.springframework.context.annotation.Conditional;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

@Target(value={ElementType.TYPE, ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
@Documented
@Conditional(value={OnJavaCondition.class})
public @interface ConditionalOnJava {
    public Range range() default Range.EQUAL_OR_NEWER;

    public JavaVersion value();

    public static enum JavaVersion {
        NINE(9, "1.9", "java.security.cert.URICertStoreParameters"),
        EIGHT(8, "1.8", "java.util.function.Function"),
        SEVEN(7, "1.7", "java.nio.file.Files"),
        SIX(6, "1.6", "java.util.ServiceLoader");

        private final int value;
        private final String name;
        private final boolean available;

        private JavaVersion(int value, String name, String className) {
            this.value = value;
            this.name = name;
            this.available = ClassUtils.isPresent(className, ((Object)((Object)this)).getClass().getClassLoader());
        }

        public boolean isWithin(Range range, JavaVersion version) {
            Assert.notNull((Object)range, "Range must not be null");
            Assert.notNull((Object)version, "Version must not be null");
            switch (range) {
                case EQUAL_OR_NEWER: {
                    return this.value >= version.value;
                }
                case OLDER_THAN: {
                    return this.value < version.value;
                }
            }
            throw new IllegalStateException("Unknown range " + (Object)((Object)range));
        }

        public String toString() {
            return this.name;
        }

        public static JavaVersion getJavaVersion() {
            for (JavaVersion candidate : JavaVersion.values()) {
                if (!candidate.available) continue;
                return candidate;
            }
            return SIX;
        }
    }

    public static enum Range {
        EQUAL_OR_NEWER,
        OLDER_THAN;

    }
}

